/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.RegionManager;
import org.jboss.cache.commands.DataCommand;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.WriteCommand;
import org.jboss.cache.commands.remote.ClusteredGetCommand;
import org.jboss.cache.commands.remote.DataGravitationCleanupCommand;
import org.jboss.cache.commands.remote.ReplicateCommand;
import org.jboss.cache.commands.tx.AbstractTransactionCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.io.ByteBuffer;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.RegionalizedMethodCall;
import org.jboss.cache.transaction.GlobalTransaction;

public abstract class AbstractMarshaller
implements Marshaller {
    protected boolean useRegionBasedMarshalling;
    protected RegionManager regionManager;
    protected boolean defaultInactive;
    protected Log log;
    protected boolean trace;
    private Map<GlobalTransaction, Fqn> transactions = new ConcurrentHashMap<GlobalTransaction, Fqn>(16);
    protected Configuration configuration;
    protected ClassLoader defaultClassLoader;
    protected boolean useRefs = false;

    @Inject
    void injectDependencies(RegionManager regionManager, Configuration configuration, ClassLoader defaultClassLoader) {
        this.defaultClassLoader = defaultClassLoader;
        this.regionManager = regionManager;
        this.configuration = configuration;
    }

    @Start
    protected void init() {
        this.useRegionBasedMarshalling = this.configuration.isUseRegionBasedMarshalling();
        this.defaultInactive = this.configuration.isInactiveOnStartup();
    }

    protected void initLogger() {
        this.log = LogFactory.getLog(this.getClass());
        this.trace = this.log.isTraceEnabled();
    }

    public byte[] objectToByteBuffer(Object obj) throws Exception {
        ByteBuffer b = this.objectToBuffer(obj);
        byte[] bytes = new byte[b.getLength()];
        System.arraycopy(b.getBuf(), b.getOffset(), bytes, 0, b.getLength());
        return bytes;
    }

    public ByteBuffer objectToBuffer(Object o) throws Exception {
        throw new RuntimeException("Needs to be overridden!");
    }

    public Object objectFromByteBuffer(byte[] bytes) throws Exception {
        return this.objectFromByteBuffer(bytes, 0, bytes.length);
    }

    public Object objectFromByteBuffer(byte[] bytes, int offset, int len) throws Exception {
        throw new RuntimeException("Needs to be overridden!");
    }

    public Object objectFromStream(InputStream in) throws Exception {
        throw new RuntimeException("Needs to be overridden!");
    }

    public RegionalizedMethodCall regionalizedMethodCallFromByteBuffer(byte[] buffer) throws Exception {
        throw new RuntimeException("Needs to be overridden!");
    }

    public RegionalizedMethodCall regionalizedMethodCallFromObjectStream(ObjectInputStream in) throws Exception {
        throw new RuntimeException("Needs to be overridden!");
    }

    protected Fqn extractFqn(ReplicableCommand cmd) {
        if (cmd == null) {
            throw new NullPointerException("Command is null");
        }
        Fqn fqn = null;
        switch (cmd.getCommandId()) {
            case 10: 
            case 18: {
                PrepareCommand pc = (PrepareCommand)cmd;
                List<WriteCommand> modifications = pc.getModifications();
                fqn = this.extractFqn(modifications.get(0));
                if (pc.isOnePhaseCommit()) break;
                this.transactions.put(pc.getGlobalTransaction(), fqn);
                break;
            }
            case 11: 
            case 12: {
                fqn = this.transactions.remove(((AbstractTransactionCommand)cmd).getGlobalTransaction());
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 35: 
            case 47: {
                fqn = ((DataCommand)cmd).getFqn();
                break;
            }
            case 34: {
                fqn = ((DataGravitationCleanupCommand)cmd).getFqn();
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 49: {
                break;
            }
            case 13: {
                fqn = this.extractFqn(((ReplicateCommand)cmd).getSingleModification());
                break;
            }
            case 14: {
                fqn = this.extractFqn(((ReplicateCommand)cmd).getModifications().get(0));
                break;
            }
            case 22: {
                fqn = ((ClusteredGetCommand)cmd).getDataCommand().getFqn();
                break;
            }
            default: {
                if (cmd instanceof DataCommand) {
                    fqn = ((DataCommand)cmd).getFqn();
                    break;
                }
                throw new IllegalArgumentException("AbstractMarshaller.extractFqn(): Unknown id in method call: " + cmd);
            }
        }
        if (this.trace) {
            this.log.trace((Object)("extract(): received " + cmd + "extracted fqn: " + fqn));
        }
        return fqn;
    }
}

