/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.header;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.CacheControl;
import org.exoplatform.services.rest.header.AbstractHeaderDelegate;
import org.exoplatform.services.rest.impl.header.HeaderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheControlHeaderDelegate
extends AbstractHeaderDelegate<CacheControl> {
    @Override
    public Class<CacheControl> support() {
        return CacheControl.class;
    }

    public CacheControl fromString(String header) {
        throw new UnsupportedOperationException("CacheControl used only for response headers.");
    }

    public String toString(CacheControl header) {
        StringBuffer buff = new StringBuffer();
        if (!header.isPrivate()) {
            CacheControlHeaderDelegate.appendString(buff, "public");
        }
        if (header.isPrivate()) {
            CacheControlHeaderDelegate.appendWithParameters(buff, "private", header.getPrivateFields());
        }
        if (header.isNoCache()) {
            CacheControlHeaderDelegate.appendWithParameters(buff, "no-cache", header.getNoCacheFields());
        }
        if (header.isNoStore()) {
            CacheControlHeaderDelegate.appendString(buff, "no-store");
        }
        if (header.isNoTransform()) {
            CacheControlHeaderDelegate.appendString(buff, "no-transform");
        }
        if (header.isMustRevalidate()) {
            CacheControlHeaderDelegate.appendString(buff, "must-revalidate");
        }
        if (header.isProxyRevalidate()) {
            CacheControlHeaderDelegate.appendString(buff, "proxy-revalidate");
        }
        if (header.getMaxAge() >= 0) {
            CacheControlHeaderDelegate.appendString(buff, header.getMaxAge() + "");
        }
        if (header.getSMaxAge() >= 0) {
            CacheControlHeaderDelegate.appendString(buff, header.getSMaxAge() + "");
        }
        for (Map.Entry entry : header.getCacheExtension().entrySet()) {
            CacheControlHeaderDelegate.appendWithSingleParameter(buff, (String)entry.getKey(), (String)entry.getValue());
        }
        return buff.toString();
    }

    private static void appendString(StringBuffer buff, String s) {
        if (buff.length() > 0) {
            buff.append(',').append(' ');
        }
        buff.append(s);
    }

    private static void appendWithSingleParameter(StringBuffer buff, String key, String value) {
        StringBuffer localBuff = new StringBuffer();
        localBuff.append(key);
        if (value != null && value.length() > 0) {
            localBuff.append('=').append(HeaderHelper.addQuotesIfHasWhitespace(value));
        }
        CacheControlHeaderDelegate.appendString(buff, localBuff.toString());
    }

    private static void appendWithParameters(StringBuffer buff, String key, List<String> values) {
        CacheControlHeaderDelegate.appendString(buff, key);
        if (values.size() > 0) {
            StringBuffer localBuff = new StringBuffer();
            buff.append('=');
            buff.append('\"');
            for (String t : values) {
                CacheControlHeaderDelegate.appendString(localBuff, t);
            }
            buff.append(localBuff.toString());
            buff.append('\"');
        }
    }
}

