/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.util.LinkedList;
import java.util.List;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.services.organization.idm.IntegrationCache;
import org.picketlink.idm.cache.APICacheProvider;
import org.picketlink.idm.spi.cache.IdentityStoreCacheProvider;

@Managed
@ManagedDescription(value="PicketLink IDM Cache Service")
@NameTemplate(value={@Property(key="name", value="plidmcache"), @Property(key="service", value="PicketLinkIDMCacheService")})
@RESTEndpoint(path="plidmcache")
public class PicketLinkIDMCacheService {
    private final List<IntegrationCache> integrationCache = new LinkedList<IntegrationCache>();
    private final List<APICacheProvider> apiCacheProviders = new LinkedList<APICacheProvider>();
    private final List<IdentityStoreCacheProvider> storeCacheProviders = new LinkedList<IdentityStoreCacheProvider>();

    public void register(IntegrationCache cacheProvider) {
        if (cacheProvider != null) {
            this.integrationCache.add(cacheProvider);
        }
    }

    public void register(APICacheProvider cacheProvider) {
        if (cacheProvider != null) {
            this.apiCacheProviders.add(cacheProvider);
        }
    }

    public void register(IdentityStoreCacheProvider cacheProvider) {
        if (cacheProvider != null) {
            this.storeCacheProviders.add(cacheProvider);
        }
    }

    @Managed
    @ManagedDescription(value="Invalidate cache namespace")
    @Impact(value=ImpactType.WRITE)
    public void invalidate(@ManagedDescription(value="Cache namespace") @ManagedName(value="namespace") String namespace) {
        for (APICacheProvider aPICacheProvider : this.apiCacheProviders) {
            aPICacheProvider.invalidate(namespace);
        }
        for (IdentityStoreCacheProvider identityStoreCacheProvider : this.storeCacheProviders) {
            identityStoreCacheProvider.invalidate(namespace);
        }
    }

    @Managed
    @ManagedDescription(value="Invalidate all caches")
    @Impact(value=ImpactType.WRITE)
    public void invalidateAll() {
        for (IntegrationCache integrationCache : this.integrationCache) {
            integrationCache.invalidateAll();
        }
        for (APICacheProvider aPICacheProvider : this.apiCacheProviders) {
            aPICacheProvider.invalidateAll();
        }
        for (IdentityStoreCacheProvider identityStoreCacheProvider : this.storeCacheProviders) {
            identityStoreCacheProvider.invalidateAll();
        }
    }

    @Managed
    @ManagedDescription(value="Print content of all caches")
    @Impact(value=ImpactType.READ)
    public String printCaches() {
        StringBuilder builder = new StringBuilder("API CACHE PROVIDERS: \n\n");
        for (APICacheProvider aPICacheProvider : this.apiCacheProviders) {
            builder.append(aPICacheProvider.printContent());
        }
        builder.append("\n\n\nSTORE CACHE PROVIDERS: \n\n");
        for (IdentityStoreCacheProvider identityStoreCacheProvider : this.storeCacheProviders) {
            builder.append(identityStoreCacheProvider.printContent());
        }
        builder.append("\n\n\nINTEGRATION CACHES: \n\n");
        for (IntegrationCache integrationCache : this.integrationCache) {
            builder.append(integrationCache.printContent());
        }
        return builder.toString();
    }
}

