/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.embedder;

import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.embedder.AbstractEmbedder;
import org.exoplatform.commons.embedder.ExoMedia;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class YoutubeEmbedder
extends AbstractEmbedder {
    private static final Log LOG = ExoLogger.getLogger(YoutubeEmbedder.class);
    private static final Pattern YOUTUBE_ID_PATTERN = Pattern.compile("(youtu\\.be\\/|youtube\\.com\\/(watch\\?(.*&)?v=|(embed|v)\\/))([^\\?&\"'>]+)");
    private static final Pattern CONTENT_URL_PATTERN = Pattern.compile(".*youtube\\.com\\/v\\/([^\\&\\?\\/]+)");

    public YoutubeEmbedder(InitParams initParams) {
        super(initParams);
    }

    public Pattern getYouTubeURLPattern() {
        return this.getPattern();
    }

    @Override
    public ExoMedia getExoMedia() {
        String feedsURL = null;
        for (Pattern pattern : this.schemeEndpointMap.keySet()) {
            Matcher matcher = pattern.matcher(this.url);
            if (matcher.find()) {
                feedsURL = (String)this.schemeEndpointMap.get(pattern);
                continue;
            }
            return null;
        }
        try {
            Matcher matcher = YOUTUBE_ID_PATTERN.matcher(this.url);
            String youtubeId = null;
            while (matcher.find()) {
                youtubeId = matcher.group(5);
            }
            String youTubeFeedURL = String.format(feedsURL, youtubeId);
            URL reqURL = new URL(youTubeFeedURL);
            JSONObject jsonObject = this.getJSONObject(reqURL);
            JSONObject entryObject = jsonObject.getJSONObject("entry");
            String html = this.buildHtmlInfo(entryObject.getJSONObject("content"));
            if (html == null) {
                return null;
            }
            JSONObject mediaGroupObject = entryObject.getJSONObject("media$group");
            String title = entryObject.getJSONObject("title").getString("$t");
            String description = "";
            if (mediaGroupObject.has("media$description")) {
                description = mediaGroupObject.getJSONObject("media$description").getString("$t");
            }
            ExoMedia mediaObject = new ExoMedia();
            mediaObject.setTitle(title);
            mediaObject.setHtml(html);
            mediaObject.setDescription(description);
            return mediaObject;
        }
        catch (JSONException e) {
            LOG.debug((Object)"Any syntax error cause to JSON exception.", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.debug((Object)"Problem with IO when open url.", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOG.debug((Object)"Problem occurred when get data from youtube link.", (Throwable)e);
            return null;
        }
    }

    private String buildHtmlInfo(JSONObject contentObject) throws JSONException {
        String videoContentURL = contentObject.getString("src");
        Matcher matcher = CONTENT_URL_PATTERN.matcher(videoContentURL);
        String contentSrc = null;
        while (matcher.find()) {
            contentSrc = matcher.group(0);
        }
        if (contentSrc == null) {
            LOG.info((Object)"Returned content url not match the pattern to get content source.");
            return null;
        }
        String videoPlayerType = contentObject.getString("type");
        StringBuilder contentURL = new StringBuilder();
        contentURL.append("<embed width=\"420\" height=\"345\"").append(" src=\"").append(contentSrc).append("\"").append(" type=\"").append(videoPlayerType).append("\">").append("</embed>");
        return contentURL.toString();
    }

    @Override
    protected Log getExoLogger() {
        return LOG;
    }
}

