/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.util.Random;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Properties;
import org.exoplatform.portal.pom.data.ModelDataStorage;
import org.exoplatform.portal.webui.application.GadgetUtil;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ComponentConfig(template="system:/groovy/portal/webui/application/UIGadget.gtmpl", events={@EventConfig(listeners={SaveUserPrefActionListener.class})})
public class UIGadget
extends UIComponent {
    private String storageId;
    private String storageName;
    private ApplicationState<org.exoplatform.portal.pom.spi.gadget.Gadget> state;
    private String gadgetId;
    private Properties properties_;
    private JSONObject metadata_;
    private String url_;
    private final Logger log = LoggerFactory.getLogger(UIGadget.class);
    public static final String PREF_KEY = "_pref_gadget_";
    public static final String PREF_NO_CACHE = "_pref_no_cache_";
    public static final String PREF_DEBUG = "_pref_debug_";
    public static final String HOME_VIEW = "home";
    public static final String CANVAS_VIEW = "canvas";
    public static final String METADATA_GADGETS = "gadgets";
    public static final String METADATA_USERPREFS = "userPrefs";
    public static final String METADATA_MODULEPREFS = "modulePrefs";
    public static final String METADATA_ERROR = "error";
    public static final String RPC_RESULT = "result";
    public static final String METADATA_USERPREFS_TYPE = "dataType";
    public static final String METADATA_USERPREFS_TYPE_HIDDEN = "hidden";
    public static final String METADATA_USERPREFS_TYPE_LIST = "list";
    public String view = "home";
    public static String SAVE_PREF_FAIL = "UIGadget.savePrefFail";

    public UIGadget() {
        this.storageName = UUID.randomUUID().toString();
    }

    public String getStorageId() {
        return this.storageId;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    public String getStorageName() {
        return this.storageName;
    }

    public void setStorageName(String storageName) {
        this.storageName = storageName;
    }

    public String getId() {
        return this.storageName;
    }

    public String getStandaloneURL() {
        PortalRequestContext portalRC = Util.getPortalRequestContext();
        HttpServletRequest request = portalRC.getRequest();
        StringBuilder urlBuilder = new StringBuilder(request.getScheme());
        urlBuilder.append("://").append(request.getServerName()).append(":").append(request.getServerPort());
        urlBuilder.append(request.getContextPath()).append("/standalone/").append(this.storageId);
        HttpServletResponse response = portalRC.getResponse();
        return response.encodeURL(urlBuilder.toString());
    }

    public ApplicationState<org.exoplatform.portal.pom.spi.gadget.Gadget> getState() {
        return this.state;
    }

    public void setState(ApplicationState<org.exoplatform.portal.pom.spi.gadget.Gadget> state) {
        if (state != null) {
            try {
                String gadgetId;
                DataStorage ds = (DataStorage)this.getApplicationComponent(DataStorage.class);
                this.gadgetId = gadgetId = ds.getId(state);
                this.state = state;
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            this.gadgetId = null;
            this.state = null;
        }
    }

    public String getApplicationName() {
        return this.gadgetId;
    }

    public Properties getProperties() {
        if (this.properties_ == null) {
            this.properties_ = new Properties();
        }
        return this.properties_;
    }

    public void setProperties(Properties properties) {
        this.properties_ = properties;
    }

    @Deprecated
    public String getMetadata() {
        try {
            if (this.metadata_ == null) {
                String strMetadata = GadgetUtil.fetchGagdetRpcMetadata(this.getUrl());
                this.metadata_ = new JSONObject(strMetadata);
            }
            JSONObject obj = this.metadata_.getJSONArray(METADATA_GADGETS).getJSONObject(0);
            String token = GadgetUtil.createToken(this.getUrl(), new Random().nextLong());
            obj.put("secureToken", (Object)token);
            return this.metadata_.toString();
        }
        catch (JSONException e) {
            return null;
        }
    }

    public String getRpcMetadata() {
        try {
            if (this.metadata_ == null) {
                this.metadata_ = this.fetchRpcMetadata();
            }
            String token = GadgetUtil.createToken(this.getUrl(), new Random().nextLong());
            this.metadata_.put("secureToken", (Object)token);
            return this.metadata_.toString();
        }
        catch (JSONException e) {
            return null;
        }
    }

    private JSONObject fetchRpcMetadata() {
        try {
            String gadgetUrl = this.getUrl();
            String strMetadata = GadgetUtil.fetchGagdetRpcMetadata(gadgetUrl);
            JSONObject metadata = new JSONArray(strMetadata).getJSONObject(0).getJSONObject(RPC_RESULT).getJSONObject(gadgetUrl);
            return metadata;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public boolean isSettingUserPref() {
        try {
            JSONObject userPrefs;
            JSONArray names;
            int count;
            if (this.metadata_ != null && (count = (names = (userPrefs = this.metadata_.getJSONObject(METADATA_USERPREFS)).names()).length()) > 0) {
                for (int i = 0; i < count; ++i) {
                    JSONObject o = (JSONObject)userPrefs.get(names.get(i).toString());
                    String prefType = o.optString(METADATA_USERPREFS_TYPE);
                    if (METADATA_USERPREFS_TYPE_HIDDEN.equalsIgnoreCase(prefType) || METADATA_USERPREFS_TYPE_LIST.equalsIgnoreCase(prefType)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isLossData() {
        try {
            DataStorage service = (DataStorage)this.getApplicationComponent(DataStorage.class);
            service.load(this.state, ApplicationType.GADGET);
            if (this.getApplication() == null) {
                throw new Exception();
            }
            if (this.metadata_ == null) {
                this.metadata_ = this.fetchRpcMetadata();
            }
            if (this.metadata_ == null || this.metadata_.has(METADATA_ERROR)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    private Gadget getApplication() {
        try {
            GadgetRegistryService gadgetService = (GadgetRegistryService)this.getApplicationComponent(GadgetRegistryService.class);
            return gadgetService.getGadget(this.gadgetId);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getUrl() {
        if (this.url_ == null) {
            Gadget gadget = this.getApplication();
            this.url_ = GadgetUtil.reproduceUrl(gadget.getUrl(), gadget.isLocal());
        }
        return this.url_;
    }

    public boolean isNoCache() {
        return PropertyManager.isDevelopping();
    }

    public boolean isDebug() {
        return PropertyManager.isDevelopping();
    }

    public String getView() {
        if (this.view != null) {
            return this.view;
        }
        return HOME_VIEW;
    }

    public void setView(String view) {
        this.view = view;
    }

    public String getUserPref() throws Exception {
        DataStorage service = (DataStorage)this.getApplicationComponent(DataStorage.class);
        org.exoplatform.portal.pom.spi.gadget.Gadget pp = (org.exoplatform.portal.pom.spi.gadget.Gadget)service.load(this.state, ApplicationType.GADGET);
        return pp != null ? pp.getUserPref() : null;
    }

    public void addUserPref(String addedUserPref) throws Exception {
        DataStorage service = (DataStorage)this.getApplicationComponent(DataStorage.class);
        org.exoplatform.portal.pom.spi.gadget.Gadget gadget = new org.exoplatform.portal.pom.spi.gadget.Gadget();
        gadget.addUserPref(addedUserPref);
        this.state = service.save(this.state, (Object)gadget);
        ModelDataStorage mds = (ModelDataStorage)this.getApplicationComponent(ModelDataStorage.class);
        mds.save();
    }

    public static class SaveUserPrefActionListener
    extends EventListener<UIGadget> {
        public void execute(Event<UIGadget> event) throws Exception {
            UIGadget uiGadget = (UIGadget)((Object)event.getSource());
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            try {
                uiGadget.addUserPref(event.getRequestContext().getRequestParameter("userPref"));
                Util.getPortalRequestContext().setResponseComplete(true);
            }
            catch (Exception e) {
                UIPortletApplication uiPortlet = (UIPortletApplication)uiGadget.getAncestorOfType(UIPortletApplication.class);
                context.addUIComponentToUpdateByAjax((UIComponent)uiPortlet);
                context.setAttribute(SAVE_PREF_FAIL, (Object)true);
                throw new MessageException(new ApplicationMessage("UIDashboard.msg.ApplicationNotExisted", null, 0));
            }
            if (uiGadget.isLossData()) {
                return;
            }
        }
    }
}

