/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.SyncSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackMetaData<T> {
    private long trackId;
    private T trackBox;

    public TrackMetaData(long trackId, T trackBox) {
        this.trackId = trackId;
        this.trackBox = trackBox;
    }

    public long getTrackId() {
        return this.trackId;
    }

    public T getTrackBox() {
        return this.trackBox;
    }

    public SampleDescriptionBox getSampleDescriptionBox() {
        if (this.trackBox instanceof TrackBox) {
            SampleTableBox sampleTableBox = ((TrackBox)this.trackBox).getBoxes(MediaBox.class, false).get(0).getBoxes(MediaInformationBox.class, false).get(0).getBoxes(SampleTableBox.class, false).get(0);
            return sampleTableBox.getBoxes(SampleDescriptionBox.class, false).get(0);
        }
        if (this.trackBox instanceof TrackFragmentBox) {
            ContainerBox isoFile = ((TrackFragmentBox)this.trackBox).getParent();
            while (isoFile.getParent() != null) {
                isoFile = isoFile.getParent();
            }
            List<MovieBox> movieBoxes = isoFile.getBoxes(MovieBox.class);
            if (movieBoxes != null && !movieBoxes.isEmpty()) {
                MovieBox movieBox = movieBoxes.get(0);
                TrackMetaData<TrackBox> moovTrackMetaData = movieBox.getTrackMetaData(((TrackFragmentBox)this.trackBox).getTrackFragmentHeaderBox().getTrackId());
                return moovTrackMetaData.getSampleDescriptionBox();
            }
            System.out.println("No movie box in file!");
            return null;
        }
        System.out.println("Unsupported trackBox type " + this.trackBox);
        return null;
    }

    public SyncSampleBox getSyncSampleBox() {
        if (this.trackBox instanceof TrackBox) {
            SampleTableBox sampleTableBox = ((TrackBox)this.trackBox).getBoxes(MediaBox.class, false).get(0).getBoxes(MediaInformationBox.class, false).get(0).getBoxes(SampleTableBox.class, false).get(0);
            List<SyncSampleBox> syncSampleBoxes = sampleTableBox.getBoxes(SyncSampleBox.class, false);
            return syncSampleBoxes.isEmpty() ? null : syncSampleBoxes.get(0);
        }
        if (this.trackBox instanceof TrackFragmentBox) {
            List<MovieBox> movieBoxes = ((TrackFragmentBox)this.trackBox).getIsoFile().getBoxes(MovieBox.class, false);
            if (movieBoxes != null && !movieBoxes.isEmpty()) {
                MovieBox movieBox = movieBoxes.get(0);
                TrackMetaData<TrackBox> moovTrackMetaData = movieBox.getTrackMetaData(((TrackFragmentBox)this.trackBox).getTrackFragmentHeaderBox().getTrackId());
                return moovTrackMetaData.getSyncSampleBox();
            }
            System.out.println("No movie box in file!");
            return null;
        }
        System.out.println("Unsupported trackBox type " + this.trackBox);
        return null;
    }
}

