/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.CMAPEncodingEntry;
import org.apache.fontbox.ttf.CMAPTable;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.NameRecord;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.encoding.WinAnsiEncoding;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.FontManager;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorDictionary;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.util.ResourceLoader;

public class PDTrueTypeFont
extends PDSimpleFont {
    private static final Log log = LogFactory.getLog(PDTrueTypeFont.class);
    public static final String UNKNOWN_FONT = "UNKNOWN_FONT";
    private Font awtFont = null;
    private static Properties externalFonts = new Properties();
    private static Map<String, TrueTypeFont> loadedExternalFonts = new HashMap<String, TrueTypeFont>();

    public PDTrueTypeFont() {
        this.font.setItem(COSName.SUBTYPE, (COSBase)COSName.TRUE_TYPE);
    }

    public PDTrueTypeFont(COSDictionary fontDictionary) throws IOException {
        super(fontDictionary);
        this.ensureFontDescriptor();
    }

    public static PDTrueTypeFont loadTTF(PDDocument doc, String file) throws IOException {
        return PDTrueTypeFont.loadTTF(doc, new File(file));
    }

    public static PDTrueTypeFont loadTTF(PDDocument doc, File file) throws IOException {
        return PDTrueTypeFont.loadTTF(doc, new FileInputStream(file));
    }

    public static PDTrueTypeFont loadTTF(PDDocument doc, InputStream stream) throws IOException {
        return PDTrueTypeFont.loadTTF(doc, stream, new WinAnsiEncoding());
    }

    public static PDTrueTypeFont loadTTF(PDDocument doc, InputStream stream, Encoding enc) throws IOException {
        PDStream fontStream = new PDStream(doc, stream, false);
        fontStream.getStream().setInt(COSName.LENGTH1, fontStream.getByteArray().length);
        fontStream.addCompression();
        return PDTrueTypeFont.loadTTF(fontStream, enc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PDTrueTypeFont loadTTF(PDStream fontStream, Encoding enc) throws IOException {
        PDTrueTypeFont retval = new PDTrueTypeFont();
        retval.setFontEncoding(enc);
        retval.setEncoding(enc.getCOSObject());
        PDFontDescriptorDictionary fd = new PDFontDescriptorDictionary();
        retval.setFontDescriptor(fd);
        fd.setFontFile2(fontStream);
        InputStream stream = fontStream.createInputStream();
        try {
            retval.loadDescriptorDictionary(fd, stream);
        }
        finally {
            stream.close();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFontDescriptor() throws IOException {
        if (this.getFontDescriptor() == null) {
            PDFontDescriptorDictionary fdd = new PDFontDescriptorDictionary();
            this.setFontDescriptor(fdd);
            InputStream ttfData = this.getExternalTTFData();
            if (ttfData != null) {
                try {
                    this.loadDescriptorDictionary(fdd, ttfData);
                }
                finally {
                    ttfData.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDescriptorDictionary(PDFontDescriptorDictionary fd, InputStream ttfData) throws IOException {
        TrueTypeFont ttf = null;
        try {
            TTFParser parser = new TTFParser();
            ttf = parser.parseTTF(ttfData);
            NamingTable naming = ttf.getNaming();
            List records = naming.getNameRecords();
            for (int i = 0; i < records.size(); ++i) {
                NameRecord nr = (NameRecord)records.get(i);
                if (nr.getNameId() == 6) {
                    this.setBaseFont(nr.getString());
                    fd.setFontName(nr.getString());
                    continue;
                }
                if (nr.getNameId() != 1) continue;
                fd.setFontFamily(nr.getString());
            }
            OS2WindowsMetricsTable os2 = ttf.getOS2Windows();
            boolean isSymbolic = false;
            switch (os2.getFamilyClass()) {
                case 12: {
                    isSymbolic = true;
                    break;
                }
                case 10: {
                    fd.setScript(true);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    fd.setSerif(true);
                    break;
                }
            }
            switch (os2.getWidthClass()) {
                case 1: {
                    fd.setFontStretch("UltraCondensed");
                    break;
                }
                case 2: {
                    fd.setFontStretch("ExtraCondensed");
                    break;
                }
                case 3: {
                    fd.setFontStretch("Condensed");
                    break;
                }
                case 4: {
                    fd.setFontStretch("SemiCondensed");
                    break;
                }
                case 5: {
                    fd.setFontStretch("Normal");
                    break;
                }
                case 6: {
                    fd.setFontStretch("SemiExpanded");
                    break;
                }
                case 7: {
                    fd.setFontStretch("Expanded");
                    break;
                }
                case 8: {
                    fd.setFontStretch("ExtraExpanded");
                    break;
                }
                case 9: {
                    fd.setFontStretch("UltraExpanded");
                    break;
                }
            }
            fd.setFontWeight(os2.getWeightClass());
            fd.setSymbolic(isSymbolic);
            fd.setNonSymbolic(!isSymbolic);
            HeaderTable header = ttf.getHeader();
            PDRectangle rect = new PDRectangle();
            float scaling = 1000.0f / (float)header.getUnitsPerEm();
            rect.setLowerLeftX((float)header.getXMin() * scaling);
            rect.setLowerLeftY((float)header.getYMin() * scaling);
            rect.setUpperRightX((float)header.getXMax() * scaling);
            rect.setUpperRightY((float)header.getYMax() * scaling);
            fd.setFontBoundingBox(rect);
            HorizontalHeaderTable hHeader = ttf.getHorizontalHeader();
            fd.setAscent((float)hHeader.getAscender() * scaling);
            fd.setDescent((float)hHeader.getDescender() * scaling);
            GlyphTable glyphTable = ttf.getGlyph();
            GlyphData[] glyphs = glyphTable.getGlyphs();
            PostScriptTable ps = ttf.getPostScript();
            fd.setFixedPitch(ps.getIsFixedPitch() > 0L);
            fd.setItalicAngle(ps.getItalicAngle());
            String[] names = ps.getGlyphNames();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    if (names[i].equals("H")) {
                        fd.setCapHeight(glyphs[i].getBoundingBox().getUpperRightY() / scaling);
                    }
                    if (!names[i].equals("x")) continue;
                    fd.setXHeight(glyphs[i].getBoundingBox().getUpperRightY() / scaling);
                }
            }
            fd.setStemV(fd.getFontBoundingBox().getWidth() * 0.13f);
            CMAPTable cmapTable = ttf.getCMAP();
            CMAPEncodingEntry[] cmaps = cmapTable.getCmaps();
            CMAPEncodingEntry uniMap = null;
            for (int i = 0; i < cmaps.length; ++i) {
                int platformEncoding;
                if (cmaps[i].getPlatformId() != 3 || 1 != (platformEncoding = cmaps[i].getPlatformEncodingId())) continue;
                uniMap = cmaps[i];
                break;
            }
            Map<Integer, String> codeToName = this.getFontEncoding().getCodeToNameMap();
            int firstChar = Collections.min(codeToName.keySet());
            int lastChar = Collections.max(codeToName.keySet());
            HorizontalMetricsTable hMet = ttf.getHorizontalMetrics();
            int[] widthValues = hMet.getAdvanceWidth();
            int nWidths = lastChar - firstChar + 1;
            ArrayList<Float> widths = new ArrayList<Float>(nWidths);
            Float zero = Float.valueOf((float)widthValues[0] * scaling);
            for (int i = 0; i < nWidths; ++i) {
                widths.add(zero);
            }
            WinAnsiEncoding glyphlist = WinAnsiEncoding.INSTANCE;
            for (Map.Entry<Integer, String> e : codeToName.entrySet()) {
                String name = e.getValue();
                String c = glyphlist.getCharacter(name);
                int charCode = c.codePointAt(0);
                int gid = uniMap.getGlyphId(charCode);
                if (gid == 0) continue;
                widths.set(e.getKey() - firstChar, Float.valueOf((float)widthValues[gid] * scaling));
            }
            this.setWidths(widths);
            this.setFirstChar(firstChar);
            this.setLastChar(lastChar);
        }
        finally {
            if (ttf != null) {
                ttf.close();
            }
        }
    }

    public Font getawtFont() throws IOException {
        PDFontDescriptorDictionary fd = (PDFontDescriptorDictionary)this.getFontDescriptor();
        if (this.awtFont == null) {
            PDStream ff2Stream = fd.getFontFile2();
            if (ff2Stream != null) {
                try {
                    this.awtFont = Font.createFont(0, ff2Stream.createInputStream());
                }
                catch (FontFormatException f) {
                    log.info((Object)("Can't read the embedded font " + fd.getFontName()));
                }
                if (this.awtFont == null) {
                    this.awtFont = FontManager.getAwtFont(fd.getFontName());
                    if (this.awtFont != null) {
                        log.info((Object)("Using font " + this.awtFont.getName() + " instead"));
                    }
                    this.setIsFontSubstituted(true);
                }
            } else {
                this.awtFont = FontManager.getAwtFont(fd.getFontName());
                if (this.awtFont == null) {
                    log.info((Object)("Can't find the specified font " + fd.getFontName()));
                    TrueTypeFont ttf = this.getExternalFontFile2(fd);
                    if (ttf != null) {
                        try {
                            this.awtFont = Font.createFont(0, ttf.getOriginalData());
                        }
                        catch (FontFormatException f) {
                            log.info((Object)("Can't read the external fontfile " + fd.getFontName()));
                        }
                    }
                }
            }
            if (this.awtFont == null) {
                this.awtFont = FontManager.getStandardFont();
                log.info((Object)("Using font " + this.awtFont.getName() + " instead"));
                this.setIsFontSubstituted(true);
            }
        }
        return this.awtFont;
    }

    private InputStream getExternalTTFData() throws IOException {
        String ttfResource = externalFonts.getProperty(UNKNOWN_FONT);
        String baseFont = this.getBaseFont();
        if (baseFont != null && externalFonts.containsKey(baseFont)) {
            ttfResource = externalFonts.getProperty(baseFont);
        }
        return ttfResource != null ? ResourceLoader.loadResource(ttfResource) : null;
    }

    private TrueTypeFont getExternalFontFile2(PDFontDescriptorDictionary fd) throws IOException {
        TrueTypeFont retval = null;
        if (fd != null) {
            String baseFont = this.getBaseFont();
            String fontResource = externalFonts.getProperty(UNKNOWN_FONT);
            if (baseFont != null && externalFonts.containsKey(baseFont)) {
                fontResource = externalFonts.getProperty(baseFont);
            }
            if (fontResource != null && (retval = loadedExternalFonts.get(baseFont)) == null) {
                TTFParser ttfParser = new TTFParser();
                InputStream fontStream = ResourceLoader.loadResource(fontResource);
                if (fontStream == null) {
                    throw new IOException("Error missing font resource '" + externalFonts.get(baseFont) + "'");
                }
                retval = ttfParser.parseTTF(fontStream);
                loadedExternalFonts.put(baseFont, retval);
            }
        }
        return retval;
    }

    static {
        try {
            ResourceLoader.loadProperties("org/apache/pdfbox/resources/PDFBox_External_Fonts.properties", externalFonts);
        }
        catch (IOException io) {
            throw new RuntimeException("Error loading font resources", io);
        }
    }
}

