/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeNodeTypeSpaceAccessPlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(UpgradeNodeTypeSpaceAccessPlugin.class);
    private static final String NT_PLF_SPACEACCESS = "plf:spaceaccess";
    private RepositoryService repositoryService;
    private static final String DEFAULT_WS = "collaboration";
    String queryStatement = "SELECT * FROM plf:spaceaccess WHERE (jcr:path LIKE '/Users/%') order by exo:dateModified ASC";

    public UpgradeNodeTypeSpaceAccessPlugin(InitParams initParams, RepositoryService repositoryService) throws Exception {
        super(initParams);
        this.repositoryService = repositoryService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)"Start UpgradeNodeTypeSpaceAccessPlugin ...");
        try {
            ExtendedNodeTypeManager nodeTypeManager = this.repositoryService.getCurrentRepository().getNodeTypeManager();
            try {
                this.removeSpaceAccessNodeInstances(this.queryStatement);
                nodeTypeManager.unregisterNodeType(NT_PLF_SPACEACCESS);
            }
            catch (NoSuchNodeTypeException NSNTE) {
                LOG.error((Object)"There is no registered node type with the specified name[plf:spaceaccess]");
            }
            catch (RepositoryException RE) {
                LOG.error((Object)"Can not remove [plf:spaceaccess] nodetype, please check nodes instances with type [plf:spaceaccess]");
            }
            catch (Exception E) {
                LOG.error((Object)"The upgrade plugin can not proceed to remove the node type [plf:spaceaccess]", (Throwable)E);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"UpgradeNodeTypeSpaceAccessPlugin: Upgrade Space nodeTypes failure", (Throwable)e);
        }
        LOG.info((Object)"Finish UpgradeNodeTypeSpaceAccessPlugin ...");
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }

    private boolean removeSpaceAccessNodeInstances(String theQuery) {
        boolean isNodesExists = true;
        QueryResult result = null;
        try {
            result = this.getSpaceAccessNodeInstances(theQuery);
            NodeIterator iter = result.getNodes();
            Node spaceAccessNode = null;
            if (iter.getSize() > 0L) {
                LOG.info((Object)"Remove nodes registered using the Node-Type [plf:spaceaccess] ");
                while (iter.hasNext()) {
                    spaceAccessNode = iter.nextNode();
                    spaceAccessNode.remove();
                    spaceAccessNode.getSession().save();
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Remove node [" + spaceAccessNode.getName() + "]"));
                }
            }
        }
        catch (Exception E) {
            isNodesExists = false;
            LOG.error((Object)"Failed to remove nodes SpaceAccess ", (Throwable)E);
        }
        return isNodesExists;
    }

    private QueryResult getSpaceAccessNodeInstances(String theQuery) {
        Query query = null;
        QueryResult result = null;
        Session session = null;
        try {
            session = this.getSession(false);
            QueryManager manager = session.getWorkspace().getQueryManager();
            query = manager.createQuery(theQuery, "sql");
            result = query.execute();
        }
        catch (Exception E) {
            LOG.error((Object)("Can not execute the jcr query [" + theQuery + "] "), (Throwable)E);
        }
        return result;
    }

    private Session getSession(boolean active) {
        Session session = null;
        try {
            SessionProvider sProvider = CommonsUtils.getSystemSessionProvider();
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            session = sProvider.getSession(DEFAULT_WS, manageableRepository);
        }
        catch (Exception E) {
            LOG.error((Object)"Can not get the jcr session ", (Throwable)E);
        }
        return session;
    }
}

