/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.Writer;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;

@Serialized
@Deprecated
public class UIFormCheckBoxInput<T>
extends UIFormInputBase<T> {
    private boolean checked = false;
    private String onchange_;
    private String componentEvent_ = null;

    public UIFormCheckBoxInput() {
    }

    public UIFormCheckBoxInput(String name, String bindingExpression, T value) {
        super(name, bindingExpression, null);
        if (value != null) {
            this.typeValue_ = value.getClass();
        }
        this.setValue(value);
        this.setId(name);
    }

    @Override
    public UIFormInput setValue(T value) {
        if (value == null) {
            return super.setValue(value);
        }
        if (value instanceof Boolean) {
            this.checked = (Boolean)value;
        } else if (Boolean.TYPE.isInstance(value)) {
            this.checked = Boolean.TYPE.cast(value);
        } else if (value instanceof String) {
            this.checked = Boolean.parseBoolean((String)value);
        }
        this.typeValue_ = value.getClass();
        return super.setValue(value);
    }

    public void setOnChange(String onchange) {
        this.onchange_ = onchange;
    }

    public void setComponentEvent(String com) {
        this.componentEvent_ = com;
    }

    public void setOnChange(String event, String com) {
        this.onchange_ = event;
        this.componentEvent_ = com;
    }

    public String renderOnChangeEvent(UIForm uiForm) throws Exception {
        if (this.componentEvent_ == null) {
            return uiForm.event(this.onchange_, null);
        }
        return uiForm.event(this.onchange_, this.componentEvent_, null);
    }

    public final boolean isChecked() {
        return this.checked;
    }

    public final UIFormCheckBoxInput setChecked(boolean check) {
        this.checked = check;
        return this;
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) {
        if (this.isDisabled()) {
            return;
        }
        boolean bl = this.checked = input != null && !"false".equals(input.toString());
        if (this.typeValue_ == Boolean.class || this.typeValue_ == Boolean.TYPE) {
            this.value_ = this.typeValue_.cast(this.checked);
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        ResourceBundle res = context.getApplicationResourceBundle();
        String label = this.getId() + ".label";
        try {
            label = res.getString(label);
        }
        catch (MissingResourceException e) {
            label = null;
        }
        Writer w = context.getWriter();
        if (label != null) {
            w.write("<label class=\"uiCheckbox\">");
        } else {
            w.write("<span class=\"uiCheckbox\">");
        }
        w.append("<input type='checkbox' id=\"").append(this.getId()).append("\" name='");
        w.write(this.name);
        w.write("'");
        if (this.onchange_ != null) {
            UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
            w.append(" onclick=\"").append(this.renderOnChangeEvent(uiForm)).append("\"");
        }
        if (this.checked) {
            w.write(" checked ");
        }
        if (this.isDisabled()) {
            w.write(" disabled ");
        }
        this.renderHTMLAttributes(w);
        w.write(" class='checkbox'/><span>");
        if (label != null) {
            w.write(label);
            w.write("</span></label>");
        } else {
            w.write("</span></span>");
        }
        if (this.isMandatory()) {
            w.write(" *");
        }
    }
}

