/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.spi.juzu.compiler;

import juzu.impl.common.MethodInvocation;
import juzu.impl.common.Path;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.template.spi.ProcessContext;
import juzu.impl.template.spi.Template;
import juzu.impl.template.spi.juzu.ast.ASTNode;
import juzu.impl.template.spi.juzu.compiler.CompilationPhase;
import juzu.impl.template.spi.juzu.compiler.ExtendedTagHandler;
import juzu.template.TagHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessPhase
extends CompilationPhase {
    private final ProcessContext context;
    private Path.Relative originPath;

    public ProcessPhase(ProcessContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Template<ASTNode.Template> template) {
        boolean initial;
        if (this.originPath == null) {
            this.originPath = template.getRelativePath();
            initial = true;
        } else {
            initial = false;
        }
        try {
            this.doAttribute(template.getModel());
            this.doProcess(template, template.getModel());
            this.doResolve(template, template.getModel());
            this.doUnattribute(template.getModel());
            Object var4_3 = null;
            if (initial) {
                this.originPath = null;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (initial) {
                this.originPath = null;
            }
            throw throwable;
        }
    }

    public Template resolveTemplate(Path.Relative path) throws ProcessingException {
        return this.context.resolveTemplate(this.originPath, path);
    }

    private void doProcess(Template<ASTNode.Template> template, ASTNode<?> node) throws ProcessingException {
        block5: {
            block6: {
                block4: {
                    if (!(node instanceof ASTNode.Template)) break block4;
                    for (ASTNode.Block<?> child : node.getChildren()) {
                        this.doProcess(template, child);
                    }
                    break block5;
                }
                if (node instanceof ASTNode.Section) break block5;
                if (!(node instanceof ASTNode.URL)) break block6;
                ASTNode.URL url = (ASTNode.URL)node;
                MethodInvocation mi = this.context.resolveMethodInvocation(url.getTypeName(), url.getMethodName(), url.getArgs());
                if (mi == null) {
                    throw new UnsupportedOperationException("handle me gracefully");
                }
                url.setInvocation(mi);
                break block5;
            }
            if (!(node instanceof ASTNode.Tag)) break block5;
            ASTNode.Tag nodeTag = (ASTNode.Tag)node;
            TagHandler handler = this.get(nodeTag);
            if (handler instanceof ExtendedTagHandler) {
                ((ExtendedTagHandler)handler).process(this, nodeTag, template);
            }
            for (ASTNode.Block<?> child : nodeTag.getChildren()) {
                this.doProcess(template, child);
            }
        }
    }

    private void doResolve(Template<ASTNode.Template> template, ASTNode<?> node) throws ProcessingException {
        block4: {
            block3: {
                if (!(node instanceof ASTNode.Template)) break block3;
                for (ASTNode.Block<?> child : node.getChildren()) {
                    this.doResolve(template, child);
                }
                break block4;
            }
            if (node instanceof ASTNode.Section || node instanceof ASTNode.URL || !(node instanceof ASTNode.Tag)) break block4;
            ASTNode.Tag nodeTag = (ASTNode.Tag)node;
            TagHandler handler = this.get(nodeTag);
            if (handler instanceof ExtendedTagHandler) {
                ((ExtendedTagHandler)handler).compile(this, nodeTag, template);
            }
            for (ASTNode.Block<?> child : nodeTag.getChildren()) {
                this.doResolve(template, child);
            }
        }
    }
}

