/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import com.coremedia.iso.IsoBufferWrapper;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ESDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ExtensionDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ObjectDescriptorBase;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ObjectDescriptorFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class InitialObjectDescriptor
extends ObjectDescriptorBase {
    private int objectDescriptorId;
    int urlFlag;
    int includeInlineProfileLevelFlag;
    int urlLength;
    String urlString;
    int oDProfileLevelIndication;
    int sceneProfileLevelIndication;
    int audioProfileLevelIndication;
    int visualProfileLevelIndication;
    int graphicsProfileLevelIndication;
    List<ESDescriptor> esDescriptors = new ArrayList<ESDescriptor>();
    List<ExtensionDescriptor> extensionDescriptors = new ArrayList<ExtensionDescriptor>();
    List<BaseDescriptor> unknownDescriptors = new ArrayList<BaseDescriptor>();

    public void parse(int tag, IsoBufferWrapper in, int maxLength) throws IOException {
        BaseDescriptor descriptor;
        super.parse(tag, in, maxLength);
        int data = in.readUInt16();
        this.objectDescriptorId = (data & 0xFFC0) >> 6;
        this.urlFlag = (data & 0x3F) >> 5;
        this.includeInlineProfileLevelFlag = (data & 0x1F) >> 4;
        int sizeLeft = this.getSize() - 2;
        if (this.urlFlag == 1) {
            this.urlLength = in.readUInt8();
            this.urlString = new String(in.read(this.urlLength));
            sizeLeft -= 1 + this.urlLength;
        } else {
            this.oDProfileLevelIndication = in.readUInt8();
            this.sceneProfileLevelIndication = in.readUInt8();
            this.audioProfileLevelIndication = in.readUInt8();
            this.visualProfileLevelIndication = in.readUInt8();
            this.graphicsProfileLevelIndication = in.readUInt8();
            if ((sizeLeft -= 5) > 2) {
                descriptor = ObjectDescriptorFactory.createFrom(-1, in, sizeLeft);
                sizeLeft -= descriptor.getSize();
                if (descriptor instanceof ESDescriptor) {
                    this.esDescriptors.add((ESDescriptor)descriptor);
                } else {
                    this.unknownDescriptors.add(descriptor);
                }
            }
        }
        if (sizeLeft > 2) {
            descriptor = ObjectDescriptorFactory.createFrom(-1, in, sizeLeft);
            sizeLeft -= descriptor.getSize();
            if (descriptor instanceof ExtensionDescriptor) {
                this.extensionDescriptors.add((ExtensionDescriptor)descriptor);
            } else {
                this.unknownDescriptors.add(descriptor);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InitialObjectDescriptor");
        sb.append("{objectDescriptorId=").append(this.objectDescriptorId);
        sb.append(", urlFlag=").append(this.urlFlag);
        sb.append(", includeInlineProfileLevelFlag=").append(this.includeInlineProfileLevelFlag);
        sb.append(", urlLength=").append(this.urlLength);
        sb.append(", urlString='").append(this.urlString).append('\'');
        sb.append(", oDProfileLevelIndication=").append(this.oDProfileLevelIndication);
        sb.append(", sceneProfileLevelIndication=").append(this.sceneProfileLevelIndication);
        sb.append(", audioProfileLevelIndication=").append(this.audioProfileLevelIndication);
        sb.append(", visualProfileLevelIndication=").append(this.visualProfileLevelIndication);
        sb.append(", graphicsProfileLevelIndication=").append(this.graphicsProfileLevelIndication);
        sb.append(", esDescriptors=").append(this.esDescriptors);
        sb.append(", extensionDescriptors=").append(this.extensionDescriptors);
        sb.append(", unknownDescriptors=").append(this.unknownDescriptors);
        sb.append('}');
        return sb.toString();
    }
}

