/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.Collections;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.module.ModuleCommandInitializer;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.factories.BootstrapFactory;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.components.ComponentMetadata;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class ComponentRegistry
extends AbstractComponentRegistry {
    private final GlobalComponentRegistry globalComponents;
    private final String cacheName;
    private static final Log log = LogFactory.getLog(ComponentRegistry.class);
    private CacheManagerNotifier cacheManagerNotifier;
    private StreamingMarshaller cacheMarshaler;
    private StateTransferManager stateTransferManager;
    private ResponseGenerator responseGenerator;
    private CommandsFactory commandsFactory;

    @Inject
    public void setCacheManagerNotifier(CacheManagerNotifier cacheManagerNotifier) {
        this.cacheManagerNotifier = cacheManagerNotifier;
    }

    public ComponentRegistry(String cacheName, Configuration configuration, AdvancedCache<?, ?> cache, GlobalComponentRegistry globalComponents, ClassLoader defaultClassLoader) {
        super(defaultClassLoader);
        try {
            this.cacheName = cacheName;
            if (cacheName == null) {
                throw new ConfigurationException("Cache name cannot be null!");
            }
            if (globalComponents == null) {
                throw new NullPointerException("GlobalComponentRegistry cannot be null!");
            }
            this.globalComponents = globalComponents;
            this.registerComponent((Object)this, ComponentRegistry.class);
            this.registerComponent((Object)configuration, Configuration.class);
            this.registerComponent((Object)new BootstrapFactory(cache, configuration, this), BootstrapFactory.class);
            Map<Byte, ModuleCommandInitializer> initializers = globalComponents.getModuleCommandInitializers();
            if (initializers != null && !initializers.isEmpty()) {
                this.registerNonVolatileComponent(initializers, "org.infinispan.modules.command.initializers");
                for (ModuleCommandInitializer mci : initializers.values()) {
                    this.registerNonVolatileComponent((Object)mci, mci.getClass());
                }
            } else {
                this.registerNonVolatileComponent(Collections.emptyMap(), "org.infinispan.modules.command.initializers");
            }
        }
        catch (Exception e) {
            throw new CacheException("Unable to construct a ComponentRegistry!", e);
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public final <T> T getComponent(String componentTypeName, String name, boolean nameIsFQCN) {
        if (this.isGlobal(nameIsFQCN ? name : componentTypeName)) {
            return this.globalComponents.getComponent(componentTypeName, name, nameIsFQCN);
        }
        return this.getLocalComponent(componentTypeName, name, nameIsFQCN);
    }

    public final <T> T getLocalComponent(String componentTypeName, String name, boolean nameIsFQCN) {
        return super.getComponent(componentTypeName, name, nameIsFQCN);
    }

    public final <T> T getLocalComponent(Class<T> componentType) {
        String componentTypeName = componentType.getName();
        return this.getLocalComponent(componentTypeName, componentTypeName, true);
    }

    @Override
    protected final AbstractComponentRegistry.Component lookupComponent(String componentClassName, String name, boolean nameIsFQCN) {
        if (this.isGlobal(nameIsFQCN ? name : componentClassName)) {
            return this.globalComponents.lookupComponent(componentClassName, name, nameIsFQCN);
        }
        return this.lookupLocalComponent(componentClassName, name, nameIsFQCN);
    }

    protected final AbstractComponentRegistry.Component lookupLocalComponent(String componentClassName, String name, boolean nameIsFQCN) {
        return super.lookupComponent(componentClassName, name, nameIsFQCN);
    }

    public final GlobalComponentRegistry getGlobalComponentRegistry() {
        return this.globalComponents;
    }

    @Override
    protected void registerComponentInternal(Object component, String name, boolean nameIsFQCN) {
        if (this.isGlobal(nameIsFQCN ? name : component.getClass().getName())) {
            this.globalComponents.registerComponentInternal(component, name, nameIsFQCN);
        } else {
            super.registerComponentInternal(component, name, nameIsFQCN);
        }
    }

    private boolean isGlobal(String className) {
        ComponentMetadata m = ComponentMetadataRepo.findComponentMetadata(className);
        return m != null && m.isGlobalScope();
    }

    @Override
    public void start() {
        this.globalComponents.start();
        boolean needToNotify = this.state != ComponentStatus.RUNNING && this.state != ComponentStatus.INITIALIZING;
        this.globalComponents.registerNamedComponentRegistry(this, this.cacheName);
        super.start();
        if (needToNotify && this.state == ComponentStatus.RUNNING) {
            for (ModuleLifecycle l : this.globalComponents.moduleLifecycles) {
                l.cacheStarted(this, this.cacheName);
            }
            this.cacheManagerNotifier.notifyCacheStarted(this.cacheName);
        }
    }

    void notifyCacheStarting(Configuration configuration) {
        for (ModuleLifecycle l : this.globalComponents.moduleLifecycles) {
            l.cacheStarting(this, configuration, this.cacheName);
        }
    }

    @Override
    public void stop() {
        boolean needToNotify;
        if (this.state.stopAllowed()) {
            this.globalComponents.unregisterNamedComponentRegistry(this.cacheName);
        }
        boolean bl = needToNotify = this.state == ComponentStatus.RUNNING || this.state == ComponentStatus.INITIALIZING;
        if (needToNotify) {
            for (ModuleLifecycle l : this.globalComponents.moduleLifecycles) {
                l.cacheStopping(this, this.cacheName);
            }
        }
        super.stop();
        if (this.state == ComponentStatus.TERMINATED && needToNotify) {
            for (ModuleLifecycle l : this.globalComponents.moduleLifecycles) {
                l.cacheStopped(this, this.cacheName);
            }
            this.cacheManagerNotifier.notifyCacheStopped(this.cacheName);
        }
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public StreamingMarshaller getCacheMarshaller() {
        return this.cacheMarshaler;
    }

    public StateTransferManager getStateTransferManager() {
        return this.stateTransferManager;
    }

    public ResponseGenerator getResponseGenerator() {
        return this.responseGenerator;
    }

    public CommandsFactory getCommandsFactory() {
        return this.commandsFactory;
    }

    public void prepareWiringCache() {
        this.cacheMarshaler = this.getComponent(StreamingMarshaller.class, "org.infinispan.marshaller.cache");
        this.stateTransferManager = this.getComponent(StateTransferManager.class);
        this.responseGenerator = this.getComponent(ResponseGenerator.class);
        this.commandsFactory = this.getLocalComponent(CommandsFactory.class);
    }
}

