/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.JmxStatsCommandInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.modifications.Clear;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.ConcurrentMapFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.MeasurementType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import org.rhq.helpers.pluginAnnotations.agent.Operation;

@MBean(objectName="CacheStore", description="Component that handles storing of entries to a CacheStore from memory.")
public class CacheStoreInterceptor
extends JmxStatsCommandInterceptor {
    CacheLoaderManagerConfig loaderConfig = null;
    private Map<GlobalTransaction, Integer> txStores;
    private Map<GlobalTransaction, Set<Object>> preparingTxs;
    final AtomicLong cacheStores = new AtomicLong(0L);
    CacheStore store;
    private CacheLoaderManager loaderManager;
    private InternalEntryFactory entryFactory;
    private TransactionManager transactionManager;
    private static final Log log = LogFactory.getLog(CacheStoreInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    protected void init(CacheLoaderManager loaderManager, InternalEntryFactory entryFactory, TransactionManager transactionManager) {
        this.loaderManager = loaderManager;
        this.entryFactory = entryFactory;
        this.transactionManager = transactionManager;
    }

    @Start(priority=15)
    protected void start() {
        this.store = this.loaderManager.getCacheStore();
        this.setStatisticsEnabled(this.configuration.isExposeJmxStatistics());
        this.loaderConfig = this.configuration.getCacheLoaderManagerConfig();
        this.txStores = ConcurrentMapFactory.makeConcurrentMap(64, this.configuration.getConcurrencyLevel());
        this.preparingTxs = ConcurrentMapFactory.makeConcurrentMap(64, this.configuration.getConcurrencyLevel());
    }

    protected boolean skip(InvocationContext ctx) {
        if (this.store == null) {
            return true;
        }
        if (!ctx.isOriginLocal() && this.loaderConfig.isShared().booleanValue() || ctx.hasFlag(Flag.SKIP_CACHE_STORE)) {
            log.trace("Skipping cache store since the cache loader is shared and we are not the originator.");
            return true;
        }
        if (this.loaderConfig.isShared().booleanValue() && ctx.hasFlag(Flag.SKIP_SHARED_CACHE_STORE)) {
            log.trace("Explicitly requested to skip storage if cache store is shared - and it is.");
            return true;
        }
        return false;
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!this.skip(ctx)) {
            this.commitCommand(ctx);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitCommand(TxInvocationContext ctx) throws Throwable {
        if (ctx.hasModifications()) {
            GlobalTransaction tx = ctx.getGlobalTransaction();
            if (this.getLog().isTraceEnabled()) {
                this.getLog().tracef("Calling loader.commit() for transaction %s", tx);
            }
            Transaction xaTx = null;
            if (this.transactionManager != null) {
                xaTx = this.transactionManager.suspend();
            }
            try {
                this.store.commit(tx);
            }
            finally {
                this.preparingTxs.remove(tx);
                if (this.transactionManager != null && xaTx != null) {
                    this.transactionManager.resume(xaTx);
                }
            }
            if (this.getStatisticsEnabled()) {
                Integer puts = this.txStores.get(tx);
                if (puts != null) {
                    this.cacheStores.getAndAdd(puts.intValue());
                }
                this.txStores.remove(tx);
            }
        } else if (this.getLog().isTraceEnabled()) {
            this.getLog().trace("Commit called with no modifications; ignoring.");
        }
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (!this.skip(ctx)) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace("Transactional so don't put stuff in the cache store yet.");
            }
            if (ctx.hasModifications()) {
                GlobalTransaction tx = ctx.getGlobalTransaction();
                if (this.preparingTxs.containsKey(tx)) {
                    this.preparingTxs.remove(tx);
                    this.store.rollback(tx);
                }
                if (this.getStatisticsEnabled()) {
                    this.txStores.remove(tx);
                }
            } else if (this.getLog().isTraceEnabled()) {
                this.getLog().trace("Rollback called with no modifications; ignoring.");
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!this.skip(ctx)) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace("Transactional so don't put stuff in the cache store yet.");
            }
            this.prepareCacheLoader(ctx, command.getGlobalTransaction(), ctx, command.isOnePhaseCommit());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (!this.skip(ctx) && !ctx.isInTxScope() && command.isSuccessful()) {
            Object key = command.getKey();
            boolean resp = this.store.remove(key);
            if (this.getLog().isTraceEnabled()) {
                this.getLog().tracef("Removed entry under key %s and got response %s from CacheStore", key, resp);
            }
        }
        return retval;
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (!this.skip(ctx) && !ctx.isInTxScope()) {
            this.clearCacheStore();
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    protected void clearCacheStore() throws CacheLoaderException {
        this.store.clear();
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace("Cleared cache store");
        }
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (this.skip(ctx) || ctx.isInTxScope() || !command.isSuccessful()) {
            return returnValue;
        }
        Object key = command.getKey();
        InternalCacheEntry se = this.getStoredEntry(key, ctx);
        this.store.store(se);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Stored entry %s under key %s", se, key);
        }
        if (this.getStatisticsEnabled()) {
            this.cacheStores.incrementAndGet();
        }
        return returnValue;
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (this.skip(ctx) || ctx.isInTxScope() || !command.isSuccessful()) {
            return returnValue;
        }
        Object key = command.getKey();
        InternalCacheEntry se = this.getStoredEntry(key, ctx);
        this.store.store(se);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Stored entry %s under key %s", se, key);
        }
        if (this.getStatisticsEnabled()) {
            this.cacheStores.incrementAndGet();
        }
        return returnValue;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (this.skip(ctx) || ctx.isInTxScope()) {
            return returnValue;
        }
        Map<Object, Object> map = command.getMap();
        for (Object key : map.keySet()) {
            InternalCacheEntry se = this.getStoredEntry(key, ctx);
            this.store.store(se);
            if (!this.getLog().isTraceEnabled()) continue;
            this.getLog().tracef("Stored entry %s under key %s", se, key);
        }
        if (this.getStatisticsEnabled()) {
            this.cacheStores.getAndAdd(map.size());
        }
        return returnValue;
    }

    protected final void prepareCacheLoader(TxInvocationContext ctx, GlobalTransaction gtx, TxInvocationContext transactionContext, boolean onePhase) throws Throwable {
        if (transactionContext == null) {
            throw new Exception("transactionContext for transaction " + gtx + " not found in transaction table");
        }
        List<WriteCommand> modifications = transactionContext.getModifications();
        if (!transactionContext.hasModifications()) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace("Transaction has not logged any modifications!");
            }
            return;
        }
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Cache loader modification list: %s", modifications);
        }
        StoreModificationsBuilder modsBuilder = new StoreModificationsBuilder(this.getStatisticsEnabled(), modifications.size());
        for (WriteCommand cacheCommand : modifications) {
            cacheCommand.acceptVisitor(ctx, modsBuilder);
        }
        int numMods = modsBuilder.modifications.size();
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Converted method calls to cache loader modifications.  List size: %s", numMods);
        }
        if (numMods > 0) {
            GlobalTransaction tx = transactionContext.getGlobalTransaction();
            this.store.prepare(modsBuilder.modifications, tx, onePhase);
            this.preparingTxs.put(tx, modsBuilder.affectedKeys);
            if (this.getStatisticsEnabled() && modsBuilder.putCount > 0) {
                this.txStores.put(tx, modsBuilder.putCount);
            }
        }
    }

    protected boolean skipKey(Object key) {
        return false;
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component")
    @Operation(displayName="Reset statistics")
    public void resetStatistics() {
        this.cacheStores.set(0L);
    }

    @ManagedAttribute(description="number of cache loader stores")
    @Metric(displayName="Number of cache stores", measurementType=MeasurementType.TRENDSUP)
    public long getCacheLoaderStores() {
        return this.cacheStores.get();
    }

    InternalCacheEntry getStoredEntry(Object key, InvocationContext ctx) {
        CacheEntry entry = ctx.lookupEntry(key);
        if (entry instanceof InternalCacheEntry) {
            return (InternalCacheEntry)entry;
        }
        return this.entryFactory.create(entry);
    }

    public class StoreModificationsBuilder
    extends AbstractVisitor {
        private final boolean generateStatistics;
        int putCount;
        private final Set<Object> affectedKeys;
        private final List<Modification> modifications;

        public StoreModificationsBuilder(boolean generateStatistics, int numMods) {
            this.generateStatistics = generateStatistics;
            this.affectedKeys = new HashSet<Object>(numMods);
            this.modifications = new ArrayList<Modification>(numMods);
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.visitSingleStore(ctx, command.getKey());
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            return this.visitSingleStore(ctx, command.getKey());
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            Map<Object, Object> map = command.getMap();
            for (Object key : map.keySet()) {
                this.visitSingleStore(ctx, key);
            }
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            Object key = command.getKey();
            if (!CacheStoreInterceptor.this.skipKey(key)) {
                this.modifications.add(new Remove(key));
                this.affectedKeys.add(command.getKey());
            }
            return null;
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            this.modifications.add(new Clear());
            return null;
        }

        private Object visitSingleStore(InvocationContext ctx, Object key) throws Throwable {
            if (!CacheStoreInterceptor.this.skipKey(key)) {
                if (this.generateStatistics) {
                    ++this.putCount;
                }
                this.modifications.add(new Store(CacheStoreInterceptor.this.getStoredEntry(key, ctx)));
                this.affectedKeys.add(key);
            }
            return null;
        }
    }
}

