/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.ClusteredRepeatableReadEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.transaction.WriteSkewException;
import org.infinispan.transaction.xa.CacheTransaction;

public class WriteSkewHelper {
    public static void setVersionsSeenOnPrepareCommand(VersionedPrepareCommand command, TxInvocationContext context) {
        EntryVersionsMap vs = new EntryVersionsMap();
        for (WriteCommand wc : command.getModifications()) {
            for (Object k : wc.getAffectedKeys()) {
                vs.put(k, (IncrementableEntryVersion)context.lookupEntry(k).getVersion());
            }
        }
        command.setVersionsSeen(vs);
    }

    public static void readVersionsFromResponse(Response r, CacheTransaction ct) {
        SuccessfulResponse sr;
        EntryVersionsMap uv;
        if (r != null && r.isSuccessful() && (uv = (EntryVersionsMap)(sr = (SuccessfulResponse)r).getResponseValue()) != null) {
            ct.setUpdatedEntryVersions(uv.merge(ct.getUpdatedEntryVersions()));
        }
    }

    public static EntryVersionsMap performWriteSkewCheckAndReturnNewVersions(VersionedPrepareCommand prepareCommand, DataContainer dataContainer, VersionGenerator versionGenerator, TxInvocationContext context, KeySpecificLogic ksl) {
        EntryVersionsMap uv = new EntryVersionsMap();
        for (WriteCommand c : prepareCommand.getModifications()) {
            for (Object k : c.getAffectedKeys()) {
                EntryVersion versionSeen;
                if (!ksl.performCheckOnKey(k)) continue;
                ClusteredRepeatableReadEntry entry = (ClusteredRepeatableReadEntry)context.lookupEntry(k);
                if (!context.isOriginLocal() && (versionSeen = (EntryVersion)prepareCommand.getVersionsSeen().get(k)) != null) {
                    entry.setVersion(versionSeen);
                }
                if (entry.performWriteSkewCheck(dataContainer)) {
                    IncrementableEntryVersion newVersion = entry.isCreated() ? versionGenerator.generateNew() : versionGenerator.increment((IncrementableEntryVersion)entry.getVersion());
                    uv.put(k, newVersion);
                    continue;
                }
                throw new WriteSkewException("Write skew detected on key " + k + " for transaction " + context.getTransaction());
            }
        }
        return uv;
    }

    public static interface KeySpecificLogic {
        public boolean performCheckOnKey(Object var1);
    }
}

