/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;

public class DeadlockTest {
    private static final Class[] TYPES = new Class[0];
    private static final Object[] ARGS = new Object[0];
    private String name = "JG";
    private String stack = null;
    private JChannel channel;
    private RpcDispatcher disp;

    private void _in_rpc_1() {
        System.out.println("In rpc_1()");
        this.cast_call("rpc_2", ARGS, TYPES);
        System.out.println("Exiting rpc_1()");
    }

    private void _in_rpc_2() {
        System.out.println("In rpc_2()");
        System.out.println("Exiting rpc_2()");
    }

    private void cast_call(String method, Object[] args, Class[] types) {
        MethodCall call = new MethodCall(method, args, types);
        this.disp.callRemoteMethods(null, call, 2, 0L);
    }

    public DeadlockTest(boolean use_deadlock_detection) {
        Handler handler = new Handler();
        InRpc in_rpc = new InRpc();
        try {
            this.channel = new JChannel(this.stack);
            this.disp = new RpcDispatcher((Channel)this.channel, (MessageListener)handler, (MembershipListener)handler, in_rpc, use_deadlock_detection);
            this.channel.connect(this.name);
        }
        catch (ChannelClosedException ex) {
            ex.printStackTrace();
        }
        catch (ChannelException ex) {
            ex.printStackTrace();
        }
        System.out.println("Calling rpc_1()");
        if (!use_deadlock_detection) {
            System.out.println("** Not using deadlock detection -- recursive call will hang !");
        } else {
            System.out.println("** Using deadlock detection -- recursive call will succeed");
        }
        this.cast_call("rpc_1", ARGS, TYPES);
        System.out.println("Out of rpc_1()");
        this.channel.disconnect();
        this.channel.close();
        System.out.println("Disconnected");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("DeadlockTest <true|false (use_deadlock_detection)>");
            return;
        }
        new DeadlockTest(Boolean.valueOf(args[0]));
    }

    private static class Handler
    implements MessageListener,
    MembershipListener {
        @Override
        public byte[] getState() {
            return null;
        }

        @Override
        public void setState(byte[] state) {
        }

        @Override
        public void receive(Message msg) {
        }

        @Override
        public void block() {
        }

        @Override
        public void suspect(Address suspect) {
        }

        @Override
        public void viewAccepted(View view) {
        }
    }

    public class InRpc {
        public void rpc_1() {
            DeadlockTest.this._in_rpc_1();
        }

        public void rpc_2() {
            DeadlockTest.this._in_rpc_2();
        }
    }
}

