/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Shorts;
import com.google.debugging.sourcemap.SourceMapConsumer;
import com.google.debugging.sourcemap.SourceMapParseException;
import com.google.debugging.sourcemap.proto.Mapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SourceMapConsumerV1
implements SourceMapConsumer {
    private static final String LINEMAP_HEADER = "/** Begin line maps. **/";
    private static final String FILEINFO_HEADER = "/** Begin file information. **/";
    private static final String DEFINITION_HEADER = "/** Begin mapping definitions. **/";
    private ImmutableList<ImmutableList<LineFragment>> characterMap;
    private ImmutableList<SourceFile> mappings;

    @Override
    public void parse(String contents) throws SourceMapParseException {
        ParseState parser = new ParseState(contents);
        try {
            this.parseInternal(parser);
        }
        catch (JSONException ex) {
            parser.fail("JSON parse exception: " + (Object)((Object)ex));
        }
    }

    private int parseCharacterMap(ParseState parser, int lineCount, ImmutableList.Builder<ImmutableList<LineFragment>> characterMapBuilder) throws SourceMapParseException, JSONException {
        int maxID = -1;
        for (int i = 0; i < lineCount; ++i) {
            String currentLine = parser.readLine();
            if (currentLine.isEmpty()) continue;
            ImmutableList.Builder fragmentList = ImmutableList.builder();
            LineFragment myLineFragment = null;
            JSONArray charArray = new JSONArray(currentLine);
            int numOffsets = charArray.length();
            int lastID = -1;
            int startID = Integer.MIN_VALUE;
            ArrayList currentOffsets = Lists.newArrayList();
            for (int j = 0; j < charArray.length(); ++j) {
                int mappingID = lastID;
                if (!charArray.isNull(j) && (mappingID = charArray.optInt(j)) > maxID) {
                    maxID = mappingID;
                }
                if (startID == Integer.MIN_VALUE) {
                    startID = mappingID;
                } else if (mappingID - lastID > 127 || mappingID - lastID < -128) {
                    myLineFragment = new LineFragment(startID, Bytes.toArray((Collection)currentOffsets));
                    currentOffsets.clear();
                    fragmentList.add((Object)myLineFragment);
                    startID = mappingID;
                } else {
                    currentOffsets.add((byte)(mappingID - lastID));
                }
                lastID = mappingID;
            }
            if (startID != Integer.MIN_VALUE) {
                myLineFragment = new LineFragment(startID, Bytes.toArray((Collection)currentOffsets));
                fragmentList.add((Object)myLineFragment);
            }
            characterMapBuilder.add((Object)fragmentList.build());
        }
        return maxID;
    }

    private FileName splitFileName(Interner<String> interner, String input) {
        int hashIndex = input.lastIndexOf(47);
        String dir = (String)interner.intern((Object)input.substring(0, hashIndex + 1));
        String fileName = (String)interner.intern((Object)input.substring(hashIndex + 1));
        return new FileName(dir, fileName);
    }

    private void parseFileMappings(ParseState parser, int maxID) throws SourceMapParseException, JSONException {
        Interner interner = Interners.newStrongInterner();
        ImmutableList.Builder mappingsBuilder = ImmutableList.builder();
        ArrayList lineOffsets = Lists.newArrayList();
        ArrayList columns = Lists.newArrayList();
        ArrayList identifiers = Lists.newArrayList();
        String currentFile = null;
        int lastLine = -1;
        int startLine = -1;
        int startMapId = -1;
        for (int mappingId = 0; mappingId <= maxID; ++mappingId) {
            String currentLine = parser.readLine();
            JSONArray mapArray = new JSONArray(currentLine);
            if (mapArray.length() < 3) {
                parser.fail("Invalid mapping array");
            }
            String myFile = mapArray.getString(0);
            int line = mapArray.getInt(1);
            if (!myFile.equals(currentFile) || line - lastLine > 127 || line - lastLine < -128) {
                if (currentFile != null) {
                    FileName dirFile = this.splitFileName((Interner<String>)interner, currentFile);
                    SourceFile.Builder builder = SourceFile.newBuilder().setDir(dirFile.dir).setFileName(dirFile.name).setStartLine(startLine).setStartMapId(startMapId).setLineOffsets(lineOffsets).setColumns(columns).setIdentifiers(identifiers);
                    mappingsBuilder.add((Object)builder.build());
                }
                currentFile = myFile;
                startLine = line;
                lastLine = line;
                startMapId = mappingId;
                columns.clear();
                lineOffsets.clear();
                identifiers.clear();
            }
            lineOffsets.add((byte)(line - lastLine));
            columns.add((short)mapArray.getInt(2));
            identifiers.add(interner.intern((Object)mapArray.optString(3, "")));
            lastLine = line;
        }
        if (currentFile != null) {
            FileName dirFile = this.splitFileName((Interner<String>)interner, currentFile);
            SourceFile.Builder builder = SourceFile.newBuilder().setDir(dirFile.dir).setFileName(dirFile.name).setStartLine(startLine).setStartMapId(startMapId).setLineOffsets(lineOffsets).setColumns(columns).setIdentifiers(identifiers);
            mappingsBuilder.add((Object)builder.build());
        }
        this.mappings = mappingsBuilder.build();
    }

    private void parseInternal(ParseState parser) throws SourceMapParseException, JSONException {
        int lineCount;
        String headerCount = parser.readLine();
        Preconditions.checkArgument((boolean)headerCount.startsWith(LINEMAP_HEADER), (String)"Expected %s", (Object[])new Object[]{LINEMAP_HEADER});
        JSONObject countObject = new JSONObject(headerCount.substring(LINEMAP_HEADER.length()));
        if (!countObject.has("count")) {
            parser.fail("Missing 'count'");
        }
        if ((lineCount = countObject.getInt("count")) <= 0) {
            parser.fail("Count must be >= 1");
        }
        ImmutableList.Builder characterMapBuilder = ImmutableList.builder();
        int maxId = this.parseCharacterMap(parser, lineCount, (ImmutableList.Builder<ImmutableList<LineFragment>>)characterMapBuilder);
        this.characterMap = characterMapBuilder.build();
        parser.expectLine(FILEINFO_HEADER);
        for (int i = 0; i < lineCount; ++i) {
            parser.readLine();
        }
        parser.expectLine(DEFINITION_HEADER);
        this.parseFileMappings(parser, maxId);
    }

    @Override
    public Mapping.OriginalMapping getMappingForLine(int lineNumber, int columnIndex) {
        Preconditions.checkNotNull(this.characterMap, (Object)"parse() must be called first");
        if (lineNumber < 1 || lineNumber > this.characterMap.size() || columnIndex < 1) {
            return null;
        }
        List lineFragments = (List)this.characterMap.get(lineNumber - 1);
        if (lineFragments == null || lineFragments.isEmpty()) {
            return null;
        }
        int columnOffset = 0;
        LineFragment lastFragment = (LineFragment)lineFragments.get(lineFragments.size() - 1);
        int mapId = lastFragment.valueAtColumn(lastFragment.length());
        Iterator i$ = lineFragments.iterator();
        while (i$.hasNext()) {
            int columnPosition = columnIndex - columnOffset;
            LineFragment lineFragment = (LineFragment)i$.next();
            if (columnPosition <= lineFragment.length()) {
                mapId = lineFragment.valueAtColumn(columnPosition);
                break;
            }
            columnOffset += lineFragment.length();
        }
        if (mapId < 0) {
            return null;
        }
        return this.getMappingFromId(mapId);
    }

    private SourceFile binarySearch(int mapId) {
        int lower = 0;
        int upper = this.mappings.size() - 1;
        while (lower <= upper) {
            int middle = lower + (upper - lower) / 2;
            SourceFile middleCompare = (SourceFile)this.mappings.get(middle);
            if (mapId < middleCompare.getStartMapId()) {
                upper = middle - 1;
                continue;
            }
            if (mapId < middleCompare.getStartMapId() + middleCompare.getLength()) {
                return middleCompare;
            }
            lower = middle + 1;
        }
        return null;
    }

    private Mapping.OriginalMapping getMappingFromId(int mapID) {
        SourceFile match = this.binarySearch(mapID);
        if (match == null) {
            return null;
        }
        int pos = mapID - match.getStartMapId();
        return match.getOriginalMapping(pos);
    }

    private static final class SourceFile {
        final String dir;
        final String fileName;
        final int startMapId;
        final int startLine;
        final byte[] lineOffsets;
        final short[] columns;
        final String[] identifiers;

        private SourceFile(String dir, String fileName, int startLine, int startMapId, byte[] lineOffsets, short[] columns, String[] identifiers) {
            this.fileName = (String)Preconditions.checkNotNull((Object)fileName);
            this.dir = (String)Preconditions.checkNotNull((Object)dir);
            this.startLine = startLine;
            this.startMapId = startMapId;
            this.lineOffsets = (byte[])Preconditions.checkNotNull((Object)lineOffsets);
            this.columns = (short[])Preconditions.checkNotNull((Object)columns);
            this.identifiers = (String[])Preconditions.checkNotNull((Object)identifiers);
            Preconditions.checkArgument((lineOffsets.length == columns.length && columns.length == identifiers.length ? 1 : 0) != 0);
        }

        private SourceFile(int startMapId) {
            this.startMapId = startMapId;
            this.fileName = null;
            this.dir = null;
            this.startLine = 0;
            this.lineOffsets = null;
            this.columns = null;
            this.identifiers = null;
        }

        int getLength() {
            return this.lineOffsets.length;
        }

        int getStartMapId() {
            return this.startMapId;
        }

        Mapping.OriginalMapping getOriginalMapping(int offset) {
            int lineNumber = this.startLine;
            for (int i = 0; i <= offset; ++i) {
                lineNumber += this.lineOffsets[i];
            }
            Mapping.OriginalMapping.Builder builder = Mapping.OriginalMapping.newBuilder().setOriginalFile(this.dir + this.fileName).setLineNumber(lineNumber).setColumnPosition(this.columns[offset]).setIdentifier(this.identifiers[offset]);
            return builder.build();
        }

        static Builder newBuilder() {
            return new Builder();
        }

        static final class Builder {
            String dir;
            String fileName;
            int startMapId;
            int startLine;
            byte[] lineOffsets;
            short[] columns;
            String[] identifiers;

            Builder() {
            }

            Builder setDir(String dir) {
                this.dir = dir;
                return this;
            }

            Builder setFileName(String fileName) {
                this.fileName = fileName;
                return this;
            }

            Builder setStartMapId(int startMapId) {
                this.startMapId = startMapId;
                return this;
            }

            Builder setStartLine(int startLine) {
                this.startLine = startLine;
                return this;
            }

            Builder setLineOffsets(List<Byte> lineOffsets) {
                this.lineOffsets = Bytes.toArray(lineOffsets);
                return this;
            }

            Builder setColumns(List<Short> columns) {
                this.columns = Shorts.toArray(columns);
                return this;
            }

            Builder setIdentifiers(List<String> identifiers) {
                this.identifiers = identifiers.toArray(new String[0]);
                return this;
            }

            SourceFile build() {
                return new SourceFile(this.dir, this.fileName, this.startLine, this.startMapId, this.lineOffsets, this.columns, this.identifiers);
            }
        }
    }

    private static final class LineFragment {
        private final int startIndex;
        private final byte[] offsets;

        LineFragment(int startIndex, byte[] offsets) {
            this.startIndex = startIndex;
            this.offsets = offsets;
        }

        int length() {
            return this.offsets.length + 1;
        }

        int valueAtColumn(int column) {
            Preconditions.checkArgument((column > 0 ? 1 : 0) != 0);
            int pos = this.startIndex;
            for (int i = 0; i < column - 1; ++i) {
                pos += this.offsets[i];
            }
            return pos;
        }
    }

    private class FileName {
        private final String dir;
        private final String name;

        FileName(String directory, String name) {
            this.dir = directory;
            this.name = name;
        }
    }

    private static class ParseState {
        final String contents;
        int currentPosition = 0;

        ParseState(String contents) {
            this.contents = contents;
        }

        String readLineOrNull() {
            if (this.currentPosition >= this.contents.length()) {
                return null;
            }
            int index = this.contents.indexOf(10, this.currentPosition);
            if (index < 0) {
                index = this.contents.length();
            }
            String line = this.contents.substring(this.currentPosition, index);
            this.currentPosition = index + 1;
            return line;
        }

        String readLine() throws SourceMapParseException {
            String line = this.readLineOrNull();
            if (line == null) {
                this.fail("EOF");
            }
            return line;
        }

        void expectLine(String expect) throws SourceMapParseException {
            String line = this.readLine();
            if (!expect.equals(line)) {
                this.fail("Expected " + expect + " got " + line);
            }
        }

        void fail(String message) throws SourceMapParseException {
            throw new SourceMapParseException(message);
        }
    }
}

