/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion.xstream;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.shindig.protocol.conversion.xstream.InterfaceFieldAliasMapping;
import org.apache.shindig.protocol.conversion.xstream.WriterStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceFieldAliasingMapper
extends MapperWrapper {
    private Map<String, List<InterfaceFieldAliasMapping>> serializedMap = Maps.newHashMap();
    private Map<String, List<InterfaceFieldAliasMapping>> membersMap = Maps.newHashMap();
    private WriterStack writerStack;

    public InterfaceFieldAliasingMapper(Mapper wrapped, WriterStack writerStack, List<InterfaceFieldAliasMapping> ifaList) {
        super(wrapped);
        this.writerStack = writerStack;
        for (InterfaceFieldAliasMapping ifa : ifaList) {
            ArrayList serializedMatches = this.serializedMap.get(ifa.getFieldName());
            if (serializedMatches == null) {
                serializedMatches = Lists.newArrayList();
                this.serializedMap.put(ifa.getFieldName(), serializedMatches);
            }
            serializedMatches.add(ifa);
            ArrayList memberMatches = this.membersMap.get(ifa.getAlias());
            if (memberMatches == null) {
                memberMatches = Lists.newArrayList();
                this.membersMap.put(ifa.getAlias(), memberMatches);
            }
            memberMatches.add(ifa);
        }
    }

    public String realMember(Class type, String serialized) {
        List<InterfaceFieldAliasMapping> serializedMatches = this.membersMap.get(serialized);
        if (serializedMatches != null) {
            for (InterfaceFieldAliasMapping ifa : serializedMatches) {
                if (!ifa.getType().isAssignableFrom(type)) continue;
                return ifa.getFieldName();
            }
        }
        return super.realMember(type, serialized);
    }

    public String serializedMember(Class type, String memberName) {
        List<InterfaceFieldAliasMapping> memberMatches = this.serializedMap.get(memberName);
        if (memberMatches != null) {
            for (InterfaceFieldAliasMapping ifa : memberMatches) {
                if (!(ifa.getParent() == null ? ifa.getType().isAssignableFrom(type) : ifa.getType().isAssignableFrom(type) && ifa.getParent().equals(this.writerStack.peek()))) continue;
                return ifa.getAlias();
            }
        }
        return super.serializedMember(type, memberName);
    }
}

