/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.constants;

import org.apache.sanselan.formats.tiff.constants.TagInfo;
import org.apache.sanselan.formats.tiff.constants.TiffDirectoryConstants;
import org.apache.sanselan.formats.tiff.constants.TiffFieldTypeConstants;

public interface ExifTagConstants
extends TiffDirectoryConstants,
TiffFieldTypeConstants {
    public static final TagInfo EXIF_TAG_INTEROP_INDEX = new TagInfo("Interop Index", 1, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_INTEROP_IFD);
    public static final TagInfo EXIF_TAG_INTEROP_VERSION = new TagInfo("Interop Version", 2, FIELD_TYPE_UNDEFINED, 1, EXIF_DIRECTORY_INTEROP_IFD);
    public static final TagInfo EXIF_TAG_PROCESSING_SOFTWARE = new TagInfo("Processing Software", 11, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_SUBFILE_TYPE = new TagInfo("Subfile Type", 254, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_IFD0);
    public static final int SUBFILE_TYPE_VALUE_REDUCED_RESOLUTION_IMAGE = 1;
    public static final int SUBFILE_TYPE_VALUE_SINGLE_PAGE_OF_MULTI_PAGE_IMAGE = 2;
    public static final int SUBFILE_TYPE_VALUE_SINGLE_PAGE_OF_MULTI_PAGE_REDUCED_RESOLUTION_IMAGE = 3;
    public static final int SUBFILE_TYPE_VALUE_TRANSPARENCY_MASK = 4;
    public static final int SUBFILE_TYPE_VALUE_TRANSPARENCY_MASK_OF_REDUCED_RESOLUTION_IMAGE = 5;
    public static final int SUBFILE_TYPE_VALUE_TRANSPARENCY_MASK_OF_MULTI_PAGE_IMAGE = 6;
    public static final int SUBFILE_TYPE_VALUE_TRANSPARENCY_MASK_OF_REDUCED_RESOLUTION_MULTI_PAGE_IMAGE = 7;
    public static final TagInfo EXIF_TAG_OLD_SUBFILE_TYPE = new TagInfo("Old Subfile Type", 255, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final int OLD_SUBFILE_TYPE_VALUE_REDUCED_RESOLUTION_IMAGE = 2;
    public static final int OLD_SUBFILE_TYPE_VALUE_SINGLE_PAGE_OF_MULTI_PAGE_IMAGE = 3;
    public static final TagInfo EXIF_TAG_IMAGE_WIDTH_IFD0 = new TagInfo("Image Width", 256, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_IMAGE_HEIGHT_IFD0 = new TagInfo("Image Height", 257, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_BITS_PER_SAMPLE = new TagInfo("Bits Per Sample", 258, FIELD_TYPE_SHORT, -1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_COMPRESSION = new TagInfo("Compression", 259, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final int COMPRESSION_VALUE_CCITT_1D = 2;
    public static final int COMPRESSION_VALUE_T4_GROUP_3_FAX = 3;
    public static final int COMPRESSION_VALUE_T6_GROUP_4_FAX = 4;
    public static final int COMPRESSION_VALUE_LZW = 5;
    public static final int COMPRESSION_VALUE_JPEG_OLD_STYLE = 6;
    public static final int COMPRESSION_VALUE_JPEG = 7;
    public static final int COMPRESSION_VALUE_ADOBE_DEFLATE = 8;
    public static final int COMPRESSION_VALUE_JBIG_B_AND_W = 9;
    public static final int COMPRESSION_VALUE_JBIG_COLOR = 10;
    public static final int COMPRESSION_VALUE_NEXT = 32766;
    public static final int COMPRESSION_VALUE_EPSON_ERF_COMPRESSED = 32769;
    public static final int COMPRESSION_VALUE_CCIRLEW = 32771;
    public static final int COMPRESSION_VALUE_PACK_BITS = 32773;
    public static final int COMPRESSION_VALUE_THUNDERSCAN = 32809;
    public static final int COMPRESSION_VALUE_IT8CTPAD = 32895;
    public static final int COMPRESSION_VALUE_IT8LW = 32896;
    public static final int COMPRESSION_VALUE_IT8MP = 32897;
    public static final int COMPRESSION_VALUE_IT8BL = 32898;
    public static final int COMPRESSION_VALUE_PIXAR_FILM = 32908;
    public static final int COMPRESSION_VALUE_PIXAR_LOG = 32909;
    public static final int COMPRESSION_VALUE_DEFLATE = 32946;
    public static final int COMPRESSION_VALUE_DCS = 32947;
    public static final int COMPRESSION_VALUE_JBIG = 34661;
    public static final int COMPRESSION_VALUE_SGILOG = 34676;
    public static final int COMPRESSION_VALUE_SGILOG_24 = 34677;
    public static final int COMPRESSION_VALUE_JPEG_2000 = 34712;
    public static final int COMPRESSION_VALUE_NIKON_NEF_COMPRESSED = 34713;
    public static final int COMPRESSION_VALUE_KODAK_DCR_COMPRESSED = 65000;
    public static final int COMPRESSION_VALUE_PENTAX_PEF_COMPRESSED = 65535;
    public static final TagInfo EXIF_TAG_PHOTOMETRIC_INTERPRETATION = new TagInfo("Photometric Interpretation", 262, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final int PHOTOMETRIC_INTERPRETATION_VALUE_BLACK_IS_ZERO = 1;
    public static final int PHOTOMETRIC_INTERPRETATION_VALUE_RGB = 2;
    public static final int PHOTOMETRIC_INTERPRETATION_VALUE_RGB_PALETTE = 3;
    public static final int PHOTOMETRIC_INTERPRETATION_VALUE_TRANSPARENCY_MASK = 4;
    public static final int PHOTOMETRIC_INTERPRETATION_VALUE_CMYK = 5;
    public static final int PHOTOMETRIC_INTERPRETATION_VALUE_YCB_CR = 6;
    public static final int PHOTOMETRIC_INTERPRETATION_VALUE_CIELAB = 8;
    public static final int PHOTOMETRIC_INTERPRETATION_VALUE_ICCLAB = 9;
    public static final int PHOTOMETRIC_INTERPRETATION_VALUE_ITULAB = 10;
    public static final int PHOTOMETRIC_INTERPRETATION_VALUE_COLOR_FILTER_ARRAY = 32803;
    public static final int PHOTOMETRIC_INTERPRETATION_VALUE_PIXAR_LOG_L = 32844;
    public static final int PHOTOMETRIC_INTERPRETATION_VALUE_PIXAR_LOG_LUV = 32845;
    public static final int PHOTOMETRIC_INTERPRETATION_VALUE_LINEAR_RAW = 34892;
    public static final TagInfo EXIF_TAG_THRESHOLDING = new TagInfo("Thresholding", 263, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final int THRESHOLDING_VALUE_ORDERED_DITHER_OR_HALFTONE = 2;
    public static final int THRESHOLDING_VALUE_RANDOMIZED_DITHER = 3;
    public static final TagInfo EXIF_TAG_CELL_WIDTH = new TagInfo("Cell Width", 264, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_CELL_LENGTH = new TagInfo("Cell Length", 265, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_FILL_ORDER = new TagInfo("Fill Order", 266, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final int FILL_ORDER_VALUE_REVERSED = 2;
    public static final TagInfo EXIF_TAG_DOCUMENT_NAME = new TagInfo("Document Name", 269, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_IMAGE_DESCRIPTION = new TagInfo("Image Description", 270, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_MAKE = new TagInfo("Make", 271, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_MODEL = new TagInfo("Model", 272, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_PREVIEW_IMAGE_START_IFD0 = new TagInfo.Offset("Preview Image Start", 273, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_PREVIEW_IMAGE_START_SUB_IFD1 = new TagInfo.Offset("Preview Image Start", 273, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_SUB_IFD1);
    public static final TagInfo EXIF_TAG_JPG_FROM_RAW_START_SUB_IFD2 = new TagInfo.Offset("Jpg From Raw Start", 273, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_SUB_IFD2);
    public static final TagInfo EXIF_TAG_ORIENTATION = new TagInfo("Orientation", 274, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final int ORIENTATION_VALUE_MIRROR_HORIZONTAL = 2;
    public static final int ORIENTATION_VALUE_ROTATE_180 = 3;
    public static final int ORIENTATION_VALUE_MIRROR_VERTICAL = 4;
    public static final int ORIENTATION_VALUE_MIRROR_HORIZONTAL_AND_ROTATE_270_CW = 5;
    public static final int ORIENTATION_VALUE_ROTATE_90_CW = 6;
    public static final int ORIENTATION_VALUE_MIRROR_HORIZONTAL_AND_ROTATE_90_CW = 7;
    public static final int ORIENTATION_VALUE_ROTATE_270_CW = 8;
    public static final TagInfo EXIF_TAG_SAMPLES_PER_PIXEL = new TagInfo("Samples Per Pixel", 277, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_ROWS_PER_STRIP = new TagInfo("Rows Per Strip", 278, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_PREVIEW_IMAGE_LENGTH_IFD0 = new TagInfo("Preview Image Length", 279, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_PREVIEW_IMAGE_LENGTH_SUB_IFD1 = new TagInfo("Preview Image Length", 279, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_SUB_IFD1);
    public static final TagInfo EXIF_TAG_JPG_FROM_RAW_LENGTH_SUB_IFD2 = new TagInfo("Jpg From Raw Length", 279, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_SUB_IFD2);
    public static final TagInfo EXIF_TAG_MIN_SAMPLE_VALUE = new TagInfo("Min Sample Value", 280, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_MAX_SAMPLE_VALUE = new TagInfo("Max Sample Value", 281, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_XRESOLUTION = new TagInfo("XResolution", 282, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_YRESOLUTION = new TagInfo("YResolution", 283, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_PLANAR_CONFIGURATION = new TagInfo("Planar Configuration", 284, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final int PLANAR_CONFIGURATION_VALUE_PLANAR = 2;
    public static final TagInfo EXIF_TAG_PAGE_NAME = new TagInfo("Page Name", 285, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_XPOSITION = new TagInfo("XPosition", 286, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_YPOSITION = new TagInfo("YPosition", 287, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_FREE_OFFSETS = new TagInfo("Free Offsets", 288, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_FREE_BYTE_COUNTS = new TagInfo("Free Byte Counts", 289, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_GRAY_RESPONSE_UNIT = new TagInfo("Gray Response Unit", 290, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final int GRAY_RESPONSE_UNIT_VALUE_0_001 = 2;
    public static final int GRAY_RESPONSE_UNIT_VALUE_0_0001 = 3;
    public static final int GRAY_RESPONSE_UNIT_VALUE_1E_05 = 4;
    public static final int GRAY_RESPONSE_UNIT_VALUE_1E_06 = 5;
    public static final TagInfo EXIF_TAG_GRAY_RESPONSE_CURVE = new TagInfo("Gray Response Curve", 291, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_T4OPTIONS = new TagInfo("T4 Options", 292, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_T6OPTIONS = new TagInfo("T6 Options", 293, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_RESOLUTION_UNIT = new TagInfo("Resolution Unit", 296, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final int RESOLUTION_UNIT_VALUE_INCHES = 2;
    public static final int RESOLUTION_UNIT_VALUE_CM = 3;
    public static final TagInfo EXIF_TAG_PAGE_NUMBER = new TagInfo("Page Number", 297, FIELD_TYPE_SHORT, 2, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_COLOR_RESPONSE_UNIT = new TagInfo("Color Response Unit", 300, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_TRANSFER_FUNCTION = new TagInfo("Transfer Function", 301, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_SOFTWARE = new TagInfo("Software", 305, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_MODIFY_DATE = new TagInfo("Modify Date", 306, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_ARTIST = new TagInfo("Artist", 315, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_HOST_COMPUTER = new TagInfo("Host Computer", 316, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_PREDICTOR = new TagInfo("Predictor", 317, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final int PREDICTOR_VALUE_HORIZONTAL_DIFFERENCING = 2;
    public static final TagInfo EXIF_TAG_WHITE_POINT = new TagInfo("White Point", 318, FIELD_TYPE_RATIONAL, 2, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_PRIMARY_CHROMATICITIES = new TagInfo("Primary Chromaticities", 319, FIELD_TYPE_RATIONAL, 6, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_COLOR_MAP = new TagInfo("Color Map", 320, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_HALFTONE_HINTS = new TagInfo("Halftone Hints", 321, FIELD_TYPE_SHORT, 2, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_TILE_WIDTH = new TagInfo("Tile Width", 322, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_TILE_LENGTH = new TagInfo("Tile Length", 323, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_TILE_OFFSETS = new TagInfo("Tile Offsets", 324, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_TILE_BYTE_COUNTS = new TagInfo("Tile Byte Counts", 325, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_BAD_FAX_LINES = new TagInfo("Bad Fax Lines", 326, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_CLEAN_FAX_DATA = new TagInfo("Clean Fax Data", 327, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final int CLEAN_FAX_DATA_VALUE_REGENERATED = 1;
    public static final int CLEAN_FAX_DATA_VALUE_UNCLEAN = 2;
    public static final TagInfo EXIF_TAG_CONSECUTIVE_BAD_FAX_LINES = new TagInfo("Consecutive Bad Fax Lines", 328, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_SUB_IFD = new TagInfo("Sub IFD", 330, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_INK_SET = new TagInfo("Ink Set", 332, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final int INK_SET_VALUE_NOT_CMYK = 2;
    public static final TagInfo EXIF_TAG_INK_NAMES = new TagInfo("Ink Names", 333, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_NUMBEROF_INKS = new TagInfo("Numberof Inks", 334, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_DOT_RANGE = new TagInfo("Dot Range", 336, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_TARGET_PRINTER = new TagInfo("Target Printer", 337, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_EXTRA_SAMPLES = new TagInfo("Extra Samples", 338, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_SAMPLE_FORMAT = new TagInfo("Sample Format", 339, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final int SAMPLE_FORMAT_VALUE_TWOS_COMPLEMENT_SIGNED_INTEGER = 2;
    public static final int SAMPLE_FORMAT_VALUE_IEEE_FLOATING_POINT = 3;
    public static final int SAMPLE_FORMAT_VALUE_UNDEFINED = 4;
    public static final int SAMPLE_FORMAT_VALUE_COMPLEX_INTEGER = 5;
    public static final int SAMPLE_FORMAT_VALUE_IEEE_FLOATING_POINT_1 = 6;
    public static final TagInfo EXIF_TAG_SMIN_SAMPLE_VALUE = new TagInfo("SMin Sample Value", 340, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_SMAX_SAMPLE_VALUE = new TagInfo("SMax Sample Value", 341, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_TRANSFER_RANGE = new TagInfo("Transfer Range", 342, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_CLIP_PATH = new TagInfo("Clip Path", 343, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_XCLIP_PATH_UNITS = new TagInfo("XClip Path Units", 344, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_YCLIP_PATH_UNITS = new TagInfo("YClip Path Units", 345, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_INDEXED = new TagInfo("Indexed", 346, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final int INDEXED_VALUE_INDEXED = 1;
    public static final TagInfo EXIF_TAG_JPEGTABLES = new TagInfo("JPEGTables", 347, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_OPIPROXY = new TagInfo("OPIProxy", 351, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final int OPIPROXY_VALUE_HIGHER_RESOLUTION_IMAGE_EXISTS = 1;
    public static final TagInfo EXIF_TAG_GLOBAL_PARAMETERS_IFD = new TagInfo("Global Parameters IFD", 400, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_PROFILE_TYPE = new TagInfo("Profile Type", 401, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final int PROFILE_TYPE_VALUE_GROUP_3_FAX = 1;
    public static final TagInfo EXIF_TAG_FAX_PROFILE = new TagInfo("Fax Profile", 402, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final int FAX_PROFILE_VALUE_MINIMAL_B_AND_W_LOSSLESS_S = 1;
    public static final int FAX_PROFILE_VALUE_EXTENDED_B_AND_W_LOSSLESS_F = 2;
    public static final int FAX_PROFILE_VALUE_LOSSLESS_JBIG_B_AND_W_J = 3;
    public static final int FAX_PROFILE_VALUE_LOSSY_COLOR_AND_GRAYSCALE_C = 4;
    public static final int FAX_PROFILE_VALUE_LOSSLESS_COLOR_AND_GRAYSCALE_L = 5;
    public static final int FAX_PROFILE_VALUE_MIXED_RASTER_CONTENT_M = 6;
    public static final TagInfo EXIF_TAG_CODING_METHODS = new TagInfo("Coding Methods", 403, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_VERSION_YEAR = new TagInfo("Version Year", 404, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_MODE_NUMBER = new TagInfo("Mode Number", 405, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_DECODE = new TagInfo("Decode", 433, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_DEFAULT_IMAGE_COLOR = new TagInfo("Default Image Color", 434, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_JPEGPROC = new TagInfo("JPEGProc", 512, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final int JPEGPROC_VALUE_LOSSLESS = 14;
    public static final TagInfo EXIF_TAG_PREVIEW_IMAGE_START_MAKER_NOTES = new TagInfo("Preview Image Start", 513, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_MAKER_NOTES);
    public static final TagInfo EXIF_TAG_JPG_FROM_RAW_START_SUB_IFD = new TagInfo.Offset("Jpg From Raw Start", 513, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_SUB_IFD);
    public static final TagInfo EXIF_TAG_JPG_FROM_RAW_START_IFD2 = new TagInfo.Offset("Jpg From Raw Start", 513, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_IFD2);
    public static final TagInfo EXIF_TAG_OTHER_IMAGE_START = new TagInfo.Offset("Other Image Start", 513, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_PREVIEW_IMAGE_LENGTH_MAKER_NOTES = new TagInfo("Preview Image Length", 514, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_MAKER_NOTES);
    public static final TagInfo EXIF_TAG_JPG_FROM_RAW_LENGTH_SUB_IFD = new TagInfo("Jpg From Raw Length", 514, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_SUB_IFD);
    public static final TagInfo EXIF_TAG_JPG_FROM_RAW_LENGTH_IFD2 = new TagInfo("Jpg From Raw Length", 514, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_IFD2);
    public static final TagInfo EXIF_TAG_OTHER_IMAGE_LENGTH = new TagInfo("Other Image Length", 514, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_JPEGRESTART_INTERVAL = new TagInfo("JPEGRestart Interval", 515, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_JPEGLOSSLESS_PREDICTORS = new TagInfo("JPEGLossless Predictors", 517, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_JPEGPOINT_TRANSFORMS = new TagInfo("JPEGPoint Transforms", 518, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_JPEGQTABLES = new TagInfo("JPEGQTables", 519, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_JPEGDCTABLES = new TagInfo("JPEGDCTables", 520, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_JPEGACTABLES = new TagInfo("JPEGACTables", 521, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_YCBCR_COEFFICIENTS = new TagInfo("YCbCr Coefficients", 529, FIELD_TYPE_RATIONAL, 3, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_YCBCR_SUB_SAMPLING = new TagInfo("YCbCr Sub Sampling", 530, FIELD_TYPE_SHORT, 2, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_YCBCR_POSITIONING = new TagInfo("YCbCr Positioning", 531, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final int YCB_CR_POSITIONING_VALUE_CO_SITED = 2;
    public static final TagInfo EXIF_TAG_REFERENCE_BLACK_WHITE = new TagInfo("Reference Black White", 532, FIELD_TYPE_RATIONAL, 6, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_STRIP_ROW_COUNTS = new TagInfo("Strip Row Counts", 559, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_APPLICATION_NOTES = new TagInfo("Application Notes", 700, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_RELATED_IMAGE_FILE_FORMAT = new TagInfo("Related Image File Format", 4096, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_INTEROP_IFD);
    public static final TagInfo EXIF_TAG_RELATED_IMAGE_WIDTH = new TagInfo("Related Image Width", 4097, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_INTEROP_IFD);
    public static final TagInfo EXIF_TAG_RELATED_IMAGE_LENGTH = new TagInfo("Related Image Length", 4098, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_INTEROP_IFD);
    public static final TagInfo EXIF_TAG_RATING = new TagInfo("Rating", 18246, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_RATING_PERCENT = new TagInfo("Rating Percent", 18249, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_IMAGE_ID = new TagInfo("Image ID", 32781, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_WANG_ANNOTATION = new TagInfo("Wang Annotation", 32932, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_MATTEING = new TagInfo("Matteing", 32995, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_DATA_TYPE = new TagInfo("Data Type", 32996, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_IMAGE_DEPTH = new TagInfo("Image Depth", 32997, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_TILE_DEPTH = new TagInfo("Tile Depth", 32998, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_MODEL_2 = new TagInfo("Model 2", 33405, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_CFAREPEAT_PATTERN_DIM = new TagInfo("CFARepeat Pattern Dim", 33421, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_CFAPATTERN_2 = new TagInfo("CFAPattern 2", 33422, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_BATTERY_LEVEL = new TagInfo("Battery Level", 33423, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_COPYRIGHT = new TagInfo("Copyright", 33432, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_EXPOSURE_TIME = new TagInfo("Exposure Time", 33434, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_FNUMBER = new TagInfo("FNumber", 33437, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_MDFILE_TAG = new TagInfo("MDFile Tag", 33445, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_MDSCALE_PIXEL = new TagInfo("MDScale Pixel", 33446, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_MDCOLOR_TABLE = new TagInfo("MDColor Table", 33447, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_MDLAB_NAME = new TagInfo("MDLab Name", 33448, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_MDSAMPLE_INFO = new TagInfo("MDSample Info", 33449, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_MDPREP_DATE = new TagInfo("MDPrep Date", 33450, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_MDPREP_TIME = new TagInfo("MDPrep Time", 33451, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_MDFILE_UNITS = new TagInfo("MDFile Units", 33452, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_PIXEL_SCALE = new TagInfo("Pixel Scale", 33550, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_IPTC_NAA = new TagInfo("IPTC- NAA", 33723, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_INTERGRAPH_PACKET_DATA = new TagInfo("Intergraph Packet Data", 33918, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_INTERGRAPH_FLAG_REGISTERS = new TagInfo("Intergraph Flag Registers", 33919, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_INTERGRAPH_MATRIX = new TagInfo("Intergraph Matrix", 33920, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_MODEL_TIE_POINT = new TagInfo("Model Tie Point", 33922, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_SITE = new TagInfo("Site", 34016, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_COLOR_SEQUENCE = new TagInfo("Color Sequence", 34017, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_IT8HEADER = new TagInfo("IT8 Header", 34018, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_RASTER_PADDING = new TagInfo("Raster Padding", 34019, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_BITS_PER_RUN_LENGTH = new TagInfo("Bits Per Run Length", 34020, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_BITS_PER_EXTENDED_RUN_LENGTH = new TagInfo("Bits Per Extended Run Length", 34021, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_COLOR_TABLE = new TagInfo("Color Table", 34022, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_IMAGE_COLOR_INDICATOR = new TagInfo("Image Color Indicator", 34023, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_BACKGROUND_COLOR_INDICATOR = new TagInfo("Background Color Indicator", 34024, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_IMAGE_COLOR_VALUE = new TagInfo("Image Color Value", 34025, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_BACKGROUND_COLOR_VALUE = new TagInfo("Background Color Value", 34026, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_PIXEL_INTENSITY_RANGE = new TagInfo("Pixel Intensity Range", 34027, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_TRANSPARENCY_INDICATOR = new TagInfo("Transparency Indicator", 34028, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_COLOR_CHARACTERIZATION = new TagInfo("Color Characterization", 34029, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_HCUSAGE = new TagInfo("HCUsage", 34030, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_SEMINFO = new TagInfo("SEMInfo", 34118, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_AFCP_IPTC = new TagInfo("AFCP_ IPTC", 34152, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_MODEL_TRANSFORM = new TagInfo("Model Transform", 34264, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_LEAF_DATA = new TagInfo("Leaf Data", 34310, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_PHOTOSHOP_SETTINGS = new TagInfo("Photoshop Settings", 34377, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_EXIF_OFFSET = new TagInfo.Offset("Exif Offset", 34665, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_ICC_PROFILE = new TagInfo("ICC_ Profile", 34675, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_IMAGE_LAYER = new TagInfo("Image Layer", 34732, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_GEO_TIFF_DIRECTORY = new TagInfo("Geo Tiff Directory", 34735, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_GEO_TIFF_DOUBLE_PARAMS = new TagInfo("Geo Tiff Double Params", 34736, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_GEO_TIFF_ASCII_PARAMS = new TagInfo("Geo Tiff Ascii Params", 34737, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_EXPOSURE_PROGRAM = new TagInfo("Exposure Program", 34850, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final int EXPOSURE_PROGRAM_VALUE_PROGRAM_AE = 2;
    public static final int EXPOSURE_PROGRAM_VALUE_APERTURE_PRIORITY_AE = 3;
    public static final int EXPOSURE_PROGRAM_VALUE_SHUTTER_SPEED_PRIORITY_AE = 4;
    public static final int EXPOSURE_PROGRAM_VALUE_CREATIVE_SLOW_SPEED = 5;
    public static final int EXPOSURE_PROGRAM_VALUE_ACTION_HIGH_SPEED = 6;
    public static final int EXPOSURE_PROGRAM_VALUE_PORTRAIT = 7;
    public static final int EXPOSURE_PROGRAM_VALUE_LANDSCAPE = 8;
    public static final TagInfo EXIF_TAG_SPECTRAL_SENSITIVITY = new TagInfo("Spectral Sensitivity", 34852, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_GPSINFO = new TagInfo.Offset("GPSInfo", 34853, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_ISO = new TagInfo("ISO", 34855, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_OPTO__ELECTRIC_CONV_FACTOR = new TagInfo("Opto - Electric Conv Factor", 34856, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_INTERLACE = new TagInfo("Interlace", 34857, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_TIME_ZONE_OFFSET = new TagInfo("Time Zone Offset", 34858, FIELD_TYPE_SSHORT, -1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_SELF_TIMER_MODE = new TagInfo("Self Timer Mode", 34859, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_FAX_RECV_PARAMS = new TagInfo("Fax Recv Params", 34908, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_FAX_SUB_ADDRESS = new TagInfo("Fax Sub Address", 34909, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_FAX_RECV_TIME = new TagInfo("Fax Recv Time", 34910, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_LEAF_SUB_IFD = new TagInfo("Leaf Sub IFD", 34954, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_EXIF_VERSION = new TagInfo("Exif Version", 36864, FIELD_TYPE_UNDEFINED, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_DATE_TIME_ORIGINAL = new TagInfo("Date Time Original", 36867, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_CREATE_DATE = new TagInfo("Create Date", 36868, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_COMPONENTS_CONFIGURATION = new TagInfo("Components Configuration", 37121, FIELD_TYPE_UNDEFINED, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_COMPRESSED_BITS_PER_PIXEL = new TagInfo("Compressed Bits Per Pixel", 37122, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_SHUTTER_SPEED_VALUE = new TagInfo("Shutter Speed Value", 37377, FIELD_TYPE_SRATIONAL, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_APERTURE_VALUE = new TagInfo("Aperture Value", 37378, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_BRIGHTNESS_VALUE = new TagInfo("Brightness Value", 37379, FIELD_TYPE_SRATIONAL, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_EXPOSURE_COMPENSATION = new TagInfo("Exposure Compensation", 37380, FIELD_TYPE_SRATIONAL, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_MAX_APERTURE_VALUE = new TagInfo("Max Aperture Value", 37381, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_SUBJECT_DISTANCE = new TagInfo("Subject Distance", 37382, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_METERING_MODE = new TagInfo("Metering Mode", 37383, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final int METERING_MODE_VALUE_CENTER_WEIGHTED_AVERAGE = 2;
    public static final int METERING_MODE_VALUE_SPOT = 3;
    public static final int METERING_MODE_VALUE_MULTI_SPOT = 4;
    public static final int METERING_MODE_VALUE_MULTI_SEGMENT = 5;
    public static final int METERING_MODE_VALUE_PARTIAL = 6;
    public static final int METERING_MODE_VALUE_OTHER = 255;
    public static final TagInfo EXIF_TAG_LIGHT_SOURCE = new TagInfo("Light Source", 37384, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final int LIGHT_SOURCE_VALUE_FLUORESCENT = 2;
    public static final int LIGHT_SOURCE_VALUE_TUNGSTEN = 3;
    public static final int LIGHT_SOURCE_VALUE_FLASH = 4;
    public static final int LIGHT_SOURCE_VALUE_FINE_WEATHER = 9;
    public static final int LIGHT_SOURCE_VALUE_CLOUDY = 10;
    public static final int LIGHT_SOURCE_VALUE_SHADE = 11;
    public static final int LIGHT_SOURCE_VALUE_DAYLIGHT_FLUORESCENT = 12;
    public static final int LIGHT_SOURCE_VALUE_DAY_WHITE_FLUORESCENT = 13;
    public static final int LIGHT_SOURCE_VALUE_COOL_WHITE_FLUORESCENT = 14;
    public static final int LIGHT_SOURCE_VALUE_WHITE_FLUORESCENT = 15;
    public static final int LIGHT_SOURCE_VALUE_STANDARD_LIGHT_A = 17;
    public static final int LIGHT_SOURCE_VALUE_STANDARD_LIGHT_B = 18;
    public static final int LIGHT_SOURCE_VALUE_STANDARD_LIGHT_C = 19;
    public static final int LIGHT_SOURCE_VALUE_D55 = 20;
    public static final int LIGHT_SOURCE_VALUE_D65 = 21;
    public static final int LIGHT_SOURCE_VALUE_D75 = 22;
    public static final int LIGHT_SOURCE_VALUE_D50 = 23;
    public static final int LIGHT_SOURCE_VALUE_ISO_STUDIO_TUNGSTEN = 24;
    public static final int LIGHT_SOURCE_VALUE_OTHER = 255;
    public static final TagInfo EXIF_TAG_FLASH = new TagInfo("Flash", 37385, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final int FLASH_VALUE_FIRED = 1;
    public static final int FLASH_VALUE_FIRED_RETURN_NOT_DETECTED = 5;
    public static final int FLASH_VALUE_FIRED_RETURN_DETECTED = 7;
    public static final int FLASH_VALUE_ON_DID_NOT_FIRE = 8;
    public static final int FLASH_VALUE_ON = 9;
    public static final int FLASH_VALUE_ON_RETURN_NOT_DETECTED = 13;
    public static final int FLASH_VALUE_ON_RETURN_DETECTED = 15;
    public static final int FLASH_VALUE_OFF = 16;
    public static final int FLASH_VALUE_OFF_DID_NOT_FIRE_RETURN_NOT_DETECTED = 20;
    public static final int FLASH_VALUE_AUTO_DID_NOT_FIRE = 24;
    public static final int FLASH_VALUE_AUTO_FIRED = 25;
    public static final int FLASH_VALUE_AUTO_FIRED_RETURN_NOT_DETECTED = 29;
    public static final int FLASH_VALUE_AUTO_FIRED_RETURN_DETECTED = 31;
    public static final int FLASH_VALUE_NO_FLASH_FUNCTION = 32;
    public static final int FLASH_VALUE_OFF_NO_FLASH_FUNCTION = 48;
    public static final int FLASH_VALUE_FIRED_RED_EYE_REDUCTION = 65;
    public static final int FLASH_VALUE_FIRED_RED_EYE_REDUCTION_RETURN_NOT_DETECTED = 69;
    public static final int FLASH_VALUE_FIRED_RED_EYE_REDUCTION_RETURN_DETECTED = 71;
    public static final int FLASH_VALUE_ON_RED_EYE_REDUCTION = 73;
    public static final int FLASH_VALUE_ON_RED_EYE_REDUCTION_RETURN_NOT_DETECTED = 77;
    public static final int FLASH_VALUE_ON_RED_EYE_REDUCTION_RETURN_DETECTED = 79;
    public static final int FLASH_VALUE_OFF_RED_EYE_REDUCTION = 80;
    public static final int FLASH_VALUE_AUTO_DID_NOT_FIRE_RED_EYE_REDUCTION = 88;
    public static final int FLASH_VALUE_AUTO_FIRED_RED_EYE_REDUCTION = 89;
    public static final int FLASH_VALUE_AUTO_FIRED_RED_EYE_REDUCTION_RETURN_NOT_DETECTED = 93;
    public static final int FLASH_VALUE_AUTO_FIRED_RED_EYE_REDUCTION_RETURN_DETECTED = 95;
    public static final TagInfo EXIF_TAG_FOCAL_LENGTH = new TagInfo("Focal Length", 37386, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_FLASH_ENERGY = new TagInfo("Flash Energy", 37387, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_SPATIAL_FREQUENCY_RESPONSE_1 = new TagInfo("Spatial Frequency Response", 37388, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_NOISE_1 = new TagInfo("Noise", 37389, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_FOCAL_PLANE_XRESOLUTION = new TagInfo("Focal Plane XResolution", 37390, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_FOCAL_PLANE_YRESOLUTION = new TagInfo("Focal Plane YResolution", 37391, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_FOCAL_PLANE_RESOLUTION_UNIT = new TagInfo("Focal Plane Resolution Unit", 37392, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final int FOCAL_PLANE_RESOLUTION_UNIT_VALUE_INCHES = 2;
    public static final int FOCAL_PLANE_RESOLUTION_UNIT_VALUE_CM = 3;
    public static final int FOCAL_PLANE_RESOLUTION_UNIT_VALUE_MM = 4;
    public static final int FOCAL_PLANE_RESOLUTION_UNIT_VALUE_UM = 5;
    public static final TagInfo EXIF_TAG_IMAGE_NUMBER_EXIF_IFD = new TagInfo("Image Number", 37393, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_SECURITY_CLASSIFICATION_EXIF_IFD = new TagInfo("Security Classification", 37394, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_IMAGE_HISTORY_EXIF_IFD = new TagInfo("Image History", 37395, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_SUBJECT_LOCATION_1 = new TagInfo("Subject Location", 37396, FIELD_TYPE_SHORT, 4, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_EXPOSURE_INDEX = new TagInfo("Exposure Index", 37397, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_TIFF_EPSTANDARD_ID_1 = new TagInfo("TIFF- EPStandard ID", 37398, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_SENSING_METHOD = new TagInfo("Sensing Method", 37399, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final int SENSING_METHOD_VALUE_ONE_CHIP_COLOR_AREA = 2;
    public static final int SENSING_METHOD_VALUE_TWO_CHIP_COLOR_AREA = 3;
    public static final int SENSING_METHOD_VALUE_THREE_CHIP_COLOR_AREA = 4;
    public static final int SENSING_METHOD_VALUE_COLOR_SEQUENTIAL_AREA = 5;
    public static final int SENSING_METHOD_VALUE_MONOCHROME_LINEAR = 6;
    public static final int SENSING_METHOD_VALUE_TRILINEAR = 7;
    public static final int SENSING_METHOD_VALUE_COLOR_SEQUENTIAL_LINEAR = 8;
    public static final TagInfo EXIF_TAG_STO_NITS = new TagInfo("Sto Nits", 37439, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_MAKER_NOTE = new TagInfo("Maker Note", 37500, FIELD_TYPE_UNDEFINED, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_USER_COMMENT = new TagInfo.Text("UserComment", 37510, FIELD_TYPE_UNDEFINED, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_SUB_SEC_TIME = new TagInfo("Sub Sec Time", 37520, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_SUB_SEC_TIME_ORIGINAL = new TagInfo("Sub Sec Time Original", 37521, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_SUB_SEC_TIME_DIGITIZED = new TagInfo("Sub Sec Time Digitized", 37522, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_IMAGE_SOURCE_DATA = new TagInfo("Image Source Data", 37724, FIELD_TYPE_UNDEFINED, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_XPTITLE = new TagInfo("XPTitle", 40091, FIELD_TYPE_BYTE, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_XPCOMMENT = new TagInfo("XPComment", 40092, FIELD_TYPE_BYTE, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_XPAUTHOR = new TagInfo("XPAuthor", 40093, FIELD_TYPE_BYTE, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_XPKEYWORDS = new TagInfo("XPKeywords", 40094, FIELD_TYPE_BYTE, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_XPSUBJECT = new TagInfo("XPSubject", 40095, FIELD_TYPE_BYTE, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_FLASHPIX_VERSION = new TagInfo("Flashpix Version", 40960, FIELD_TYPE_UNDEFINED, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_COLOR_SPACE = new TagInfo("Color Space", 40961, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final int COLOR_SPACE_VALUE_ADOBE_RGB = 2;
    public static final int COLOR_SPACE_VALUE_UNCALIBRATED = 65535;
    public static final TagInfo EXIF_TAG_EXIF_IMAGE_WIDTH = new TagInfo("Exif Image Width", 40962, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_EXIF_IMAGE_LENGTH = new TagInfo("Exif Image Length", 40963, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_RELATED_SOUND_FILE = new TagInfo("Related Sound File", 40964, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_INTEROP_OFFSET = new TagInfo.Offset("Interop Offset", 40965, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_FLASH_ENERGY_EXIF_IFD = new TagInfo("Flash Energy", 41483, FIELD_TYPE_RATIONAL, -1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_SPATIAL_FREQUENCY_RESPONSE_2 = new TagInfo("Spatial Frequency Response", 41484, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_NOISE_2 = new TagInfo("Noise", 41485, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_FOCAL_PLANE_XRESOLUTION_EXIF_IFD = new TagInfo("Focal Plane XResolution", 41486, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_FOCAL_PLANE_YRESOLUTION_EXIF_IFD = new TagInfo("Focal Plane YResolution", 41487, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_FOCAL_PLANE_RESOLUTION_UNIT_EXIF_IFD = new TagInfo("Focal Plane Resolution Unit", 41488, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final int FOCAL_PLANE_RESOLUTION_UNIT_EXIF_IFD_VALUE_INCHES = 2;
    public static final int FOCAL_PLANE_RESOLUTION_UNIT_EXIF_IFD_VALUE_CM = 3;
    public static final int FOCAL_PLANE_RESOLUTION_UNIT_EXIF_IFD_VALUE_MM = 4;
    public static final int FOCAL_PLANE_RESOLUTION_UNIT_EXIF_IFD_VALUE_UM = 5;
    public static final TagInfo EXIF_TAG_IMAGE_NUMBER = new TagInfo("Image Number", 41489, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_SECURITY_CLASSIFICATION = new TagInfo("Security Classification", 41490, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_IMAGE_HISTORY = new TagInfo("Image History", 41491, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_SUBJECT_LOCATION_2 = new TagInfo("Subject Location", 41492, FIELD_TYPE_SHORT, 2, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_EXPOSURE_INDEX_EXIF_IFD = new TagInfo("Exposure Index", 41493, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_TIFF_EPSTANDARD_ID_2 = new TagInfo("TIFF- EPStandard ID", 41494, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_SENSING_METHOD_EXIF_IFD = new TagInfo("Sensing Method", 41495, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final int SENSING_METHOD_EXIF_IFD_VALUE_ONE_CHIP_COLOR_AREA = 2;
    public static final int SENSING_METHOD_EXIF_IFD_VALUE_TWO_CHIP_COLOR_AREA = 3;
    public static final int SENSING_METHOD_EXIF_IFD_VALUE_THREE_CHIP_COLOR_AREA = 4;
    public static final int SENSING_METHOD_EXIF_IFD_VALUE_COLOR_SEQUENTIAL_AREA = 5;
    public static final int SENSING_METHOD_EXIF_IFD_VALUE_TRILINEAR = 7;
    public static final int SENSING_METHOD_EXIF_IFD_VALUE_COLOR_SEQUENTIAL_LINEAR = 8;
    public static final TagInfo EXIF_TAG_FILE_SOURCE = new TagInfo("File Source", 41728, FIELD_TYPE_UNDEFINED, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final int FILE_SOURCE_VALUE_REFLECTION_PRINT_SCANNER = 2;
    public static final int FILE_SOURCE_VALUE_DIGITAL_CAMERA = 3;
    public static final TagInfo EXIF_TAG_SCENE_TYPE = new TagInfo("Scene Type", 41729, FIELD_TYPE_UNDEFINED, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_CFAPATTERN = new TagInfo("CFAPattern", 41730, FIELD_TYPE_UNDEFINED, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_CUSTOM_RENDERED = new TagInfo("Custom Rendered", 41985, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final int CUSTOM_RENDERED_VALUE_CUSTOM = 1;
    public static final TagInfo EXIF_TAG_EXPOSURE_MODE = new TagInfo("Exposure Mode", 41986, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final int EXPOSURE_MODE_VALUE_MANUAL = 1;
    public static final int EXPOSURE_MODE_VALUE_AUTO_BRACKET = 2;
    public static final TagInfo EXIF_TAG_WHITE_BALANCE_1 = new TagInfo("White Balance", 41987, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final int WHITE_BALANCE_1_VALUE_MANUAL = 1;
    public static final TagInfo EXIF_TAG_DIGITAL_ZOOM_RATIO = new TagInfo("Digital Zoom Ratio", 41988, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_FOCAL_LENGTH_IN_35MM_FORMAT = new TagInfo("Focal Length In 3 5mm Format", 41989, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_SCENE_CAPTURE_TYPE = new TagInfo("Scene Capture Type", 41990, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final int SCENE_CAPTURE_TYPE_VALUE_LANDSCAPE = 1;
    public static final int SCENE_CAPTURE_TYPE_VALUE_PORTRAIT = 2;
    public static final int SCENE_CAPTURE_TYPE_VALUE_NIGHT = 3;
    public static final TagInfo EXIF_TAG_GAIN_CONTROL = new TagInfo("Gain Control", 41991, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final int GAIN_CONTROL_VALUE_LOW_GAIN_UP = 1;
    public static final int GAIN_CONTROL_VALUE_HIGH_GAIN_UP = 2;
    public static final int GAIN_CONTROL_VALUE_LOW_GAIN_DOWN = 3;
    public static final int GAIN_CONTROL_VALUE_HIGH_GAIN_DOWN = 4;
    public static final TagInfo EXIF_TAG_CONTRAST_1 = new TagInfo("Contrast", 41992, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final int CONTRAST_1_VALUE_LOW = 1;
    public static final int CONTRAST_1_VALUE_HIGH = 2;
    public static final TagInfo EXIF_TAG_SATURATION_1 = new TagInfo("Saturation", 41993, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final int SATURATION_1_VALUE_LOW = 1;
    public static final int SATURATION_1_VALUE_HIGH = 2;
    public static final TagInfo EXIF_TAG_SHARPNESS_1 = new TagInfo("Sharpness", 41994, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final int SHARPNESS_1_VALUE_SOFT = 1;
    public static final int SHARPNESS_1_VALUE_HARD = 2;
    public static final TagInfo EXIF_TAG_DEVICE_SETTING_DESCRIPTION = new TagInfo("Device Setting Description", 41995, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_SUBJECT_DISTANCE_RANGE = new TagInfo("Subject Distance Range", 41996, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final int SUBJECT_DISTANCE_RANGE_VALUE_CLOSE = 2;
    public static final int SUBJECT_DISTANCE_RANGE_VALUE_DISTANT = 3;
    public static final TagInfo EXIF_TAG_IMAGE_UNIQUE_ID = new TagInfo("Image Unique ID", 42016, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_GDALMETADATA = new TagInfo("GDALMetadata", 42112, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_GDALNO_DATA = new TagInfo("GDALNo Data", 42113, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_GAMMA = new TagInfo("Gamma", 42240, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_PIXEL_FORMAT = new TagInfo("Pixel Format", 48129, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final int PIXEL_FORMAT_VALUE_8_BIT_GRAY = 8;
    public static final int PIXEL_FORMAT_VALUE_16_BIT_BGR555 = 9;
    public static final int PIXEL_FORMAT_VALUE_16_BIT_BGR565 = 10;
    public static final int PIXEL_FORMAT_VALUE_16_BIT_GRAY = 11;
    public static final int PIXEL_FORMAT_VALUE_24_BIT_BGR = 12;
    public static final int PIXEL_FORMAT_VALUE_24_BIT_RGB = 13;
    public static final int PIXEL_FORMAT_VALUE_32_BIT_BGR = 14;
    public static final int PIXEL_FORMAT_VALUE_32_BIT_BGRA = 15;
    public static final int PIXEL_FORMAT_VALUE_32_BIT_PBGRA = 16;
    public static final int PIXEL_FORMAT_VALUE_32_BIT_GRAY_FLOAT = 17;
    public static final int PIXEL_FORMAT_VALUE_48_BIT_RGB_FIXED_POINT = 18;
    public static final int PIXEL_FORMAT_VALUE_32_BIT_BGR101010 = 19;
    public static final int PIXEL_FORMAT_VALUE_48_BIT_RGB = 21;
    public static final int PIXEL_FORMAT_VALUE_64_BIT_RGBA = 22;
    public static final int PIXEL_FORMAT_VALUE_64_BIT_PRGBA = 23;
    public static final int PIXEL_FORMAT_VALUE_96_BIT_RGB_FIXED_POINT = 24;
    public static final int PIXEL_FORMAT_VALUE_128_BIT_RGBA_FLOAT = 25;
    public static final int PIXEL_FORMAT_VALUE_128_BIT_PRGBA_FLOAT = 26;
    public static final int PIXEL_FORMAT_VALUE_128_BIT_RGB_FLOAT = 27;
    public static final int PIXEL_FORMAT_VALUE_32_BIT_CMYK = 28;
    public static final int PIXEL_FORMAT_VALUE_64_BIT_RGBA_FIXED_POINT = 29;
    public static final int PIXEL_FORMAT_VALUE_128_BIT_RGBA_FIXED_POINT = 30;
    public static final int PIXEL_FORMAT_VALUE_64_BIT_CMYK = 31;
    public static final int PIXEL_FORMAT_VALUE_24_BIT_3_CHANNELS = 32;
    public static final int PIXEL_FORMAT_VALUE_32_BIT_4_CHANNELS = 33;
    public static final int PIXEL_FORMAT_VALUE_40_BIT_5_CHANNELS = 34;
    public static final int PIXEL_FORMAT_VALUE_48_BIT_6_CHANNELS = 35;
    public static final int PIXEL_FORMAT_VALUE_56_BIT_7_CHANNELS = 36;
    public static final int PIXEL_FORMAT_VALUE_64_BIT_8_CHANNELS = 37;
    public static final int PIXEL_FORMAT_VALUE_48_BIT_3_CHANNELS = 38;
    public static final int PIXEL_FORMAT_VALUE_64_BIT_4_CHANNELS = 39;
    public static final int PIXEL_FORMAT_VALUE_80_BIT_5_CHANNELS = 40;
    public static final int PIXEL_FORMAT_VALUE_96_BIT_6_CHANNELS = 41;
    public static final int PIXEL_FORMAT_VALUE_112_BIT_7_CHANNELS = 42;
    public static final int PIXEL_FORMAT_VALUE_128_BIT_8_CHANNELS = 43;
    public static final int PIXEL_FORMAT_VALUE_40_BIT_CMYK_ALPHA = 44;
    public static final int PIXEL_FORMAT_VALUE_80_BIT_CMYK_ALPHA = 45;
    public static final int PIXEL_FORMAT_VALUE_32_BIT_3_CHANNELS_ALPHA = 46;
    public static final int PIXEL_FORMAT_VALUE_40_BIT_4_CHANNELS_ALPHA = 47;
    public static final int PIXEL_FORMAT_VALUE_48_BIT_5_CHANNELS_ALPHA = 48;
    public static final int PIXEL_FORMAT_VALUE_56_BIT_6_CHANNELS_ALPHA = 49;
    public static final int PIXEL_FORMAT_VALUE_64_BIT_7_CHANNELS_ALPHA = 50;
    public static final int PIXEL_FORMAT_VALUE_72_BIT_8_CHANNELS_ALPHA = 51;
    public static final int PIXEL_FORMAT_VALUE_64_BIT_3_CHANNELS_ALPHA = 52;
    public static final int PIXEL_FORMAT_VALUE_80_BIT_4_CHANNELS_ALPHA = 53;
    public static final int PIXEL_FORMAT_VALUE_96_BIT_5_CHANNELS_ALPHA = 54;
    public static final int PIXEL_FORMAT_VALUE_112_BIT_6_CHANNELS_ALPHA = 55;
    public static final int PIXEL_FORMAT_VALUE_128_BIT_7_CHANNELS_ALPHA = 56;
    public static final int PIXEL_FORMAT_VALUE_144_BIT_8_CHANNELS_ALPHA = 57;
    public static final int PIXEL_FORMAT_VALUE_64_BIT_RGBA_HALF = 58;
    public static final int PIXEL_FORMAT_VALUE_48_BIT_RGB_HALF = 59;
    public static final int PIXEL_FORMAT_VALUE_32_BIT_RGBE = 61;
    public static final int PIXEL_FORMAT_VALUE_16_BIT_GRAY_HALF = 62;
    public static final int PIXEL_FORMAT_VALUE_32_BIT_GRAY_FIXED_POINT = 63;
    public static final TagInfo EXIF_TAG_TRANSFOMATION = new TagInfo("Transfomation", 48130, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final int TRANSFOMATION_VALUE_MIRROR_VERTICAL = 1;
    public static final int TRANSFOMATION_VALUE_MIRROR_HORIZONTAL = 2;
    public static final int TRANSFOMATION_VALUE_ROTATE_180 = 3;
    public static final int TRANSFOMATION_VALUE_ROTATE_90_CW = 4;
    public static final int TRANSFOMATION_VALUE_MIRROR_HORIZONTAL_AND_ROTATE_90_CW = 5;
    public static final int TRANSFOMATION_VALUE_MIRROR_HORIZONTAL_AND_ROTATE_270_CW = 6;
    public static final int TRANSFOMATION_VALUE_ROTATE_270_CW = 7;
    public static final TagInfo EXIF_TAG_UNCOMPRESSED = new TagInfo("Uncompressed", 48131, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final int UNCOMPRESSED_VALUE_YES = 1;
    public static final TagInfo EXIF_TAG_IMAGE_TYPE = new TagInfo("Image Type", 48132, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_IMAGE_WIDTH = new TagInfo("Image Width", 48256, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_IMAGE_HEIGHT = new TagInfo("Image Height", 48257, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_WIDTH_RESOLUTION = new TagInfo("Width Resolution", 48258, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_HEIGHT_RESOLUTION = new TagInfo("Height Resolution", 48259, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_IMAGE_OFFSET = new TagInfo("Image Offset", 48320, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_IMAGE_BYTE_COUNT = new TagInfo("Image Byte Count", 48321, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_ALPHA_OFFSET = new TagInfo("Alpha Offset", 48322, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_ALPHA_BYTE_COUNT = new TagInfo("Alpha Byte Count", 48323, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_IMAGE_DATA_DISCARD = new TagInfo("Image Data Discard", 48324, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final int IMAGE_DATA_DISCARD_VALUE_FLEXBITS_DISCARDED = 1;
    public static final int IMAGE_DATA_DISCARD_VALUE_HIGH_PASS_FREQUENCY_DATA_DISCARDED = 2;
    public static final int IMAGE_DATA_DISCARD_VALUE_HIGHPASS_AND_LOW_PASS_FREQUENCY_DATA_DISCARDED = 3;
    public static final TagInfo EXIF_TAG_ALPHA_DATA_DISCARD = new TagInfo("Alpha Data Discard", 48325, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final int ALPHA_DATA_DISCARD_VALUE_FLEXBITS_DISCARDED = 1;
    public static final int ALPHA_DATA_DISCARD_VALUE_HIGH_PASS_FREQUENCY_DATA_DISCARDED = 2;
    public static final int ALPHA_DATA_DISCARD_VALUE_HIGHPASS_AND_LOW_PASS_FREQUENCY_DATA_DISCARDED = 3;
    public static final TagInfo EXIF_TAG_OCE_SCANJOB_DESC = new TagInfo("Oce Scanjob Desc", 50215, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_OCE_APPLICATION_SELECTOR = new TagInfo("Oce Application Selector", 50216, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_OCE_IDNUMBER = new TagInfo("Oce IDNumber", 50217, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_OCE_IMAGE_LOGIC = new TagInfo("Oce Image Logic", 50218, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_ANNOTATIONS = new TagInfo("Annotations", 50255, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_PRINT_IM = new TagInfo("Print IM", 50341, FIELD_TYPE_UNDEFINED, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_DNG_VERSION = new TagInfo("DNG Version", 50706, FIELD_TYPE_BYTE, 4, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_DNG_BACKWARD_VERSION = new TagInfo("DNG Backward Version", 50707, FIELD_TYPE_BYTE, 4, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_UNIQUE_CAMERA_MODEL = new TagInfo("Unique Camera Model", 50708, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_LOCALIZED_CAMERA_MODEL = new TagInfo("Localized Camera Model", 50709, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_CFAPLANE_COLOR = new TagInfo("CFAPlane Color", 50710, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_CFALAYOUT = new TagInfo("CFALayout", 50711, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final int CFALAYOUT_VALUE_EVEN_COLUMNS_OFFSET_DOWN_1_2_ROW = 2;
    public static final int CFALAYOUT_VALUE_EVEN_COLUMNS_OFFSET_UP_1_2_ROW = 3;
    public static final int CFALAYOUT_VALUE_EVEN_ROWS_OFFSET_RIGHT_1_2_COLUMN = 4;
    public static final int CFALAYOUT_VALUE_EVEN_ROWS_OFFSET_LEFT_1_2_COLUMN = 5;
    public static final TagInfo EXIF_TAG_LINEARIZATION_TABLE = new TagInfo("Linearization Table", 50712, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_BLACK_LEVEL_REPEAT_DIM = new TagInfo("Black Level Repeat Dim", 50713, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_BLACK_LEVEL = new TagInfo("Black Level", 50714, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_BLACK_LEVEL_DELTA_H = new TagInfo("Black Level Delta H", 50715, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_BLACK_LEVEL_DELTA_V = new TagInfo("Black Level Delta V", 50716, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_WHITE_LEVEL = new TagInfo("White Level", 50717, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_DEFAULT_SCALE = new TagInfo("Default Scale", 50718, FIELD_TYPE_RATIONAL, 2, EXIF_DIRECTORY_SUB_IFD);
    public static final TagInfo EXIF_TAG_DEFAULT_CROP_ORIGIN = new TagInfo("Default Crop Origin", 50719, FIELD_TYPE_LONG, 2, EXIF_DIRECTORY_SUB_IFD);
    public static final TagInfo EXIF_TAG_DEFAULT_CROP_SIZE = new TagInfo("Default Crop Size", 50720, FIELD_TYPE_LONG, 2, EXIF_DIRECTORY_SUB_IFD);
    public static final TagInfo EXIF_TAG_COLOR_MATRIX_1 = new TagInfo("Color Matrix 1", 50721, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_COLOR_MATRIX_2 = new TagInfo("Color Matrix 2", 50722, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_CAMERA_CALIBRATION_1 = new TagInfo("Camera Calibration 1", 50723, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_CAMERA_CALIBRATION_2 = new TagInfo("Camera Calibration 2", 50724, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_REDUCTION_MATRIX_1 = new TagInfo("Reduction Matrix 1", 50725, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_REDUCTION_MATRIX_2 = new TagInfo("Reduction Matrix 2", 50726, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_ANALOG_BALANCE = new TagInfo("Analog Balance", 50727, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_AS_SHOT_NEUTRAL = new TagInfo("As Shot Neutral", 50728, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_AS_SHOT_WHITE_XY = new TagInfo("As Shot White XY", 50729, FIELD_TYPE_RATIONAL, 2, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_BASELINE_EXPOSURE = new TagInfo("Baseline Exposure", 50730, FIELD_TYPE_SRATIONAL, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_BASELINE_NOISE = new TagInfo("Baseline Noise", 50731, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_BASELINE_SHARPNESS = new TagInfo("Baseline Sharpness", 50732, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_BAYER_GREEN_SPLIT = new TagInfo("Bayer Green Split", 50733, FIELD_TYPE_LONG, 1, EXIF_DIRECTORY_SUB_IFD);
    public static final TagInfo EXIF_TAG_LINEAR_RESPONSE_LIMIT = new TagInfo("Linear Response Limit", 50734, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_CAMERA_SERIAL_NUMBER = new TagInfo("Camera Serial Number", 50735, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_DNG_LENS_INFO = new TagInfo("DNG Lens Info", 50736, FIELD_TYPE_RATIONAL, 4, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_CHROMA_BLUR_RADIUS = new TagInfo("Chroma Blur Radius", 50737, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_SUB_IFD);
    public static final TagInfo EXIF_TAG_ANTI_ALIAS_STRENGTH = new TagInfo("Anti Alias Strength", 50738, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_SUB_IFD);
    public static final TagInfo EXIF_TAG_SHADOW_SCALE = new TagInfo("Shadow Scale", 50739, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_DNG_ADOBE_DATA = new TagInfo("DNG Adobe Data", 50740, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_DNG_PENTAX_DATA = new TagInfo("DNG Pentax Data", 50740, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_DNG_PRIVATE_DATA = new TagInfo("DNG Private Data", 50740, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_MAKER_NOTE_SAFETY = new TagInfo("Maker Note Safety", 50741, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final int MAKER_NOTE_SAFETY_VALUE_SAFE = 1;
    public static final TagInfo EXIF_TAG_CALIBRATION_ILLUMINANT_1 = new TagInfo("Calibration Illuminant 1", 50778, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_FLUORESCENT = 2;
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_TUNGSTEN = 3;
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_FLASH = 4;
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_FINE_WEATHER = 9;
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_CLOUDY = 10;
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_SHADE = 11;
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_DAYLIGHT_FLUORESCENT = 12;
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_DAY_WHITE_FLUORESCENT = 13;
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_COOL_WHITE_FLUORESCENT = 14;
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_WHITE_FLUORESCENT = 15;
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_STANDARD_LIGHT_A = 17;
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_STANDARD_LIGHT_B = 18;
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_STANDARD_LIGHT_C = 19;
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_D55 = 20;
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_D65 = 21;
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_D75 = 22;
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_D50 = 23;
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_ISO_STUDIO_TUNGSTEN = 24;
    public static final int CALIBRATION_ILLUMINANT_1_VALUE_OTHER = 255;
    public static final TagInfo EXIF_TAG_CALIBRATION_ILLUMINANT_2 = new TagInfo("Calibration Illuminant 2", 50779, FIELD_TYPE_SHORT, 1, EXIF_DIRECTORY_IFD0);
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_FLUORESCENT = 2;
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_TUNGSTEN = 3;
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_FLASH = 4;
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_FINE_WEATHER = 9;
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_CLOUDY = 10;
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_SHADE = 11;
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_DAYLIGHT_FLUORESCENT = 12;
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_DAY_WHITE_FLUORESCENT = 13;
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_COOL_WHITE_FLUORESCENT = 14;
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_WHITE_FLUORESCENT = 15;
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_STANDARD_LIGHT_A = 17;
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_STANDARD_LIGHT_B = 18;
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_STANDARD_LIGHT_C = 19;
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_D55 = 20;
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_D65 = 21;
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_D75 = 22;
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_D50 = 23;
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_ISO_STUDIO_TUNGSTEN = 24;
    public static final int CALIBRATION_ILLUMINANT_2_VALUE_OTHER = 255;
    public static final TagInfo EXIF_TAG_BEST_QUALITY_SCALE = new TagInfo("Best Quality Scale", 50780, FIELD_TYPE_RATIONAL, 1, EXIF_DIRECTORY_SUB_IFD);
    public static final TagInfo EXIF_TAG_RAW_DATA_UNIQUE_ID = new TagInfo("Raw Data Unique ID", 50781, FIELD_TYPE_BYTE, 16, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_ALIAS_LAYER_METADATA = new TagInfo("Alias Layer Metadata", 50784, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_ORIGINAL_RAW_FILE_NAME = new TagInfo("Original Raw File Name", 50827, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_ORIGINAL_RAW_FILE_DATA = new TagInfo("Original Raw File Data", 50828, FIELD_TYPE_UNDEFINED, 1, EXIF_DIRECTORY_IFD0);
    public static final TagInfo EXIF_TAG_ACTIVE_AREA = new TagInfo("Active Area", 50829, FIELD_TYPE_LONG, 4, EXIF_DIRECTORY_SUB_IFD);
    public static final TagInfo EXIF_TAG_MASKED_AREAS = new TagInfo("Masked Areas", 50830, FIELD_TYPE_LONG, 4, EXIF_DIRECTORY_SUB_IFD);
    public static final TagInfo EXIF_TAG_AS_SHOT_ICCPROFILE = new TagInfo("As Shot ICCProfile", 50831, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_AS_SHOT_PRE_PROFILE_MATRIX = new TagInfo("As Shot Pre Profile Matrix", 50832, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_CURRENT_ICCPROFILE = new TagInfo("Current ICCProfile", 50833, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_CURRENT_PRE_PROFILE_MATRIX = new TagInfo("Current Pre Profile Matrix", 50834, FIELD_TYPE_DESCRIPTION_UNKNOWN, 1, EXIF_DIRECTORY_UNKNOWN);
    public static final TagInfo EXIF_TAG_OFFSET_SCHEMA = new TagInfo("Offset Schema", 59933, FIELD_TYPE_SLONG, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_OWNER_NAME = new TagInfo("Owner Name", 65000, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_SERIAL_NUMBER = new TagInfo("Serial Number", 65001, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_LENS = new TagInfo("Lens", 65002, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_RAW_FILE = new TagInfo("Raw File", 65100, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_CONVERTER = new TagInfo("Converter", 65101, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_WHITE_BALANCE_2 = new TagInfo("White Balance", 65102, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_EXPOSURE = new TagInfo("Exposure", 65105, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_SHADOWS = new TagInfo("Shadows", 65106, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_BRIGHTNESS = new TagInfo("Brightness", 65107, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_CONTRAST_2 = new TagInfo("Contrast", 65108, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_SATURATION_2 = new TagInfo("Saturation", 65109, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_SHARPNESS_2 = new TagInfo("Sharpness", 65110, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_SMOOTHNESS = new TagInfo("Smoothness", 65111, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo EXIF_TAG_MOIRE_FILTER = new TagInfo("Moire Filter", 65112, FIELD_TYPE_ASCII, 1, EXIF_DIRECTORY_EXIF_IFD);
    public static final TagInfo[] ALL_EXIF_TAGS = new TagInfo[]{EXIF_TAG_INTEROP_INDEX, EXIF_TAG_INTEROP_VERSION, EXIF_TAG_PROCESSING_SOFTWARE, EXIF_TAG_SUBFILE_TYPE, EXIF_TAG_OLD_SUBFILE_TYPE, EXIF_TAG_IMAGE_WIDTH_IFD0, EXIF_TAG_IMAGE_HEIGHT_IFD0, EXIF_TAG_BITS_PER_SAMPLE, EXIF_TAG_COMPRESSION, EXIF_TAG_PHOTOMETRIC_INTERPRETATION, EXIF_TAG_THRESHOLDING, EXIF_TAG_CELL_WIDTH, EXIF_TAG_CELL_LENGTH, EXIF_TAG_FILL_ORDER, EXIF_TAG_DOCUMENT_NAME, EXIF_TAG_IMAGE_DESCRIPTION, EXIF_TAG_MAKE, EXIF_TAG_MODEL, EXIF_TAG_PREVIEW_IMAGE_START_IFD0, EXIF_TAG_PREVIEW_IMAGE_START_SUB_IFD1, EXIF_TAG_JPG_FROM_RAW_START_SUB_IFD2, EXIF_TAG_ORIENTATION, EXIF_TAG_SAMPLES_PER_PIXEL, EXIF_TAG_ROWS_PER_STRIP, EXIF_TAG_PREVIEW_IMAGE_LENGTH_IFD0, EXIF_TAG_PREVIEW_IMAGE_LENGTH_SUB_IFD1, EXIF_TAG_JPG_FROM_RAW_LENGTH_SUB_IFD2, EXIF_TAG_MIN_SAMPLE_VALUE, EXIF_TAG_MAX_SAMPLE_VALUE, EXIF_TAG_XRESOLUTION, EXIF_TAG_YRESOLUTION, EXIF_TAG_PLANAR_CONFIGURATION, EXIF_TAG_PAGE_NAME, EXIF_TAG_XPOSITION, EXIF_TAG_YPOSITION, EXIF_TAG_FREE_OFFSETS, EXIF_TAG_FREE_BYTE_COUNTS, EXIF_TAG_GRAY_RESPONSE_UNIT, EXIF_TAG_GRAY_RESPONSE_CURVE, EXIF_TAG_T4OPTIONS, EXIF_TAG_T6OPTIONS, EXIF_TAG_RESOLUTION_UNIT, EXIF_TAG_PAGE_NUMBER, EXIF_TAG_COLOR_RESPONSE_UNIT, EXIF_TAG_TRANSFER_FUNCTION, EXIF_TAG_SOFTWARE, EXIF_TAG_MODIFY_DATE, EXIF_TAG_ARTIST, EXIF_TAG_HOST_COMPUTER, EXIF_TAG_PREDICTOR, EXIF_TAG_WHITE_POINT, EXIF_TAG_PRIMARY_CHROMATICITIES, EXIF_TAG_COLOR_MAP, EXIF_TAG_HALFTONE_HINTS, EXIF_TAG_TILE_WIDTH, EXIF_TAG_TILE_LENGTH, EXIF_TAG_TILE_OFFSETS, EXIF_TAG_TILE_BYTE_COUNTS, EXIF_TAG_BAD_FAX_LINES, EXIF_TAG_CLEAN_FAX_DATA, EXIF_TAG_CONSECUTIVE_BAD_FAX_LINES, EXIF_TAG_SUB_IFD, EXIF_TAG_INK_SET, EXIF_TAG_INK_NAMES, EXIF_TAG_NUMBEROF_INKS, EXIF_TAG_DOT_RANGE, EXIF_TAG_TARGET_PRINTER, EXIF_TAG_EXTRA_SAMPLES, EXIF_TAG_SAMPLE_FORMAT, EXIF_TAG_SMIN_SAMPLE_VALUE, EXIF_TAG_SMAX_SAMPLE_VALUE, EXIF_TAG_TRANSFER_RANGE, EXIF_TAG_CLIP_PATH, EXIF_TAG_XCLIP_PATH_UNITS, EXIF_TAG_YCLIP_PATH_UNITS, EXIF_TAG_INDEXED, EXIF_TAG_JPEGTABLES, EXIF_TAG_OPIPROXY, EXIF_TAG_GLOBAL_PARAMETERS_IFD, EXIF_TAG_PROFILE_TYPE, EXIF_TAG_FAX_PROFILE, EXIF_TAG_CODING_METHODS, EXIF_TAG_VERSION_YEAR, EXIF_TAG_MODE_NUMBER, EXIF_TAG_DECODE, EXIF_TAG_DEFAULT_IMAGE_COLOR, EXIF_TAG_JPEGPROC, EXIF_TAG_PREVIEW_IMAGE_START_MAKER_NOTES, EXIF_TAG_JPG_FROM_RAW_START_SUB_IFD, EXIF_TAG_JPG_FROM_RAW_START_IFD2, EXIF_TAG_OTHER_IMAGE_START, EXIF_TAG_PREVIEW_IMAGE_LENGTH_MAKER_NOTES, EXIF_TAG_JPG_FROM_RAW_LENGTH_SUB_IFD, EXIF_TAG_JPG_FROM_RAW_LENGTH_IFD2, EXIF_TAG_OTHER_IMAGE_LENGTH, EXIF_TAG_JPEGRESTART_INTERVAL, EXIF_TAG_JPEGLOSSLESS_PREDICTORS, EXIF_TAG_JPEGPOINT_TRANSFORMS, EXIF_TAG_JPEGQTABLES, EXIF_TAG_JPEGDCTABLES, EXIF_TAG_JPEGACTABLES, EXIF_TAG_YCBCR_COEFFICIENTS, EXIF_TAG_YCBCR_SUB_SAMPLING, EXIF_TAG_YCBCR_POSITIONING, EXIF_TAG_REFERENCE_BLACK_WHITE, EXIF_TAG_STRIP_ROW_COUNTS, EXIF_TAG_APPLICATION_NOTES, EXIF_TAG_RELATED_IMAGE_FILE_FORMAT, EXIF_TAG_RELATED_IMAGE_WIDTH, EXIF_TAG_RELATED_IMAGE_LENGTH, EXIF_TAG_RATING, EXIF_TAG_RATING_PERCENT, EXIF_TAG_IMAGE_ID, EXIF_TAG_WANG_ANNOTATION, EXIF_TAG_MATTEING, EXIF_TAG_DATA_TYPE, EXIF_TAG_IMAGE_DEPTH, EXIF_TAG_TILE_DEPTH, EXIF_TAG_MODEL_2, EXIF_TAG_CFAREPEAT_PATTERN_DIM, EXIF_TAG_CFAPATTERN_2, EXIF_TAG_BATTERY_LEVEL, EXIF_TAG_COPYRIGHT, EXIF_TAG_EXPOSURE_TIME, EXIF_TAG_FNUMBER, EXIF_TAG_MDFILE_TAG, EXIF_TAG_MDSCALE_PIXEL, EXIF_TAG_MDCOLOR_TABLE, EXIF_TAG_MDLAB_NAME, EXIF_TAG_MDSAMPLE_INFO, EXIF_TAG_MDPREP_DATE, EXIF_TAG_MDPREP_TIME, EXIF_TAG_MDFILE_UNITS, EXIF_TAG_PIXEL_SCALE, EXIF_TAG_IPTC_NAA, EXIF_TAG_INTERGRAPH_PACKET_DATA, EXIF_TAG_INTERGRAPH_FLAG_REGISTERS, EXIF_TAG_INTERGRAPH_MATRIX, EXIF_TAG_MODEL_TIE_POINT, EXIF_TAG_SITE, EXIF_TAG_COLOR_SEQUENCE, EXIF_TAG_IT8HEADER, EXIF_TAG_RASTER_PADDING, EXIF_TAG_BITS_PER_RUN_LENGTH, EXIF_TAG_BITS_PER_EXTENDED_RUN_LENGTH, EXIF_TAG_COLOR_TABLE, EXIF_TAG_IMAGE_COLOR_INDICATOR, EXIF_TAG_BACKGROUND_COLOR_INDICATOR, EXIF_TAG_IMAGE_COLOR_VALUE, EXIF_TAG_BACKGROUND_COLOR_VALUE, EXIF_TAG_PIXEL_INTENSITY_RANGE, EXIF_TAG_TRANSPARENCY_INDICATOR, EXIF_TAG_COLOR_CHARACTERIZATION, EXIF_TAG_HCUSAGE, EXIF_TAG_SEMINFO, EXIF_TAG_AFCP_IPTC, EXIF_TAG_MODEL_TRANSFORM, EXIF_TAG_LEAF_DATA, EXIF_TAG_PHOTOSHOP_SETTINGS, EXIF_TAG_EXIF_OFFSET, EXIF_TAG_ICC_PROFILE, EXIF_TAG_IMAGE_LAYER, EXIF_TAG_GEO_TIFF_DIRECTORY, EXIF_TAG_GEO_TIFF_DOUBLE_PARAMS, EXIF_TAG_GEO_TIFF_ASCII_PARAMS, EXIF_TAG_EXPOSURE_PROGRAM, EXIF_TAG_SPECTRAL_SENSITIVITY, EXIF_TAG_GPSINFO, EXIF_TAG_ISO, EXIF_TAG_OPTO__ELECTRIC_CONV_FACTOR, EXIF_TAG_INTERLACE, EXIF_TAG_TIME_ZONE_OFFSET, EXIF_TAG_SELF_TIMER_MODE, EXIF_TAG_FAX_RECV_PARAMS, EXIF_TAG_FAX_SUB_ADDRESS, EXIF_TAG_FAX_RECV_TIME, EXIF_TAG_LEAF_SUB_IFD, EXIF_TAG_EXIF_VERSION, EXIF_TAG_DATE_TIME_ORIGINAL, EXIF_TAG_CREATE_DATE, EXIF_TAG_COMPONENTS_CONFIGURATION, EXIF_TAG_COMPRESSED_BITS_PER_PIXEL, EXIF_TAG_SHUTTER_SPEED_VALUE, EXIF_TAG_APERTURE_VALUE, EXIF_TAG_BRIGHTNESS_VALUE, EXIF_TAG_EXPOSURE_COMPENSATION, EXIF_TAG_MAX_APERTURE_VALUE, EXIF_TAG_SUBJECT_DISTANCE, EXIF_TAG_METERING_MODE, EXIF_TAG_LIGHT_SOURCE, EXIF_TAG_FLASH, EXIF_TAG_FOCAL_LENGTH, EXIF_TAG_FLASH_ENERGY, EXIF_TAG_SPATIAL_FREQUENCY_RESPONSE_1, EXIF_TAG_NOISE_1, EXIF_TAG_FOCAL_PLANE_XRESOLUTION, EXIF_TAG_FOCAL_PLANE_YRESOLUTION, EXIF_TAG_FOCAL_PLANE_RESOLUTION_UNIT, EXIF_TAG_IMAGE_NUMBER_EXIF_IFD, EXIF_TAG_SECURITY_CLASSIFICATION_EXIF_IFD, EXIF_TAG_IMAGE_HISTORY_EXIF_IFD, EXIF_TAG_SUBJECT_LOCATION_1, EXIF_TAG_EXPOSURE_INDEX, EXIF_TAG_TIFF_EPSTANDARD_ID_1, EXIF_TAG_SENSING_METHOD, EXIF_TAG_STO_NITS, EXIF_TAG_SUB_SEC_TIME, EXIF_TAG_SUB_SEC_TIME_ORIGINAL, EXIF_TAG_SUB_SEC_TIME_DIGITIZED, EXIF_TAG_IMAGE_SOURCE_DATA, EXIF_TAG_XPTITLE, EXIF_TAG_XPCOMMENT, EXIF_TAG_XPAUTHOR, EXIF_TAG_XPKEYWORDS, EXIF_TAG_XPSUBJECT, EXIF_TAG_FLASHPIX_VERSION, EXIF_TAG_COLOR_SPACE, EXIF_TAG_EXIF_IMAGE_WIDTH, EXIF_TAG_EXIF_IMAGE_LENGTH, EXIF_TAG_RELATED_SOUND_FILE, EXIF_TAG_INTEROP_OFFSET, EXIF_TAG_FLASH_ENERGY_EXIF_IFD, EXIF_TAG_SPATIAL_FREQUENCY_RESPONSE_2, EXIF_TAG_NOISE_2, EXIF_TAG_FOCAL_PLANE_XRESOLUTION_EXIF_IFD, EXIF_TAG_FOCAL_PLANE_YRESOLUTION_EXIF_IFD, EXIF_TAG_FOCAL_PLANE_RESOLUTION_UNIT_EXIF_IFD, EXIF_TAG_IMAGE_NUMBER, EXIF_TAG_SECURITY_CLASSIFICATION, EXIF_TAG_IMAGE_HISTORY, EXIF_TAG_SUBJECT_LOCATION_2, EXIF_TAG_EXPOSURE_INDEX_EXIF_IFD, EXIF_TAG_TIFF_EPSTANDARD_ID_2, EXIF_TAG_SENSING_METHOD_EXIF_IFD, EXIF_TAG_FILE_SOURCE, EXIF_TAG_SCENE_TYPE, EXIF_TAG_CFAPATTERN, EXIF_TAG_CUSTOM_RENDERED, EXIF_TAG_EXPOSURE_MODE, EXIF_TAG_WHITE_BALANCE_1, EXIF_TAG_DIGITAL_ZOOM_RATIO, EXIF_TAG_FOCAL_LENGTH_IN_35MM_FORMAT, EXIF_TAG_SCENE_CAPTURE_TYPE, EXIF_TAG_GAIN_CONTROL, EXIF_TAG_CONTRAST_1, EXIF_TAG_SATURATION_1, EXIF_TAG_SHARPNESS_1, EXIF_TAG_DEVICE_SETTING_DESCRIPTION, EXIF_TAG_SUBJECT_DISTANCE_RANGE, EXIF_TAG_IMAGE_UNIQUE_ID, EXIF_TAG_GDALMETADATA, EXIF_TAG_GDALNO_DATA, EXIF_TAG_GAMMA, EXIF_TAG_PIXEL_FORMAT, EXIF_TAG_TRANSFOMATION, EXIF_TAG_UNCOMPRESSED, EXIF_TAG_IMAGE_TYPE, EXIF_TAG_IMAGE_WIDTH, EXIF_TAG_IMAGE_HEIGHT, EXIF_TAG_WIDTH_RESOLUTION, EXIF_TAG_HEIGHT_RESOLUTION, EXIF_TAG_IMAGE_OFFSET, EXIF_TAG_IMAGE_BYTE_COUNT, EXIF_TAG_ALPHA_OFFSET, EXIF_TAG_ALPHA_BYTE_COUNT, EXIF_TAG_IMAGE_DATA_DISCARD, EXIF_TAG_ALPHA_DATA_DISCARD, EXIF_TAG_OCE_SCANJOB_DESC, EXIF_TAG_OCE_APPLICATION_SELECTOR, EXIF_TAG_OCE_IDNUMBER, EXIF_TAG_OCE_IMAGE_LOGIC, EXIF_TAG_ANNOTATIONS, EXIF_TAG_PRINT_IM, EXIF_TAG_DNG_VERSION, EXIF_TAG_DNG_BACKWARD_VERSION, EXIF_TAG_UNIQUE_CAMERA_MODEL, EXIF_TAG_LOCALIZED_CAMERA_MODEL, EXIF_TAG_CFAPLANE_COLOR, EXIF_TAG_CFALAYOUT, EXIF_TAG_LINEARIZATION_TABLE, EXIF_TAG_BLACK_LEVEL_REPEAT_DIM, EXIF_TAG_BLACK_LEVEL, EXIF_TAG_BLACK_LEVEL_DELTA_H, EXIF_TAG_BLACK_LEVEL_DELTA_V, EXIF_TAG_WHITE_LEVEL, EXIF_TAG_DEFAULT_SCALE, EXIF_TAG_DEFAULT_CROP_ORIGIN, EXIF_TAG_DEFAULT_CROP_SIZE, EXIF_TAG_COLOR_MATRIX_1, EXIF_TAG_COLOR_MATRIX_2, EXIF_TAG_CAMERA_CALIBRATION_1, EXIF_TAG_CAMERA_CALIBRATION_2, EXIF_TAG_REDUCTION_MATRIX_1, EXIF_TAG_REDUCTION_MATRIX_2, EXIF_TAG_ANALOG_BALANCE, EXIF_TAG_AS_SHOT_NEUTRAL, EXIF_TAG_AS_SHOT_WHITE_XY, EXIF_TAG_BASELINE_EXPOSURE, EXIF_TAG_BASELINE_NOISE, EXIF_TAG_BASELINE_SHARPNESS, EXIF_TAG_BAYER_GREEN_SPLIT, EXIF_TAG_LINEAR_RESPONSE_LIMIT, EXIF_TAG_CAMERA_SERIAL_NUMBER, EXIF_TAG_DNG_LENS_INFO, EXIF_TAG_CHROMA_BLUR_RADIUS, EXIF_TAG_ANTI_ALIAS_STRENGTH, EXIF_TAG_SHADOW_SCALE, EXIF_TAG_DNG_ADOBE_DATA, EXIF_TAG_DNG_PENTAX_DATA, EXIF_TAG_DNG_PRIVATE_DATA, EXIF_TAG_MAKER_NOTE_SAFETY, EXIF_TAG_CALIBRATION_ILLUMINANT_1, EXIF_TAG_CALIBRATION_ILLUMINANT_2, EXIF_TAG_BEST_QUALITY_SCALE, EXIF_TAG_RAW_DATA_UNIQUE_ID, EXIF_TAG_ALIAS_LAYER_METADATA, EXIF_TAG_ORIGINAL_RAW_FILE_NAME, EXIF_TAG_ORIGINAL_RAW_FILE_DATA, EXIF_TAG_ACTIVE_AREA, EXIF_TAG_MASKED_AREAS, EXIF_TAG_AS_SHOT_ICCPROFILE, EXIF_TAG_AS_SHOT_PRE_PROFILE_MATRIX, EXIF_TAG_CURRENT_ICCPROFILE, EXIF_TAG_CURRENT_PRE_PROFILE_MATRIX, EXIF_TAG_OFFSET_SCHEMA, EXIF_TAG_OWNER_NAME, EXIF_TAG_SERIAL_NUMBER, EXIF_TAG_LENS, EXIF_TAG_RAW_FILE, EXIF_TAG_CONVERTER, EXIF_TAG_WHITE_BALANCE_2, EXIF_TAG_EXPOSURE, EXIF_TAG_SHADOWS, EXIF_TAG_BRIGHTNESS, EXIF_TAG_CONTRAST_2, EXIF_TAG_SATURATION_2, EXIF_TAG_SHARPNESS_2, EXIF_TAG_SMOOTHNESS, EXIF_TAG_MOIRE_FILTER, EXIF_TAG_USER_COMMENT, EXIF_TAG_MAKER_NOTE};
}

