/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.database.jdbc.CreateDBSchemaPlugin;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSchemaCreator {
    private static String SQL_ALREADYEXISTS = ".*((already exist)|(duplicate key)| (already used)|(ORA-00955))+.*";
    private final Pattern pattern;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.database.DBSchemaCreator");
    private List<CreateDBSchemaPlugin> createDBSchemaPlugins = new ArrayList<CreateDBSchemaPlugin>();

    public DBSchemaCreator(InitialContextInitializer contextInit) {
        this.pattern = Pattern.compile(SQL_ALREADYEXISTS, 2);
    }

    private DBSchemaCreator(String dsName, String script) throws SQLException, NamingException {
        this.pattern = Pattern.compile(SQL_ALREADYEXISTS, 2);
        this.createTables(dsName, script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTables(String dsName, String script) throws NamingException, SQLException {
        InitialContext context = new InitialContext();
        DataSource ds = (DataSource)context.lookup(dsName);
        Connection conn = ds.getConnection();
        String sql = "";
        try {
            String[] scripts;
            for (String scr : scripts = JDBCUtils.splitWithSQLDelimiter(script)) {
                String s = JDBCUtils.cleanWhitespaces(scr.trim());
                if (s.length() < 1) continue;
                sql = s;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Execute script: \n[" + sql + "]"));
                }
                try {
                    conn.setAutoCommit(false);
                    conn.createStatement().executeUpdate(sql);
                    conn.commit();
                }
                catch (SQLException e) {
                    conn.rollback();
                    Matcher aeMatcher = this.pattern.matcher(e.getMessage().trim());
                    if (!aeMatcher.matches()) {
                        throw e;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)e.getMessage());
                }
            }
            LOG.info((Object)("DB schema of DataSource: '" + dsName + "' created succesfully. context " + context));
        }
        catch (SQLException e) {
            LOG.error((Object)("Could not create db schema of DataSource: '" + dsName + "'. Reason: " + e.getMessage() + "; " + JDBCUtils.getFullMessage(e) + ". Last command: " + sql), (Throwable)e);
        }
        finally {
            conn.close();
        }
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof CreateDBSchemaPlugin) {
            CreateDBSchemaPlugin csplugin = (CreateDBSchemaPlugin)plugin;
            try {
                this.createTables(csplugin.getDataSource(), csplugin.getScript());
                this.createDBSchemaPlugins.add(csplugin);
            }
            catch (NamingException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public ComponentPlugin removePlugin(String name) {
        return null;
    }

    public Collection<CreateDBSchemaPlugin> getPlugins() {
        return this.createDBSchemaPlugins;
    }

    public static DBSchemaCreator initialize(String dsName, String script) throws SQLException, NamingException {
        return new DBSchemaCreator(dsName, script);
    }
}

