/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.common.conf.ManagedPlugin;
import org.exoplatform.forum.common.conf.RoleRulesPlugin;
import org.exoplatform.forum.common.user.ContactProvider;
import org.exoplatform.forum.service.DataStorage;
import org.exoplatform.forum.service.impl.ForumServiceImpl;
import org.exoplatform.forum.service.impl.JobManager;
import org.exoplatform.management.ManagementAware;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Managed
@NameTemplate(value={@Property(key="service", value="forum")})
@ManagedDescription(value="Forum management")
public class ForumServiceManaged
implements ManagementAware {
    private static final Log log = ExoLogger.getLogger(ForumServiceManaged.class);
    private ForumServiceImpl forumService;
    private ManagementContext context;

    public ForumServiceManaged(ForumServiceImpl forumService) {
        this.forumService = forumService;
        this.forumService.setManagementView(this);
    }

    public void setContext(ManagementContext context) {
        this.context = context;
    }

    @Managed
    @ManagedDescription(value="list of currently connected users")
    public List<String> getOnlineUsers() throws Exception {
        return this.forumService.getOnlineUsers();
    }

    @Managed
    @ManagedDescription(value="number of currently connected users")
    public int countOnlineUsers() throws Exception {
        return this.getOnlineUsers().size();
    }

    @Managed
    @ManagedDescription(value="rules that define administrators")
    public List<String> getAdminRules() {
        ArrayList<String> adminRules = new ArrayList<String>();
        List<RoleRulesPlugin> plugins = this.forumService.getStorage().getRulesPlugins();
        for (RoleRulesPlugin plugin : plugins) {
            Collection allrules = plugin.getAllRules().values();
            for (List rules : allrules) {
                if (rules == null) continue;
                adminRules.addAll(rules);
            }
        }
        return adminRules;
    }

    @Managed
    @ManagedDescription(value="evaluate is a user has administrator role")
    public boolean hasForumAdminRole(String username) throws Exception {
        return this.forumService.getStorage().isAdminRole(username);
    }

    @Managed
    @ManagedDescription(value="get the configuration of the mail service used for notifications in KS")
    public Map<String, String> getMailServiceConfig() {
        return this.forumService.getStorage().getServerConfig();
    }

    @Managed
    @ManagedDescription(value="Get the ContactProvider implementation")
    public String getContactProvider() {
        return ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ContactProvider.class).toString();
    }

    @Managed
    @ManagedDescription(value="Set the ContactProvider implementation")
    public void setContactProvider(String fqn) {
        Class<?> instance = null;
        try {
            instance = Class.forName(fqn);
        }
        catch (Exception e) {
            log.error((Object)("Failed to register contact provider for " + fqn + ": " + e.getMessage()));
            return;
        }
        String name = PortalContainer.getCurrentPortalContainerName();
        ExoContainerContext.getContainerByName((String)name).registerComponentInstance(ContactProvider.class, instance);
    }

    public void registerPlugin(ManagedPlugin plugin) {
        if (this.context != null) {
            this.context.register((Object)plugin);
        }
    }

    public void registerStorageManager(DataStorage storage) {
        if (this.context != null) {
            this.context.register((Object)storage);
        }
    }

    public void registerJobManager(JobManager jobManager) {
        if (this.context != null) {
            this.context.register((Object)jobManager);
        }
    }
}

