/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.impl.model;

import java.util.List;
import org.exoplatform.forum.service.DataStorage;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.impl.model.AbstractListAccess;
import org.exoplatform.forum.service.impl.model.TopicFilter;

public class TopicListAccess
extends AbstractListAccess<Topic> {
    private TopicFilter filter;
    private DataStorage storage;

    public TopicListAccess(DataStorage storage, TopicFilter filter) {
        this.filter = filter;
        this.storage = storage;
    }

    public Topic[] load(int index, int length) throws Exception, IllegalArgumentException {
        List<Topic> got = this.storage.getTopics(this.filter, index, length);
        this.reCalculate(index, length);
        if (got == null) {
            return new Topic[0];
        }
        return got.toArray(new Topic[got.size()]);
    }

    public int getSize() throws Exception {
        this.size = this.storage.getTopicsCount(this.filter);
        return this.size;
    }

    public Topic[] load(int pageSelect) throws Exception, IllegalArgumentException {
        int offset = this.getOffset(pageSelect);
        int limit = this.getPageSize();
        return this.load(offset, limit);
    }
}

