/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.FetchedData;
import com.google.caja.util.CajaTestCase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import junit.framework.Assert;

public class FetchedDataTest
extends CajaTestCase {
    private URL testUrl;

    public void setUp() throws Exception {
        super.setUp();
        this.testUrl = URI.create("http://www.example.com/").toURL();
    }

    public final void testSimpleContent() throws Exception {
        FetchedData fd = FetchedData.fromConnection(new TestURLConnection(this.testUrl, "abcdef", "text/html"));
        FetchedDataTest.assertEquals((String)"text/html", (String)fd.getContentType());
        FetchedDataTest.assertEquals((String)"abcdef", (String)new String(fd.getByteContent()));
    }

    private void assertCharSet(String expectedCharSet, String urlConnectionContentType) throws Exception {
        String testContent = "abcdef";
        FetchedData fd = FetchedData.fromConnection(new TestURLConnection(this.testUrl, testContent, urlConnectionContentType));
        FetchedDataTest.assertEquals((String)testContent, (String)new String(fd.getByteContent()));
        FetchedDataTest.assertEquals((String)urlConnectionContentType, (String)fd.getContentType());
        FetchedDataTest.assertEquals((String)expectedCharSet, (String)fd.getCharSet());
    }

    public final void testCharSetParsing() throws Exception {
        this.assertCharSet("iso-8859-1", "text/html;charset=iso-8859-1");
        this.assertCharSet("iso-8859-1", "  text/html;  boo=baz;  charset=iso-8859-1  ");
        this.assertCharSet("iso-8859-1", "text/html;boo=\"baz\";charset=\"iso\\-8859\\-1\";bar=\"b\\\"ip\"");
        this.assertCharSet("", "text/html;boo=baz; charset = ;bar=bip");
        this.assertCharSet("", "text/html;boo=baz;charset;bar=bip");
        this.assertCharSet("", "");
        this.assertCharSet("", null);
    }

    private static class TestURLConnection
    extends URLConnection {
        private String data;
        private String contentType;
        private boolean connected;

        public TestURLConnection(URL url, String data, String contentType) {
            super(url);
            this.data = data;
            this.contentType = contentType;
        }

        public void connect() {
            Assert.assertFalse((boolean)this.connected);
            this.connected = true;
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() {
            Assert.assertTrue((boolean)this.connected);
            return new ByteArrayInputStream(this.data.getBytes());
        }
    }
}

