/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.opensocial;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.opensocial.DefaultGadgetRewriter;
import com.google.caja.opensocial.GadgetRewriteException;
import com.google.caja.opensocial.GadgetUriFetcher;
import com.google.caja.plugin.Config;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.reporting.SnippetProducer;
import com.google.caja.util.Maps;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Map;

public class GadgetRewriterMain {
    private Config config;
    private MessageContext mc = new MessageContext();
    private Map<InputSource, CharSequence> originalSources = Maps.newHashMap();

    public GadgetRewriterMain() {
        this.config = new Config(this.getClass(), System.err, "Cajole an OpenSocial gadget spec's Content");
    }

    public static void main(String[] argv) throws GadgetRewriteException, IOException, ParseException {
        GadgetRewriterMain grm = new GadgetRewriterMain();
        if (grm.init(argv)) {
            System.exit(grm.run());
        }
        System.exit(-1);
    }

    public boolean init(String[] argv) {
        return this.config.processArguments(argv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() throws GadgetRewriteException, IOException, ParseException {
        SimpleMessageQueue mq = new SimpleMessageQueue();
        DefaultGadgetRewriter rewriter = new DefaultGadgetRewriter(BuildInfo.getInstance(), mq);
        rewriter.setCssSchema(this.config.getCssSchema(mq));
        rewriter.setHtmlSchema(this.config.getHtmlSchema(mq));
        rewriter.setPreconditions(this.config.preconditions(rewriter.getPreconditions()));
        rewriter.setGoals(this.config.goals(rewriter.getGoals()));
        BufferedWriter w = new BufferedWriter(new FileWriter(this.config.getOutputBase()));
        try {
            GadgetUriFetcher fetcher = new GadgetUriFetcher(this.mc, this.originalSources);
            UriPolicy policy = UriPolicy.IDENTITY;
            URI baseUri = this.config.getBaseUri();
            for (URI input : this.config.getInputUris()) {
                try {
                    CharProducer p = fetcher.fetch(new ExternalReference(input, FilePosition.UNKNOWN), "*/*").getTextualContent();
                    try {
                        rewriter.rewrite(baseUri, p, fetcher, policy, this.config.getGadgetView(), w);
                    }
                    finally {
                        SnippetProducer sp = new SnippetProducer(this.originalSources, this.mc);
                        for (Message msg : mq.getMessages()) {
                            System.err.println(msg.getMessageLevel().name() + ": " + msg.format(this.mc));
                            System.err.println(sp.getSnippet(msg));
                            System.err.println();
                        }
                    }
                }
                catch (UriFetcher.UriFetchException ex) {
                    ex.toMessageQueue(mq);
                }
            }
        }
        finally {
            ((Writer)w).close();
        }
        return 0;
    }

    public Config getConfig() {
        return this.config;
    }
}

