/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.value;

import java.io.IOException;
import java.util.Calendar;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.JCRPathMatcher;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.value.DateValue;
import org.exoplatform.services.jcr.impl.core.value.DoubleValue;
import org.exoplatform.services.jcr.impl.core.value.NameValue;
import org.exoplatform.services.jcr.impl.core.value.PathValue;
import org.exoplatform.services.jcr.impl.core.value.ReferenceValue;
import org.exoplatform.services.jcr.impl.core.value.ValueConstraintsValidator;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ValueConstraintsMatcher
extends ValueConstraintsValidator {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ValueConstraintsMatcher");
    private final LocationFactory locator;
    private final ItemDataConsumer itemDataConsumer;
    private final NodeTypeDataManager nodeTypeDataManager;

    public ValueConstraintsMatcher(String[] constraints, LocationFactory locator, ItemDataConsumer itemDataConsumer, NodeTypeDataManager nodeTypeDataManager) {
        super(constraints);
        this.locator = locator;
        this.itemDataConsumer = itemDataConsumer;
        this.nodeTypeDataManager = nodeTypeDataManager;
    }

    public boolean match(ValueData value, int type) throws RepositoryException {
        boolean invalid;
        block55: {
            ValueData valueData;
            block61: {
                Double valueNumber;
                block60: {
                    Calendar valueCalendar;
                    block59: {
                        block58: {
                            block57: {
                                PathValue pathVal;
                                block56: {
                                    NameValue nameVal;
                                    block54: {
                                        if (this.constraints == null || this.constraints.length <= 0) {
                                            return true;
                                        }
                                        invalid = true;
                                        valueData = value;
                                        if (type != 1) break block54;
                                        String strVal = ValueDataUtil.getString(valueData);
                                        for (int i = 0; invalid && i < this.constraints.length; ++i) {
                                            String constrString = this.constraints[i];
                                            if (!strVal.matches(constrString)) continue;
                                            invalid = false;
                                        }
                                        break block55;
                                    }
                                    if (type != 7) break block56;
                                    try {
                                        nameVal = new NameValue(valueData, this.locator);
                                    }
                                    catch (IOException e) {
                                        throw new RepositoryException((Throwable)e);
                                    }
                                    for (int i = 0; invalid && i < this.constraints.length; ++i) {
                                        String constrString = this.constraints[i];
                                        InternalQName constrName = this.locator.parseJCRName(constrString).getInternalName();
                                        if (!nameVal.getQName().equals((Object)constrName)) continue;
                                        invalid = false;
                                    }
                                    break block55;
                                }
                                if (type != 8) break block57;
                                try {
                                    pathVal = new PathValue(valueData, this.locator);
                                }
                                catch (IOException e) {
                                    throw new RepositoryException((Throwable)e);
                                }
                                for (int i = 0; invalid && i < this.constraints.length; ++i) {
                                    JCRPathMatcher constrPath = this.parsePathMatcher(this.locator, this.constraints[i]);
                                    if (!constrPath.match(pathVal.getQPath())) continue;
                                    invalid = false;
                                }
                                break block55;
                            }
                            if (type != 9) break block58;
                            try {
                                ReferenceValue refVal = new ReferenceValue(valueData);
                                NodeData refNode = (NodeData)this.itemDataConsumer.getItemData(refVal.getIdentifier().getString());
                                for (int i = 0; invalid && i < this.constraints.length; ++i) {
                                    String constrString = this.constraints[i];
                                    InternalQName constrName = this.locator.parseJCRName(constrString).getInternalName();
                                    if (!this.nodeTypeDataManager.isNodeType(constrName, refNode.getPrimaryTypeName(), refNode.getMixinTypeNames())) continue;
                                    invalid = false;
                                }
                            }
                            catch (ItemNotFoundException e) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Reference constraint node is not found: " + e.getMessage()));
                                }
                                invalid = false;
                            }
                            catch (RepositoryException e) {
                                LOG.error((Object)("Reference constraint error: " + e.getMessage()), (Throwable)e);
                                invalid = true;
                            }
                            catch (IOException e) {
                                LOG.error((Object)("Reference constraint error: " + e.getMessage()), (Throwable)e);
                                invalid = true;
                            }
                            break block55;
                        }
                        if (type != 2) break block59;
                        long valueLength = valueData.getLength();
                        for (int i = 0; invalid && i < this.constraints.length; ++i) {
                            long max;
                            long min;
                            String constrString = this.constraints[i];
                            boolean minInvalid = true;
                            boolean maxInvalid = true;
                            ValueConstraintsValidator.MinMaxConstraint constraint = this.parseAsMinMax(constrString);
                            long l = min = constraint.getMin().getThreshold().length() > 0 ? new Long(constraint.getMin().getThreshold()) : Long.MIN_VALUE;
                            if (constraint.getMin().isExclusive()) {
                                if (valueLength > min) {
                                    minInvalid = false;
                                }
                            } else if (valueLength >= min) {
                                minInvalid = false;
                            }
                            long l2 = max = constraint.getMax().getThreshold().length() > 0 ? new Long(constraint.getMax().getThreshold()) : Long.MAX_VALUE;
                            if (constraint.getMax().isExclusive()) {
                                if (valueLength < max) {
                                    maxInvalid = false;
                                }
                            } else if (valueLength <= max) {
                                maxInvalid = false;
                            }
                            invalid = maxInvalid | minInvalid;
                        }
                        break block55;
                    }
                    if (type != 5) break block60;
                    try {
                        valueCalendar = new DateValue(valueData).getDate();
                    }
                    catch (IOException e) {
                        throw new RepositoryException((Throwable)e);
                    }
                    for (int i = 0; invalid && i < this.constraints.length; ++i) {
                        boolean minInvalid = true;
                        boolean maxInvalid = true;
                        ValueConstraintsValidator.MinMaxConstraint constraint = this.parseAsMinMax(this.constraints[i]);
                        try {
                            if (constraint.getMin().getThreshold().length() > 0) {
                                Calendar min = JCRDateFormat.parse(constraint.getMin().getThreshold());
                                if (constraint.getMin().isExclusive()) {
                                    if (valueCalendar.compareTo(min) > 0) {
                                        minInvalid = false;
                                    }
                                } else if (valueCalendar.compareTo(min) >= 0) {
                                    minInvalid = false;
                                }
                            } else {
                                minInvalid = false;
                            }
                        }
                        catch (ValueFormatException e) {
                            minInvalid = false;
                        }
                        try {
                            if (constraint.getMax().getThreshold().length() > 0) {
                                Calendar max = JCRDateFormat.parse(constraint.getMax().getThreshold());
                                if (constraint.getMax().isExclusive()) {
                                    if (valueCalendar.compareTo(max) < 0) {
                                        maxInvalid = false;
                                    }
                                } else if (valueCalendar.compareTo(max) <= 0) {
                                    maxInvalid = false;
                                }
                            } else {
                                maxInvalid = false;
                            }
                        }
                        catch (ValueFormatException e) {
                            maxInvalid = false;
                        }
                        invalid = maxInvalid | minInvalid;
                    }
                    break block55;
                }
                if (type != 3 && type != 4) break block61;
                try {
                    valueNumber = new DoubleValue(valueData).getDouble();
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
                for (int i = 0; invalid && i < this.constraints.length; ++i) {
                    boolean minInvalid = true;
                    boolean maxInvalid = true;
                    ValueConstraintsValidator.MinMaxConstraint constraint = this.parseAsMinMax(this.constraints[i]);
                    Double min = constraint.getMin().getThreshold().length() > 0 ? new Double(constraint.getMin().getThreshold()) : Double.MIN_VALUE;
                    if (constraint.getMin().isExclusive()) {
                        if (valueNumber > min) {
                            minInvalid = false;
                        }
                    } else if (valueNumber >= min) {
                        minInvalid = false;
                    }
                    Double max = constraint.getMax().getThreshold().length() > 0 ? new Double(constraint.getMax().getThreshold()) : Double.MAX_VALUE;
                    if (constraint.getMax().isExclusive()) {
                        if (valueNumber < max) {
                            maxInvalid = false;
                        }
                    } else if (valueNumber <= max) {
                        maxInvalid = false;
                    }
                    invalid = maxInvalid | minInvalid;
                }
                break block55;
            }
            if (type != 6) break block55;
            boolean bvalue = ValueDataUtil.getBoolean(valueData);
            for (int i = 0; invalid && i < this.constraints.length; ++i) {
                if (Boolean.parseBoolean(this.constraints[i]) != bvalue) continue;
                invalid = false;
            }
        }
        return !invalid;
    }

    protected JCRPath parsePath(String path, LocationFactory locFactory) throws RepositoryException {
        try {
            return locFactory.parseAbsPath(path);
        }
        catch (RepositoryException e) {
            try {
                return locFactory.parseRelPath(path);
            }
            catch (RepositoryException e1) {
                throw e;
            }
        }
    }

    protected JCRPathMatcher parsePathMatcher(LocationFactory locFactory, String path) throws RepositoryException {
        JCRPath knownPath = null;
        boolean forDescendants = false;
        boolean forAncestors = false;
        if (path.equals("*") || path.equals(".*")) {
            forDescendants = true;
            forAncestors = true;
        } else if (path.endsWith("*") && path.startsWith("*")) {
            forDescendants = true;
            forAncestors = true;
            knownPath = this.parsePath(path.substring(1, path.length() - 1), locFactory);
        } else if (path.endsWith("*")) {
            forDescendants = true;
            knownPath = this.parsePath(path.substring(0, path.length() - 1), locFactory);
        } else if (path.startsWith("*")) {
            forAncestors = true;
            knownPath = this.parsePath(path.substring(1), locFactory);
        } else {
            knownPath = this.parsePath(path, locFactory);
        }
        return new JCRPathMatcher(knownPath == null ? null : knownPath.getInternalPath(), forDescendants, forAncestors);
    }
}

