/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity.listener;

import javax.jcr.Node;
import org.exoplatform.commons.utils.ActivityTypeUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;

public class CommentAddedActivityListener
extends Listener<Node, Node> {
    public void onEvent(Event<Node, Node> event) throws Exception {
        Node currentNode = (Node)event.getSource();
        Node commentNode = (Node)event.getData();
        String commentContent = "";
        if (commentNode.hasProperty("exo:commentContent")) {
            try {
                commentContent = commentNode.getProperty("exo:commentContent").getValue().getString();
            }
            catch (Exception e) {
                commentContent = null;
            }
        }
        if (commentContent == null) {
            return;
        }
        ExoSocialActivity commentActivity = Utils.postActivity(currentNode, "{0}", false, true, commentContent);
        if (commentActivity != null) {
            ActivityTypeUtils.attachActivityId((Node)commentNode, (String)commentActivity.getId());
            commentNode.getSession().save();
        }
    }
}

