/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Value;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.forum.common.UserHelper;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.ForumNodeTypes;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.filter.model.CategoryFilter;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.User;

public class Utils
implements ForumNodeTypes {
    private static final Log LOG = ExoLogger.getLogger(Utils.class);
    public static final String TYPE_CATEGORY = "exo:forumCategory".intern();
    public static final String TYPE_FORUM = "exo:forum".intern();
    public static final String TYPE_TOPIC = "exo:topic".intern();
    public static final String USER_PROFILES_TYPE = "exo:forumUserProfile".intern();
    public static final String FORUM_SERVICE = "ForumService".intern();
    public static final String USER_PROFILES = "UserProfile".intern();
    public static final String FORUM_SUBSCRIOTION = "forumSubscription".intern();
    public static final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    public static final String FORUMADMINISTRATION = "forumAdministration".intern();
    public static final String USER_PROFILE_DELETED = "userProfileDeleted".intern();
    public static final String CATEGORY = "forumCategory".intern();
    public static final String FORUM = "forum".intern();
    public static final String TOPIC = "topic".intern();
    public static final String POST = "post".intern();
    public static final String ATTACHMENT = "attachment";
    public static final String POLL = "poll".intern();
    public static final String TAG = "tag".intern();
    public static final String TOPICTYPE = "topicType".intern();
    public static final String PRUNESETTING = "pruneSetting".intern();
    public static final String RECEIVE_MESSAGE = "receive".intern();
    public static final String SEND_MESSAGE = "send".intern();
    public static final String ADMIN = "Administrator".intern();
    public static final String MODERATOR = "Moderator".intern();
    public static final String USER = "User".intern();
    public static final String GUEST = "Guest".intern();
    public static final String DELETED = "_deleted".intern();
    public static final String CACHE_REPO_NAME = "repositoryName".intern();
    public static final String DEFAULT_TENANT_NAME = Long.toHexString(System.currentTimeMillis() + (long)System.identityHashCode("currentTenant"));
    public static final int CLOSE = 1;
    public static final int LOCK = 2;
    public static final int APPROVE = 3;
    public static final int STICKY = 4;
    public static final int WAITING = 5;
    public static final int ACTIVE = 6;
    public static final int CHANGE_NAME = 7;
    public static final int VOTE_RATING = 8;
    public static final int HIDDEN = 9;
    public static final String SPACE = " ".intern();
    public static final String FORUM_SPACE_ID_PREFIX = (FORUM + "Space").intern();
    public static final String CATEGORY_SPACE = "spaces";
    public static final String CATEGORY_SPACE_ID_PREFIX = (CATEGORY + "spaces").intern();
    public static final String ADMIN_ROLE = "ADMIN".intern();
    public static final String DEFAULT_EMAIL_CONTENT = "Hi,</br> You receive this email because you registered for eXo Forum and Topic Watching notification.<br/>We would like to inform you that there is a new $ADD_TYPE in the $OBJECT_WATCH_TYPE <strong>$OBJECT_NAME</strong> with the following content: <div>_______________<br/>$POST_CONTENT<br/>_______________</div><div>At $TIME on $DATE, posted by <strong>$POSTER</strong> .</div><div>Go directly to the post: <a target=\"_blank\" href=\"$VIEWPOST_LINK\">Click here.</a> <br/>Or go to reply to the post: <a target=\"_blank\" href=\"$REPLYPOST_LINK\">Click here." + "</a></div>".intern();

    public static String removeCharterStrange(String s) {
        if (s == null || s.length() <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (s.codePointAt(i) <= 31) continue;
            builder.append(s.charAt(i));
        }
        return builder.toString();
    }

    public static boolean arraysHaveDifferentContent(String[] a, String[] b) {
        if (a.length == b.length) {
            List<String> list = Arrays.asList(b);
            for (int i = 0; i < a.length; ++i) {
                if (list.contains(a[i])) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public static boolean listsHaveDifferentContent(List<String> a, List<String> b) {
        if (a.size() == b.size()) {
            for (String s : b) {
                if (a.contains(s)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public static String[] mapToArray(Map<String, String> map) {
        if (map.isEmpty()) {
            return new String[]{" "};
        }
        String str = map.toString().replace(" ", "").replace("{", "").replace("}", "");
        str = str.replace(",", ";").replace("=", ",");
        return str.split(";");
    }

    public static Map<String, String> arrayToMap(String[] strs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < strs.length; ++i) {
            String[] arr = strs[i].split(",");
            if (arr.length != 2) continue;
            map.put(arr[0], arr[1]);
        }
        return map;
    }

    public static String propertyMatchAny(String property, List<String> list) {
        StringBuilder builder = new StringBuilder();
        if (!list.isEmpty()) {
            boolean t = false;
            for (String string : list) {
                if (!t) {
                    builder.append("(not(").append(property).append(") or ").append(property).append("='' or ").append(property).append("='").append(string).append("'");
                } else {
                    builder.append(" or ").append(property).append("='").append(string).append("'");
                }
                t = true;
            }
            if (t) {
                builder.append(")");
            }
        }
        return builder.toString();
    }

    public static boolean isListContentItemList(List<String> list, List<String> list1) {
        if (list1 == null || list1.size() == 1 && Utils.isEmpty(list1.get(0))) {
            return false;
        }
        for (String string : list1) {
            if (!list.contains(string)) continue;
            return true;
        }
        return false;
    }

    public static String[] getStringsInList(List<String> list) {
        if (list.size() > 1) {
            while (list.contains(" ")) {
                list.remove(" ");
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static List<String> extractSameItems(List<String> pList, List<String> cList) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : pList) {
            if (!cList.contains(string)) continue;
            list.add(string);
        }
        return list;
    }

    public static String[] valuesToArray(Value[] Val) throws Exception {
        if (Val.length < 1) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < Val.length; ++i) {
            String s = Val[i].getString();
            if (Utils.isEmpty(s)) continue;
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    public static List<String> valuesToList(Value[] values) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (values.length < 1) {
            return list;
        }
        for (int i = 0; i < values.length; ++i) {
            String s = values[i].getString();
            if (Utils.isEmpty(s)) continue;
            list.add(s);
        }
        return list;
    }

    public static <T> T[] arrayCopy(T[] source) {
        if (source == null) {
            return null;
        }
        if (source.length == 0) {
            try {
                return (Object[])Array.newInstance(source.getClass().getComponentType(), 0);
            }
            catch (Exception e) {
                return null;
            }
        }
        Object[] dest = (Object[])Array.newInstance(source[0].getClass(), source.length);
        System.arraycopy(source, 0, dest, 0, source.length);
        return dest;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() <= 0;
    }

    public static boolean isEmpty(String[] array) {
        if (array != null && array.length > 0) {
            for (String s : array) {
                if (s == null || s.trim().length() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public static String getQueryByProperty(String typeAdd, String property, String value) {
        StringBuilder strBuilder = new StringBuilder();
        if (!Utils.isEmpty(value) && !Utils.isEmpty(property)) {
            if (!Utils.isEmpty(typeAdd)) {
                strBuilder.append(SPACE).append(typeAdd).append(SPACE);
            }
            strBuilder.append("(@").append(property).append("='").append(value).append("')");
        }
        return strBuilder.toString();
    }

    public static String getSQLQueryByProperty(String typeAdd, String property, String value) {
        StringBuilder strBuilder = new StringBuilder();
        if (!Utils.isEmpty(value) && !Utils.isEmpty(property)) {
            if (!Utils.isEmpty(typeAdd)) {
                strBuilder.append(SPACE).append(typeAdd).append(SPACE);
            }
            strBuilder.append("(").append(property).append("='").append(value).append("')");
        }
        return strBuilder.toString();
    }

    public static StringBuilder getPathQuery(String isApproved, String isHidden, String isWaiting, String userLogin) throws Exception {
        StringBuilder strBuilder = new StringBuilder();
        String typeAdd = null;
        String str = Utils.getQueryByProperty(typeAdd, "exo:userPrivate", userLogin);
        if (!Utils.isEmpty(str)) {
            strBuilder.append("(").append(str);
            typeAdd = "or";
        }
        if ("or".equals(typeAdd)) {
            strBuilder.append(Utils.getQueryByProperty(typeAdd, "exo:userPrivate", "exoUserPri")).append(")");
            typeAdd = "and";
        }
        if (!Utils.isEmpty(str = Utils.getQueryByProperty(typeAdd, "exo:isApproved", isApproved))) {
            strBuilder.append(str);
            typeAdd = "and";
        }
        if (!Utils.isEmpty(str = Utils.getQueryByProperty(typeAdd, "exo:isHidden", isHidden))) {
            strBuilder.append(str);
            typeAdd = "and";
        }
        if (!Utils.isEmpty(str = Utils.getQueryByProperty(typeAdd, "exo:isWaiting", isWaiting))) {
            strBuilder.append(str);
        }
        if (strBuilder.length() > 0) {
            return new StringBuilder("[").append((CharSequence)strBuilder).append("]");
        }
        return new StringBuilder();
    }

    public static StringBuilder getSQLQuery(String isApproved, String isHidden, String isWaiting, String userLogin) throws Exception {
        StringBuilder strBuilder = new StringBuilder();
        String typeAdd = null;
        String str = Utils.getSQLQueryByProperty(typeAdd, "exo:userPrivate", userLogin);
        if (!Utils.isEmpty(str)) {
            strBuilder.append("(").append(str);
            typeAdd = "or";
        }
        if ("or".equals(typeAdd)) {
            strBuilder.append(Utils.getSQLQueryByProperty(typeAdd, "exo:userPrivate", "exoUserPri")).append(")");
            typeAdd = "and";
        }
        if (!Utils.isEmpty(str = Utils.getSQLQueryByProperty(typeAdd, "exo:isApproved", isApproved))) {
            strBuilder.append(str);
            typeAdd = "and";
        }
        if (!Utils.isEmpty(str = Utils.getSQLQueryByProperty(typeAdd, "exo:isHidden", isHidden))) {
            strBuilder.append(str);
            typeAdd = "and";
        }
        if (!Utils.isEmpty(str = Utils.getSQLQueryByProperty(typeAdd, "exo:isWaiting", isWaiting))) {
            strBuilder.append(str);
        }
        return strBuilder;
    }

    public static String buildXpathHasProperty(String property) {
        StringBuilder builder = new StringBuilder();
        if (!Utils.isEmpty(property)) {
            builder.append("(not(@").append(property).append(") or @").append(property).append("='' or @").append(property).append("=' ')");
        }
        return builder.toString();
    }

    public static String buildSQLHasProperty(String property) {
        StringBuilder builder = new StringBuilder();
        if (!Utils.isEmpty(property)) {
            builder.append(property).append("='' or ").append(property).append("=' ' or ").append(property).append(" IS NULL");
        }
        return builder.toString();
    }

    public static String buildXpathByUserInfo(String property, List<String> groupAndMembershipInfos) {
        StringBuilder query = new StringBuilder();
        for (String str : groupAndMembershipInfos) {
            if (query.length() > 0) {
                query.append(" or ");
            }
            query.append("@").append(property).append(" = '").append(str).append("'");
            if (ForumServiceUtils.isGroupExpression(str)) {
                query.append(" or @").append(property).append(" = '*:").append(str).append("'");
                continue;
            }
            if (!ForumServiceUtils.isMembershipExpression(str)) continue;
            str = str.substring(str.indexOf(":") + 1);
            query.append(" or @").append(property).append(" = '*:").append(str).append("'");
        }
        return query.toString();
    }

    public static String buildSQLByUserInfo(String property, List<String> groupAndMembershipInfos) {
        StringBuilder query = new StringBuilder();
        for (String str : groupAndMembershipInfos) {
            if (query.length() > 0) {
                query.append(" or ");
            }
            query.append("").append(property).append(" = '").append(str).append("'");
            if (ForumServiceUtils.isGroupExpression(str)) {
                query.append(" or ").append(property).append(" = '*:").append(str).append("'");
                continue;
            }
            if (!ForumServiceUtils.isMembershipExpression(str)) continue;
            str = str.substring(str.indexOf(":") + 1);
            query.append(" or ").append(property).append(" = '*:").append(str).append("'");
        }
        return query.toString();
    }

    public static List<String> getGroupSpaceOfUser(String userId) {
        ArrayList<String> groupId = new ArrayList<String>();
        try {
            Collection groups = UserHelper.getOrganizationService().getGroupHandler().findGroupsOfUser(userId);
            for (Group group : groups) {
                if (group.getId().indexOf("/spaces") < 0) continue;
                groupId.add(group.getGroupName());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"The method findGroupsOfUser() cannot access the database.");
        }
        return groupId;
    }

    public static String buildQueryForumInSpaceOfUser(String userId, List<String> groupIds) {
        if (!Utils.isEmpty(userId) && groupIds.size() > 0) {
            StringBuilder queryForum = new StringBuilder("(");
            for (String groupId : groupIds) {
                if (queryForum.length() > 10) {
                    queryForum.append(" or ");
                }
                queryForum.append("(@").append("exo:id").append("='").append(FORUM_SPACE_ID_PREFIX).append(groupId).append("')");
            }
            queryForum.append(")");
            return queryForum.toString();
        }
        return "";
    }

    public static boolean hasPermission(List<String> listOfCanviewrs, List<String> listOfBoundUsers) {
        if (listOfBoundUsers == null || listOfCanviewrs == null) {
            return false;
        }
        ArrayList<String> groups = new ArrayList<String>();
        ArrayList<String> groupsAllmembershipType = new ArrayList<String>();
        for (String str : listOfBoundUsers) {
            if (str.indexOf("/") >= 0) {
                groups.add(str.substring(str.indexOf("/")));
            }
            if (str.indexOf("*") >= 0) {
                str = str.substring(str.indexOf("/"));
                groupsAllmembershipType.add(str);
            }
            if (!listOfCanviewrs.contains(str)) continue;
            return true;
        }
        if (groups.size() > 0 || groupsAllmembershipType.size() > 0) {
            for (String str : listOfCanviewrs) {
                if (str.indexOf("*") >= 0 && groups.contains(str = str.substring(str.indexOf("/")))) {
                    return true;
                }
                if (str.indexOf(":") > 0) {
                    str = str.substring(str.indexOf("/"));
                }
                if (!groupsAllmembershipType.contains(str)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getCurrentTenantName() {
        try {
            RepositoryService repositoryService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
            if (repositoryService == null) {
                repositoryService = (RepositoryService)RootContainer.getInstance().getPortalContainer(PortalContainer.getCurrentPortalContainerName()).getComponentInstanceOfType(RepositoryService.class);
            }
            return repositoryService.getCurrentRepository().getConfiguration().getName();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Can not get current repository", new Object[]{e.getMessage()});
            }
            return DEFAULT_TENANT_NAME;
        }
    }

    public static List<String> getOnlineUserByTenantName(Map<String, List<String>> onlineUserMap) {
        ArrayList<String> onlinUsers = new ArrayList<String>();
        String currentTenant = Utils.getCurrentTenantName();
        if (onlineUserMap != null && onlineUserMap.get(currentTenant) != null) {
            onlinUsers.addAll((Collection<String>)onlineUserMap.get(currentTenant));
        }
        return onlinUsers;
    }

    public static String getCategoryId(String path) {
        if (!Utils.isEmpty(path) && path.lastIndexOf(CATEGORY) != -1) {
            String category = path.substring(path.lastIndexOf(CATEGORY));
            if (category.indexOf("/") != -1) {
                category = category.substring(0, category.indexOf("/"));
            }
            return category;
        }
        return null;
    }

    public static String getCategoryPath(String path) {
        if (!Utils.isEmpty(path) && path.lastIndexOf(CATEGORY) != -1) {
            return path.substring(0, path.lastIndexOf(CATEGORY) + Utils.getCategoryId(path).length());
        }
        return null;
    }

    public static String getForumId(String path) {
        if (!Utils.isEmpty(path) && path.lastIndexOf(FORUM) != -1) {
            String forumId = path.substring(path.lastIndexOf(FORUM));
            if (forumId.indexOf("/") != -1) {
                forumId = forumId.substring(0, forumId.indexOf("/"));
            }
            return forumId;
        }
        return null;
    }

    public static String getForumPath(String path) {
        if (!Utils.isEmpty(path) && path.lastIndexOf(FORUM) != -1) {
            return path.substring(0, path.lastIndexOf(FORUM) + Utils.getForumId(path).length());
        }
        return null;
    }

    public static String getTopicId(String path) {
        if (!Utils.isEmpty(path) && path.lastIndexOf(TOPIC) != -1) {
            String topicId = path.substring(path.lastIndexOf(TOPIC));
            if (topicId.indexOf("/") != -1) {
                topicId = topicId.substring(0, topicId.indexOf("/"));
            }
            return topicId;
        }
        return null;
    }

    public static String getTopicPath(String path) {
        if (!Utils.isEmpty(path) && path.lastIndexOf(TOPIC) != -1) {
            return path.substring(0, path.lastIndexOf(TOPIC) + Utils.getTopicId(path).length());
        }
        return null;
    }

    public static String getSubPath(String path) {
        String forumHome = "CategoryHome";
        if (!Utils.isEmpty(path) && path.indexOf(forumHome) >= 0) {
            int index = path.indexOf(forumHome) + forumHome.length() + 1;
            return path.substring(index);
        }
        return path;
    }

    public static class CategoryNameComparator
    implements Comparator<Object> {
        private DIRECTION type = DIRECTION.ASC;

        public CategoryNameComparator() {
        }

        public CategoryNameComparator(DIRECTION type) {
            this.type = type;
        }

        @Override
        public int compare(Object o1, Object o2) throws ClassCastException {
            String name1 = "";
            String name2 = "";
            if (o1 instanceof CategoryFilter) {
                name1 = ((CategoryFilter)o1).getCategoryName().toUpperCase();
                name2 = ((CategoryFilter)o2).getCategoryName().toUpperCase();
            } else {
                name1 = ((Category)o1).getCategoryName().toUpperCase();
                name2 = ((Category)o2).getCategoryName().toUpperCase();
            }
            return this.type == DIRECTION.ASC ? name1.compareTo(name2) : name2.compareTo(name1);
        }

        public static enum DIRECTION {
            DESC,
            ASC;

        }
    }

    public static class DatetimeComparatorPostDESC
    implements Comparator<Post> {
        @Override
        public int compare(Post o1, Post o2) throws ClassCastException {
            Date date1 = o2.getCreatedDate();
            Date date2 = o1.getCreatedDate();
            return date2.compareTo(date1);
        }
    }

    public static class DatetimeComparatorDESC
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) throws ClassCastException {
            Date date1 = ((User)o1).getCreatedDate();
            Date date2 = ((User)o2).getCreatedDate();
            return date2.compareTo(date1);
        }
    }
}

