/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.operations.page;

import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.management.operations.page.AbstractPageOperationHandler;
import org.exoplatform.portal.mop.management.operations.page.PageUtils;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.gatein.management.api.exceptions.OperationException;
import org.gatein.management.api.exceptions.ResourceNotFoundException;
import org.gatein.management.api.operation.OperationContext;
import org.gatein.management.api.operation.ResultHandler;

public class PageReadConfigAsXml
extends AbstractPageOperationHandler {
    @Override
    protected void execute(OperationContext operationContext, ResultHandler resultHandler, org.gatein.mop.api.workspace.Page rootPage) throws ResourceNotFoundException, OperationException {
        String operationName = operationContext.getOperationName();
        SiteKey siteKey = this.getSiteKey(rootPage.getSite());
        DataStorage dataStorage = (DataStorage)operationContext.getRuntimeContext().getRuntimeComponent(DataStorage.class);
        PageService pageService = (PageService)operationContext.getRuntimeContext().getRuntimeComponent(PageService.class);
        String pageName = operationContext.getAddress().resolvePathTemplate("page-name");
        if (pageName == null) {
            try {
                resultHandler.completed((Object)PageUtils.getAllPages(dataStorage, pageService, siteKey));
            }
            catch (Exception e) {
                throw new OperationException(operationName, "Could not retrieve pages for site " + siteKey);
            }
        }
        PageKey key = new PageKey(siteKey, pageName);
        try {
            Page page = PageUtils.getPage(dataStorage, pageService, key);
            if (page == null) {
                throw new ResourceNotFoundException("No page found for " + key);
            }
            resultHandler.completed((Object)page);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OperationException(operationName, "Operation failed getting page for " + key, (Throwable)e);
        }
    }
}

