/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.ext.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.SpaceStorageException;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wiki/social-integration/plugin/space/WikiUIActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class})})
public class WikiUIActivity
extends BaseUIActivity {
    private static final Log LOG = ExoLogger.getLogger(WikiUIActivity.class);
    public static final String COMMENT_MESSAGE_KEY = "commentMessageKey";
    public static final String COMMENT_MESSAGE_KEY1 = "commentMessageKey1";
    public static final String COMMENT_MESSAGE_KEY2 = "commentMessageKey2";
    public static final String COMMENT_MESSAGE_ARGS = "messageArgs";
    public static final String COMMENT_MESSAGE_ARGS1 = "messageArgs1";
    public static final String COMMENT_MESSAGE_ARGS2 = "messageArgs2";
    public static final String COMMENT_MESSAGE_ARGS_ELEMENT_SAPERATOR = "\n";
    public static final String COMMENT_TYPE = "commentType";

    public String getUriOfAuthor() {
        if (this.getOwnerIdentity() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to get Url of user, author isn't set");
            }
            return "";
        }
        return "<a href='" + this.getOwnerIdentity().getProfile().getUrl() + "'>" + this.getOwnerIdentity().getProfile().getFullName() + "</a>";
    }

    public String getUserFullName(String userId) {
        return this.getOwnerIdentity().getProfile().getFullName();
    }

    public String getUserProfileUri(String userId) {
        return this.getOwnerIdentity().getProfile().getUrl();
    }

    public String getUserAvatarImageSource(String userId) {
        return this.getOwnerIdentity().getProfile().getAvatarUrl();
    }

    public String getSpaceAvatarImageSource(String spaceIdentityId) {
        try {
            if (this.getOwnerIdentity() == null) {
                LOG.error((Object)"Failed to get Space Avatar Source, unknow owner identity.");
                return null;
            }
            String spaceId = this.getOwnerIdentity().getRemoteId();
            SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
            Space space = spaceService.getSpaceById(spaceId);
            if (space != null) {
                return space.getAvatarUrl();
            }
        }
        catch (SpaceStorageException e) {
            LOG.error((Object)String.format("Failed to getSpaceById: %s. \n Cause by: ", spaceIdentityId), (Throwable)e);
        }
        return null;
    }

    public String getActivityParamValue(String key) {
        String value = null;
        Map params = this.getActivity().getTemplateParams();
        if (params != null) {
            value = (String)params.get(key);
        }
        return value != null ? value : "";
    }

    String getActivityMessage(WebuiBindingContext _ctx) throws Exception {
        return _ctx.appRes("WikiUIActivity.label.page-create");
    }

    String getPageName() {
        return this.getActivityParamValue("page_name");
    }

    String getPageURL() {
        String pageUrl = this.getActivityParamValue("page_url");
        if (pageUrl != null) {
            try {
                URL oldURL = new URL(pageUrl);
                pageUrl = oldURL.getPath();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return pageUrl;
    }

    String getViewChangeURL() {
        return this.getActivityParamValue("view_change_url");
    }

    String getVerName() {
        char c;
        String url = this.getViewChangeURL();
        StringBuilder sb = new StringBuilder();
        for (int i = url.length() - 1; i >= 0 && Character.isDigit(c = url.charAt(i)); --i) {
            sb.insert(0, c);
        }
        return sb.toString();
    }

    String getPageExcerpt() {
        return this.getActivityParamValue("page_exceprt");
    }

    String getPageVersion() {
        String version = this.getActivityParamValue("version");
        if (StringUtils.isEmpty((String)version)) {
            version = "1";
            String pageUrl = this.getPageURL();
            if (pageUrl == null) {
                return version;
            }
        }
        return version;
    }

    private String[] getActivityCommentBundleArguments(Map<String, String> activityParams, String paramKey) {
        String commentMessageArgs;
        if (activityParams != null && StringUtils.isNotEmpty((String)(commentMessageArgs = activityParams.get(paramKey)))) {
            String[] args = commentMessageArgs.split(COMMENT_MESSAGE_ARGS_ELEMENT_SAPERATOR);
            return args;
        }
        return null;
    }

    private String formatMessage(String msgKey, Object[] args) {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        String message = "";
        try {
            message = res.getString(msgKey);
        }
        catch (MissingResourceException e) {
            message = msgKey;
        }
        return MessageFormat.format(message.replace("'", "''"), args);
    }

    private String getSystemCommentMessage(String messageKeyParam, String messageArgumentsParam, Map<String, String> activityParams) {
        String msgKey = activityParams.get(messageKeyParam);
        Object[] args = this.getActivityCommentBundleArguments(activityParams, messageArgumentsParam);
        return this.formatMessage(msgKey, args);
    }

    public String getSystemCommentMessage(Map<String, String> activityParams, String title) {
        CommentType commentType = CommentType.USER;
        if (activityParams != null && activityParams.containsKey(COMMENT_TYPE)) {
            commentType = CommentType.valueOf(activityParams.get(COMMENT_TYPE));
        }
        String commentMessage = "";
        switch (commentType) {
            case USER: {
                commentMessage = title;
                break;
            }
            case SYSTEM: {
                commentMessage = this.getSystemCommentMessage(COMMENT_MESSAGE_KEY, COMMENT_MESSAGE_ARGS, activityParams);
                break;
            }
            case SYSTEM_GROUP: {
                String commentMessage1 = this.getSystemCommentMessage(COMMENT_MESSAGE_KEY1, COMMENT_MESSAGE_ARGS1, activityParams);
                String commentMessage2 = this.getSystemCommentMessage(COMMENT_MESSAGE_KEY2, COMMENT_MESSAGE_ARGS2, activityParams);
                commentMessage = commentMessage1.concat("<br>").concat(commentMessage2);
            }
        }
        return commentMessage;
    }

    String getWikiActivityType() {
        return this.getActivityParamValue("act_key");
    }

    public static enum CommentType {
        USER,
        SYSTEM,
        SYSTEM_GROUP;

    }
}

