/*
 * Decompiled with CFR 0.152.
 */
package org.josso.agent.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.josso.agent.AbstractSSOAgent;
import org.josso.agent.Lookup;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.SSOPartnerAppConfig;
import org.josso.agent.http.AbstractAutomaticLoginStrategy;
import org.josso.agent.http.AutomaticLoginStrategy;
import org.josso.agent.http.DefaultAutomaticLoginStrategy;
import org.josso.agent.http.FrontChannelParametersBuilder;
import org.josso.agent.http.HttpSSOAgentRequest;
import org.josso.auth.util.CipherUtil;
import org.josso.gateway.SSONameValuePair;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.SSOIdentityManagerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpSSOAgent
extends AbstractSSOAgent {
    private static final String JOSSO_LOGIN_URI = "/josso_login/";
    private static final String JOSSO_USER_LOGIN_URI = "/josso_user_login/";
    private static final String JOSSO_SECURITY_CHECK_URI = "/josso_security_check";
    private static final String JOSSO_LOGOUT_URI = "/josso_logout/";
    private static final String JOSSO_AUTHENTICATION_URI = "/josso_authentication/";
    private List<FrontChannelParametersBuilder> _builders = new ArrayList<FrontChannelParametersBuilder>();
    private List<AutomaticLoginStrategy> _automaticStrategies = new ArrayList<AutomaticLoginStrategy>();

    @Override
    public void start() {
        super.start();
        if (this._automaticStrategies.isEmpty()) {
            this._automaticStrategies.add(new DefaultAutomaticLoginStrategy("SUFFICIENT"));
        }
        for (AutomaticLoginStrategy as : this._automaticStrategies) {
            if (!(as instanceof AbstractAutomaticLoginStrategy)) continue;
            ((AbstractAutomaticLoginStrategy)as).setAgent(this);
        }
    }

    @Override
    protected boolean isAuthenticationAlwaysRequired() {
        return false;
    }

    @Override
    protected void propagateSecurityContext(SSOAgentRequest request, Principal principal) {
        SSOPartnerAppConfig partnerAppConfig;
        HttpSSOAgentRequest servletSSOAgentRequest = (HttpSSOAgentRequest)request;
        String contextPath = servletSSOAgentRequest.getRequest().getContextPath();
        if ("".equals(contextPath)) {
            contextPath = "/";
        }
        if ((partnerAppConfig = this.getPartnerAppConfig(servletSSOAgentRequest.getRequest().getServerName(), contextPath)).getSecurityContextPropagationConfig() == null) {
            return;
        }
        String binding = partnerAppConfig.getSecurityContextPropagationConfig().getBinding();
        String userPlaceHolder = partnerAppConfig.getSecurityContextPropagationConfig().getUserPlaceHolder();
        String rolesPlaceHolder = partnerAppConfig.getSecurityContextPropagationConfig().getRolesPlaceHolder();
        String propertiesPlaceholder = partnerAppConfig.getSecurityContextPropagationConfig().getPropertiesPlaceHolder();
        String user = principal.getName();
        if (binding != null && userPlaceHolder != null && rolesPlaceHolder != null) {
            SSORole[] roleSets;
            try {
                roleSets = this.im.findRolesBySSOSessionId(request.getRequester(), servletSSOAgentRequest.getSessionId());
            }
            catch (SSOIdentityException e) {
                if (this.debug > 0) {
                    this.log("Error fetching roles for SSO Session [" + servletSSOAgentRequest.getSessionId() + "]" + " on attempting to propagate security context, aborting");
                }
                return;
            }
            HttpServletRequest hreq = servletSSOAgentRequest.getRequest();
            if (binding.equalsIgnoreCase("HTTP_HEADERS")) {
                HashMap headers = new HashMap();
                ArrayList<String> users = new ArrayList<String>();
                users.add(user);
                headers.put(userPlaceHolder, users);
                if (this.debug > 0) {
                    this.log("Propagated user [" + user + "] onto HTTP Header [" + userPlaceHolder + "]");
                }
                ArrayList<String> roles = new ArrayList<String>();
                for (int i = 0; i < roleSets.length; ++i) {
                    SSORole roleSet = roleSets[i];
                    roles.add(roleSet.getName());
                    if (this.debug <= 0) continue;
                    this.log("Propagated role [" + roleSet.getName() + "] onto HTTP_HEADERS based security context");
                }
                headers.put(rolesPlaceHolder, roles);
                hreq.setAttribute("org.josso.agent.http.securitycontext.binding", (Object)"HTTP_HEADERS_BINDING");
                hreq.setAttribute("org.josso.agent.http.securitycontext.content", headers);
            } else if (binding.equalsIgnoreCase("HREQ_ATTRS")) {
                HashMap<String, String> attrs = new HashMap<String, String>();
                attrs.put(userPlaceHolder, user);
                for (int i = 0; i < roleSets.length; ++i) {
                    SSORole roleSet = roleSets[i];
                    attrs.put(rolesPlaceHolder + "_" + i, roleSet.getName());
                    if (this.debug <= 0) continue;
                    this.log("Propagated role [" + roleSet.getName() + "] onto HREQ_ATTRS based security context");
                }
                SSOUser usr = (SSOUser)principal;
                if (usr.getProperties() != null) {
                    Properties props = new Properties();
                    for (int i = 0; i < usr.getProperties().length; ++i) {
                        attrs.put(propertiesPlaceholder + "_" + usr.getProperties()[i].getName(), usr.getProperties()[i].getValue());
                        if (this.debug <= 0) continue;
                        this.log("Propagated role [" + usr.getProperties()[i].getName() + "=" + usr.getProperties()[i].getValue() + "] onto HREQ_ATTRS based security context");
                    }
                }
                hreq.setAttribute("org.josso.agent.http.securitycontext.content", attrs);
                hreq.setAttribute("org.josso.agent.http.securitycontext.binding", (Object)"HTTP_REQ_ATTRS_BINDING");
            }
        }
    }

    public boolean isAutomaticLoginRequired(HttpServletRequest hreq) {
        return this.isAutomaticLoginRequired(hreq, null);
    }

    public boolean isAutomaticLoginRequired(HttpServletRequest hreq, HttpServletResponse hres) {
        Boolean requiredFlag = null;
        Boolean sufficientFlag = null;
        for (AutomaticLoginStrategy as : this._automaticStrategies) {
            if (as.getMode().equals("SUFFICIENT") && as.isAutomaticLoginRequired(hreq, hres)) {
                sufficientFlag = true;
                break;
            }
            if (as.getMode().equals("REQUIRED")) {
                if (!as.isAutomaticLoginRequired(hreq, hres)) {
                    requiredFlag = false;
                } else if (requiredFlag == null) {
                    requiredFlag = true;
                }
            }
            if (!as.getMode().equals("OPTIONAL")) continue;
            as.isAutomaticLoginRequired(hreq, hres);
        }
        if (requiredFlag != null) {
            return requiredFlag;
        }
        return sufficientFlag != null && sufficientFlag != false;
    }

    public void clearAutomaticLoginReferer(HttpServletRequest hreq) {
        this.clearAutomaticLoginReferer(hreq, null);
    }

    public void clearAutomaticLoginReferer(HttpServletRequest hreq, HttpServletResponse hres) {
        this.removeAttribute(hreq, hres, "JOSSO_AUTOMATIC_LOGIN_REFERER");
    }

    public String buildLogoutUrl(HttpServletRequest hreq) {
        return this.buildLogoutUrl(hreq, "/");
    }

    public String buildLogoutUrl(HttpServletRequest hreq, SSOPartnerAppConfig cfg) {
        return this.buildLogoutUrl(hreq, cfg.getDefaultResource() != null ? cfg.getDefaultResource() : "/");
    }

    public String buildLogoutUrl(HttpServletRequest hreq, String backToPath) {
        String backto = this.buildBackToURL(hreq, backToPath);
        String logoutUrl = this.getGatewayLogoutUrl() + (backto != null ? "?josso_back_to=" + backto : "");
        logoutUrl = logoutUrl + this.buildLogoutUrlParams(hreq);
        return logoutUrl;
    }

    public String buildLoginUrl(HttpServletRequest hreq) {
        String loginUrl = this.getGatewayLoginUrl();
        String backto = this.buildBackToURL(hreq, this.getJOSSOSecurityCheckUri());
        loginUrl = loginUrl + "?josso_back_to=" + backto;
        loginUrl = loginUrl + this.buildLoginUrlParams(hreq);
        return loginUrl;
    }

    public String buildLoginOptionalUrl(HttpServletRequest hreq) {
        String loginUrl = this.getGatewayLoginUrl();
        String backto = this.buildBackToURL(hreq, this.getJOSSOSecurityCheckUri());
        loginUrl = loginUrl + "?josso_cmd=login_optional&josso_back_to=" + backto;
        loginUrl = loginUrl + this.buildLoginUrlParams(hreq);
        return loginUrl;
    }

    public String buildBackToURL(HttpServletRequest hreq, String uri) {
        String backto = null;
        String contextPath = hreq.getContextPath();
        if (contextPath == null || "".equals(contextPath)) {
            contextPath = "/";
        }
        String reverseProxyHost = hreq.getHeader("Josso-ReversE-Proxy");
        String singlePointOfAccess = this.getSinglePointOfAccess();
        if (singlePointOfAccess != null) {
            if (this.debug >= 1) {
                this.log("josso_back_to option : singlePointOfAccess: " + singlePointOfAccess);
            }
            backto = singlePointOfAccess + contextPath + uri;
        } else if (reverseProxyHost != null) {
            if (this.debug >= 1) {
                this.log("josso_back_to option : reverse-proxy-host: " + reverseProxyHost);
            }
            backto = reverseProxyHost + contextPath + uri;
        } else {
            StringBuffer mySelf = HttpUtils.getRequestURL((HttpServletRequest)hreq);
            try {
                URL url = new URL(mySelf.toString());
                backto = url.getProtocol() + "://" + url.getHost() + (url.getPort() > 0 ? ":" + url.getPort() : "");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            backto = backto + (contextPath.endsWith("/") ? contextPath.substring(0, contextPath.length() - 1) : contextPath) + uri;
        }
        if (this.debug >= 1) {
            this.log("Using josso_back_to : " + backto);
        }
        return backto;
    }

    public String buildPostAuthUrl(HttpServletResponse hres, String requestURI, String postAuthURI) {
        String encURL = requestURI.replaceAll("&", "%26").replaceAll("\\?", "%3F");
        return hres.encodeRedirectURL(postAuthURI + "?josso_original_resource=" + hres.encodeURL(encURL));
    }

    public Cookie newJossoCookie(String path, String value, boolean secure) {
        if (path == null || "".equals(path)) {
            path = "/";
        }
        Cookie ssoCookie = new Cookie("JOSSO_SESSIONID", value);
        ssoCookie.setMaxAge(-1);
        ssoCookie.setPath(path);
        ssoCookie.setSecure(secure);
        return ssoCookie;
    }

    public String buildAutomaticSubmitForm(HttpServletRequest request) {
        return null;
    }

    protected String buildLoginUrlParams(HttpServletRequest hreq) {
        SSOPartnerAppConfig cfg = super.getPartnerAppConfig(hreq.getServerName(), hreq.getContextPath());
        String urlParams = "";
        for (FrontChannelParametersBuilder builder : this._builders) {
            SSONameValuePair[] params;
            for (SSONameValuePair param : params = builder.buildParamters(cfg, hreq)) {
                urlParams = urlParams + "&" + param.getName() + "=" + param.getValue();
            }
        }
        return urlParams;
    }

    protected String buildLogoutUrlParams(HttpServletRequest hreq) {
        SSOPartnerAppConfig cfg = super.getPartnerAppConfig(hreq.getServerName(), hreq.getContextPath());
        String urlParams = "";
        for (FrontChannelParametersBuilder builder : this._builders) {
            SSONameValuePair[] params;
            for (SSONameValuePair param : params = builder.buildParamters(cfg, hreq)) {
                urlParams = urlParams + "&" + param.getName() + "=" + param.getValue();
            }
        }
        return urlParams;
    }

    @Override
    protected void sendCustomAuthentication(SSOAgentRequest request) throws IOException {
        AbstractStringBuilder sb;
        HttpServletRequest hreq = ((HttpSSOAgentRequest)request).getRequest();
        HttpServletResponse hres = ((HttpSSOAgentRequest)request).getResponse();
        this.prepareNonCacheResponse(hres);
        SSOPartnerAppConfig cfg = this.getPartnerAppConfig(hreq.getServerName(), hreq.getContextPath());
        String splash_resource = null;
        if (hreq.getRequestURI().endsWith(this.getJOSSOAuthenticationUri())) {
            splash_resource = hreq.getParameter("josso_splash_resource");
            if ((splash_resource == null || "".equals(splash_resource)) && cfg != null) {
                splash_resource = cfg.getSplashResource();
            }
        } else {
            if (this.debug > 0) {
                this.log("sendCustomAuthentication executed but URL does not match AUTHENTICATION URI");
            }
            sb = new StringBuffer(hreq.getRequestURI());
            if (hreq.getQueryString() != null) {
                ((StringBuffer)sb).append('?');
                ((StringBuffer)sb).append(hreq.getQueryString());
            }
            String[] uriArray = new String[1];
            splash_resource = ((StringBuffer)sb).toString();
        }
        if (this.debug > 0) {
            this.log("Storing Splash resource '" + splash_resource + "'");
        }
        this.setAttribute(hreq, hres, "josso_splash_resource", splash_resource);
        sb = new StringBuilder();
        ((StringBuilder)sb).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"\n\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\">\n<body onload=\"document.forms[0].submit()\">\n<noscript>\n<p>\n<strong>Note:</strong> Since your browser does not support JavaScript,\nyou must press the Continue button once to proceed.\n</p>\n</noscript>\n<form action=\"").append(this.getGatewayLoginUrl()).append("\" method=\"post\" name=\"usernamePasswordLoginForm\" enctype=\"application/x-www-form-urlencoded\">\n        <div>");
        Enumeration paramNames = hreq.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String paramValue = hreq.getParameter(paramName);
            if ("josso_splash_resource".equals(paramName)) continue;
            ((StringBuilder)sb).append("\n            <input type=\"hidden\" value=\"").append(paramValue).append("\" name=\"").append(paramName).append("\" />");
        }
        ((StringBuilder)sb).append("\n            <noscript><input type=\"submit\" value=\"Continue\"/></noscript>\n        </div>\n</form>\n</body>\n</html>");
        hres.setContentType("text/html");
        PrintWriter out = hres.getWriter();
        out.print(((StringBuilder)sb).toString());
        if (this.debug >= 1) {
            this.log("Sending an automatic post form : \n" + ((StringBuilder)sb).toString());
        }
        out.flush();
    }

    public void prepareNonCacheResponse(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "0");
    }

    public boolean isResourceIgnored(SSOPartnerAppConfig cfg, HttpServletRequest request) {
        String[] ignoredUrlPatterns = cfg.getIgnoredUrlPatterns();
        if (this.debug >= 1) {
            this.log("Found [" + (ignoredUrlPatterns != null ? ignoredUrlPatterns.length + "" : "no") + "] ignored url patterns ");
        }
        if (ignoredUrlPatterns != null && ignoredUrlPatterns.length > 0) {
            String requestPath = request.getServletPath();
            String pathInfo = request.getPathInfo();
            if (pathInfo != null) {
                requestPath = requestPath + pathInfo;
            }
            for (int i = 0; i < ignoredUrlPatterns.length; ++i) {
                String ignoredUrlPattern = ignoredUrlPatterns[i];
                if (!this.matchPattern(requestPath, ignoredUrlPattern)) continue;
                if (this.debug >= 1) {
                    this.log("Not subject to SSO protection :  url-pattern:" + ignoredUrlPattern);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean matchPattern(String path, String pattern) {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if (pattern == null || pattern.length() == 0) {
            pattern = "/";
        }
        if (path.equals(pattern)) {
            return true;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            if ((pattern = pattern.substring(0, pattern.length() - 2)).length() == 0) {
                return true;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            while (true) {
                if (pattern.equals(path)) {
                    return true;
                }
                int slash = path.lastIndexOf(47);
                if (slash <= 0) break;
                path = path.substring(0, slash);
            }
            return false;
        }
        if (pattern.startsWith("*.")) {
            int slash = path.lastIndexOf(47);
            int period = path.lastIndexOf(46);
            return slash >= 0 && period > slash && path.endsWith(pattern.substring(1));
        }
        return pattern.equals("/");
    }

    public SSORole[] getRoleSets(String requester, String ssoSessionId) {
        try {
            SSOIdentityManagerService im = Lookup.getInstance().lookupSSOAgent().getSSOIdentityManager();
            return im.findRolesBySSOSessionId(requester, ssoSessionId);
        }
        catch (Exception e) {
            this.log("Error finding roles for : " + ssoSessionId, e);
            throw new RuntimeException("Error finding roles for : " + ssoSessionId);
        }
    }

    public String getJOSSOLoginUri() {
        return JOSSO_LOGIN_URI;
    }

    public String getJOSSOUserLoginUri() {
        return JOSSO_USER_LOGIN_URI;
    }

    public String getJOSSOSecurityCheckUri() {
        return JOSSO_SECURITY_CHECK_URI;
    }

    public String getJOSSOLogoutUri() {
        return JOSSO_LOGOUT_URI;
    }

    public String getJOSSOAuthenticationUri() {
        return JOSSO_AUTHENTICATION_URI;
    }

    public void setParametersBuilders(List<FrontChannelParametersBuilder> builders) {
        this._builders = builders;
    }

    public List<FrontChannelParametersBuilder> getParametersBuilders() {
        return this._builders;
    }

    public void setAttribute(HttpServletRequest hreq, HttpServletResponse hres, String name, String value) {
        if (this.isStateOnClient()) {
            HashSet removed = (HashSet)hreq.getAttribute("org.josso.attrs.removed");
            if (removed == null) {
                removed = new HashSet();
            }
            if (removed.contains(name)) {
                removed.remove(name);
            }
            this.log("Storing attribute " + name + "=" + value + " client side");
            if (hres == null) {
                throw new IllegalArgumentException("HTTP Servlet response cannot be null.  Are you using any deprecated operations?");
            }
            String cookieValue = null;
            try {
                cookieValue = CipherUtil.encodeBase64((byte[])value.getBytes());
                cookieValue = URLEncoder.encode(cookieValue, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.log("Base64 encoding failed : " + value, e);
                cookieValue = value;
            }
            Cookie cookie = new Cookie(name, cookieValue);
            cookie.setPath(hreq.getContextPath());
            cookie.setMaxAge(-1);
            cookie.setSecure(hreq.isSecure());
            hres.addCookie(cookie);
            hreq.setAttribute(name, (Object)value);
        } else {
            this.log("Storing attribute " + name + "=" + value + " server side");
            hreq.getSession().setAttribute(name, (Object)value);
        }
    }

    public String getAttribute(HttpServletRequest hreq, String name) {
        if (this.isStateOnClient()) {
            HashSet removed = (HashSet)hreq.getAttribute("org.josso.attrs.removed");
            if (removed == null) {
                removed = new HashSet();
            }
            if (removed.contains(name)) {
                return null;
            }
            String vlocal = (String)hreq.getAttribute(name);
            if (vlocal != null && !"".equals(vlocal)) {
                return vlocal;
            }
            Cookie[] cookies = hreq.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals(name)) continue;
                    String cookieValue = cookie.getValue();
                    String value = null;
                    try {
                        cookieValue = URLDecoder.decode(cookieValue, "UTF-8");
                        value = new String(CipherUtil.decodeBase64((String)cookieValue));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.log("Base64 decoding failed : " + cookieValue, e);
                        value = cookieValue;
                    }
                    if (value == null || value.equals("-") || value.equals("")) {
                        return null;
                    }
                    return value;
                }
            }
            return null;
        }
        return (String)hreq.getSession().getAttribute(name);
    }

    public void removeAttribute(HttpServletRequest hreq, HttpServletResponse hres, String name) {
        if (this.isStateOnClient()) {
            HashSet<String> removed = (HashSet<String>)hreq.getAttribute("org.josso.attrs.removed");
            if (removed == null) {
                removed = new HashSet<String>();
            }
            this.log("Remove attribute " + name + " from client side");
            Cookie cookie = new Cookie(name, "-");
            cookie.setPath(hreq.getContextPath());
            cookie.setMaxAge(0);
            cookie.setSecure(hreq.isSecure());
            hres.addCookie(cookie);
            removed.add(name);
            hreq.removeAttribute(name);
        } else {
            this.log("Remove attribute " + name + " from server side");
            hreq.getSession().removeAttribute(name);
        }
    }

    public List<AutomaticLoginStrategy> getAutomaticLoginStrategies() {
        return this._automaticStrategies;
    }

    public void setAutomaticLoginStrategies(List<AutomaticLoginStrategy> _automaticStrategies) {
        this._automaticStrategies = _automaticStrategies;
    }
}

