/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.AbstractBoxParser;
import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyBoxParserImpl
extends AbstractBoxParser {
    Properties mapping;
    Pattern p = Pattern.compile("(.*)\\((.*?)\\)");

    public PropertyBoxParserImpl(String ... customProperties) {
        InputStream is = this.getClass().getResourceAsStream("/isoparser-default.properties");
        this.mapping = new Properties();
        try {
            this.mapping.load(is);
            Enumeration<URL> enumeration = Thread.currentThread().getContextClassLoader().getResources("isoparser-custom.properties");
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                this.mapping.load(url.openStream());
            }
            for (String customProperty : customProperties) {
                this.mapping.load(this.getClass().getResourceAsStream(customProperty));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public PropertyBoxParserImpl(Properties mapping) {
        this.mapping = mapping;
    }

    @Override
    public Class<? extends Box> getClassForFourCc(byte[] type, byte[] userType, byte[] parent) {
        FourCcToBox fourCcToBox = new FourCcToBox(type, userType, parent).invoke();
        try {
            return Class.forName(fourCcToBox.clazzName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AbstractBox createBox(byte[] type, byte[] userType, byte[] parent, Box lastMovieFragmentBox) {
        FourCcToBox fourCcToBox = new FourCcToBox(type, userType, parent).invoke();
        String[] param = fourCcToBox.getParam();
        String clazzName = fourCcToBox.getClazzName();
        try {
            if (param[0].trim().length() == 0) {
                param = new String[]{};
            }
            Class<?> clazz = Class.forName(clazzName);
            Class[] constructorArgsClazz = new Class[param.length];
            Object[] constructorArgs = new Object[param.length];
            for (int i = 0; i < param.length; ++i) {
                if ("userType".equals(param[i])) {
                    constructorArgs[i] = userType;
                    constructorArgsClazz[i] = byte[].class;
                    continue;
                }
                if ("type".equals(param[i])) {
                    constructorArgs[i] = type;
                    constructorArgsClazz[i] = byte[].class;
                    continue;
                }
                if ("parent".equals(param[i])) {
                    constructorArgs[i] = parent;
                    constructorArgsClazz[i] = byte[].class;
                    continue;
                }
                if ("lastMovieFragmentBox".equals(param[i])) {
                    constructorArgs[i] = lastMovieFragmentBox;
                    constructorArgsClazz[i] = MovieFragmentBox.class;
                    continue;
                }
                throw new InternalError("No such param: " + param[i]);
            }
            try {
                Constructor<?> constructorObject = param.length > 0 ? clazz.getConstructor(constructorArgsClazz) : clazz.getConstructor(new Class[0]);
                return (AbstractBox)constructorObject.newInstance(constructorArgs);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private class FourCcToBox {
        private byte[] type;
        private byte[] userType;
        private byte[] parent;
        private String clazzName;
        private String[] param;

        public FourCcToBox(byte[] type, byte[] userType, byte[] parent) {
            this.type = type;
            this.parent = parent;
            this.userType = userType;
        }

        public String getClazzName() {
            return this.clazzName;
        }

        public String[] getParam() {
            return this.param;
        }

        public FourCcToBox invoke() {
            String constructor;
            if (this.userType != null) {
                if (!"uuid".equals(IsoFile.bytesToFourCC(this.type))) {
                    throw new RuntimeException("we have a userType but no uuid box type. Something's wrong");
                }
                constructor = PropertyBoxParserImpl.this.mapping.getProperty(IsoFile.bytesToFourCC(this.parent) + "-uuid[" + Hex.encodeHex(this.userType).toUpperCase() + "]");
                if (constructor == null) {
                    constructor = PropertyBoxParserImpl.this.mapping.getProperty("uuid[" + Hex.encodeHex(this.userType).toUpperCase() + "]");
                }
                if (constructor == null) {
                    constructor = PropertyBoxParserImpl.this.mapping.getProperty("uuid");
                }
            } else {
                constructor = PropertyBoxParserImpl.this.mapping.getProperty(IsoFile.bytesToFourCC(this.parent) + "-" + IsoFile.bytesToFourCC(this.type));
                if (constructor == null) {
                    constructor = PropertyBoxParserImpl.this.mapping.getProperty(IsoFile.bytesToFourCC(this.type));
                }
            }
            if (constructor == null) {
                constructor = PropertyBoxParserImpl.this.mapping.getProperty("default");
            }
            if (constructor == null) {
                throw new RuntimeException("No box object found for " + IsoFile.bytesToFourCC(this.type));
            }
            Matcher m = PropertyBoxParserImpl.this.p.matcher(constructor);
            boolean matches = m.matches();
            if (!matches) {
                throw new RuntimeException("Cannot work with that constructor: " + constructor);
            }
            this.clazzName = m.group(1);
            this.param = m.group(2).split(",");
            return this;
        }
    }
}

