/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class ItemLocationBox
extends AbstractFullBox {
    public int offsetSize;
    public int lengthSize;
    public int baseOffsetSize;
    public int indexSize;
    public int itemCount;
    public Item[] items;
    public static final String TYPE = "iloc";

    public ItemLocationBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected long getContentSize() {
        long size = 2 + (this.getVersion() != 1 ? 2 : 0);
        for (Item item : this.items) {
            size += item.getContentSize();
        }
        return size;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        int tmp = in.readUInt8();
        this.offsetSize = tmp >>> 4;
        this.lengthSize = tmp & 0xF;
        tmp = in.readUInt8();
        this.baseOffsetSize = tmp >>> 4;
        if (this.getVersion() == 1) {
            this.indexSize = tmp & 0xF;
        } else {
            this.itemCount = in.readUInt16();
        }
        this.items = new Item[this.itemCount];
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = new Item(in);
        }
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt8(this.offsetSize << 4 | this.lengthSize);
        if (this.getVersion() == 1) {
            os.writeUInt8(this.baseOffsetSize << 4 | this.indexSize);
        } else {
            os.writeUInt8(this.baseOffsetSize << 4);
            os.writeUInt16(this.itemCount);
        }
        for (Item item : this.items) {
            item.getContent(os);
        }
    }

    public int getOffsetSize() {
        return this.offsetSize;
    }

    public void setOffsetSize(int offsetSize) {
        this.offsetSize = offsetSize;
    }

    public int getLengthSize() {
        return this.lengthSize;
    }

    public void setLengthSize(int lengthSize) {
        this.lengthSize = lengthSize;
    }

    public int getBaseOffsetSize() {
        return this.baseOffsetSize;
    }

    public void setBaseOffsetSize(int baseOffsetSize) {
        this.baseOffsetSize = baseOffsetSize;
    }

    public int getIndexSize() {
        return this.indexSize;
    }

    public void setIndexSize(int indexSize) {
        this.indexSize = indexSize;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void setItemCount(int itemCount) {
        this.itemCount = itemCount;
    }

    public Item[] getItems() {
        return this.items;
    }

    public void setItems(Item[] items) {
        this.items = items;
    }

    public class Item {
        public int itemId;
        public int constructionMethod;
        public int dataReferenceIndex;
        public byte[] baseOffset;
        public int extentCount;
        public Extent[] extents;

        public Item(IsoBufferWrapper in) throws IOException {
            this.baseOffset = new byte[ItemLocationBox.this.baseOffsetSize];
            this.itemId = in.readUInt16();
            if (ItemLocationBox.this.getVersion() == 1) {
                int tmp = in.readUInt16();
                this.constructionMethod = tmp & 0xF;
            }
            this.dataReferenceIndex = in.readUInt16();
            in.read(this.baseOffset);
            this.extentCount = in.readUInt16();
            this.extents = new Extent[this.extentCount];
            for (int i = 0; i < this.extents.length; ++i) {
                this.extents[i] = new Extent(in);
            }
        }

        public long getContentSize() {
            long size = 2 + (ItemLocationBox.this.getVersion() == 1 ? 2 : 0) + 2 + ItemLocationBox.this.baseOffsetSize + 2;
            if (ItemLocationBox.this.getVersion() == 1 && ItemLocationBox.this.getIndexSize() > 0) {
                size += (long)(this.extentCount * ItemLocationBox.this.getIndexSize());
            }
            return size += (long)(this.extentCount * (ItemLocationBox.this.offsetSize + ItemLocationBox.this.lengthSize));
        }

        public void getContent(IsoOutputStream os) throws IOException {
            os.writeUInt16(this.itemId);
            if (ItemLocationBox.this.getVersion() == 1) {
                os.writeUInt16(this.constructionMethod);
            }
            os.writeUInt16(this.dataReferenceIndex);
            os.writeUInt16(this.extentCount);
            for (Extent extent : this.extents) {
                extent.getContent(os);
            }
        }

        public class Extent {
            public byte[] extentOffset;
            public byte[] extentLength;
            public byte[] extentIndex;

            public Extent(IsoBufferWrapper in) throws IOException {
                if (ItemLocationBox.this.getVersion() == 1 && ItemLocationBox.this.getIndexSize() > 0) {
                    this.extentIndex = new byte[ItemLocationBox.this.getIndexSize()];
                    in.read(this.extentIndex);
                }
                this.extentOffset = new byte[ItemLocationBox.this.offsetSize];
                this.extentLength = new byte[ItemLocationBox.this.lengthSize];
                in.read(this.extentOffset);
                in.read(this.extentLength);
            }

            public void getContent(IsoOutputStream os) throws IOException {
                if (ItemLocationBox.this.getVersion() == 1 && ItemLocationBox.this.getIndexSize() > 0) {
                    os.write(this.extentIndex);
                }
                os.write(this.extentOffset);
                os.write(this.extentLength);
            }
        }
    }
}

