/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.fragment;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.fragment.SampleFlags;
import java.io.IOException;

public class TrackExtendsBox
extends AbstractFullBox {
    public static final String TYPE = "trex";
    private long trackId;
    private long defaultSampleDescriptionIndex;
    private long defaultSampleDuration;
    private long defaultSampleSize;
    private SampleFlags defaultSampleFlags;

    public TrackExtendsBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected long getContentSize() {
        return 20L;
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt32(this.trackId);
        os.writeUInt32(this.defaultSampleDescriptionIndex);
        os.writeUInt32(this.defaultSampleDuration);
        os.writeUInt32(this.defaultSampleSize);
        this.defaultSampleFlags.getContent(os);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.trackId = in.readUInt32();
        this.defaultSampleDescriptionIndex = in.readUInt32();
        this.defaultSampleDuration = in.readUInt32();
        this.defaultSampleSize = in.readUInt32();
        this.defaultSampleFlags = new SampleFlags(in.readUInt32());
    }

    public long getTrackId() {
        return this.trackId;
    }

    public long getDefaultSampleDescriptionIndex() {
        return this.defaultSampleDescriptionIndex;
    }

    public long getDefaultSampleDuration() {
        return this.defaultSampleDuration;
    }

    public long getDefaultSampleSize() {
        return this.defaultSampleSize;
    }

    public String getDefaultSampleFlags() {
        return this.defaultSampleFlags.toString();
    }

    public void setTrackId(long trackId) {
        this.trackId = trackId;
    }

    public void setDefaultSampleDescriptionIndex(long defaultSampleDescriptionIndex) {
        this.defaultSampleDescriptionIndex = defaultSampleDescriptionIndex;
    }

    public void setDefaultSampleDuration(long defaultSampleDuration) {
        this.defaultSampleDuration = defaultSampleDuration;
    }

    public void setDefaultSampleSize(long defaultSampleSize) {
        this.defaultSampleSize = defaultSampleSize;
    }

    public void setDefaultSampleFlags(SampleFlags defaultSampleFlags) {
        this.defaultSampleFlags = defaultSampleFlags;
    }
}

