/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoBufferWrapperImpl;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ObjectDescriptorFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AbstractDescriptorBox
extends AbstractFullBox {
    private static Logger log = Logger.getLogger(AbstractDescriptorBox.class.getName());
    public BaseDescriptor descriptor;
    public byte[] data;

    public AbstractDescriptorBox(String type) {
        super(type);
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.write(this.data);
    }

    protected long getContentSize() {
        return this.descriptor.getSize();
    }

    public BaseDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getDescriptorAsString() {
        return this.descriptor.toString();
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.data = in.read((int)size - 4);
        IsoBufferWrapperImpl descriptorBuffer = new IsoBufferWrapperImpl(ByteBuffer.wrap(this.data));
        try {
            this.descriptor = ObjectDescriptorFactory.createFrom(-1, descriptorBuffer, descriptorBuffer.size());
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error parsing ObjectDescriptor", e);
        }
        catch (IndexOutOfBoundsException e) {
            log.log(Level.WARNING, "Error parsing ObjectDescriptor", e);
        }
    }
}

