/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import com.coremedia.iso.IsoBufferWrapper;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.Descriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ESDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ExtensionDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ObjectDescriptorBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Descriptor(tags={1, 17})
public class ObjectDescriptor
extends ObjectDescriptorBase {
    private int objectDescriptorId;
    int objectDescriptorUrlFlag;
    int objectDescriptorUrlLength;
    String objectDescriptorUrlString;
    private int streamCount;
    private int extensionFlag;
    private List<ESDescriptor> esDescriptors = new ArrayList<ESDescriptor>();
    private int descriptorLength;
    private List<ExtensionDescriptor> extensionDescriptors = new ArrayList<ExtensionDescriptor>();

    public static ObjectDescriptor createFrom(IsoBufferWrapper in) throws IOException {
        ObjectDescriptor objectDescriptor = new ObjectDescriptor();
        int data = in.readUInt16();
        objectDescriptor.objectDescriptorId = data & 0xFFC0;
        objectDescriptor.streamCount = data & 0x3E;
        objectDescriptor.extensionFlag = data & 1;
        return objectDescriptor;
    }

    public String toString() {
        return "ObjectDescriptor{objectDescriptorId=" + this.objectDescriptorId + ", streamCount=" + this.streamCount + ", extensionFlag=" + this.extensionFlag + ", esDescriptors=" + this.esDescriptors + ", descriptorLength=" + this.descriptorLength + ", extensionDescriptors=" + this.extensionDescriptors + '}';
    }
}

