/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.InlineCostEstimator;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.LinkedList;
import java.util.Locale;

class PeepholeReplaceKnownMethods
extends AbstractPeepholeOptimization {
    private static final Locale ROOT_LOCALE = new Locale("");

    PeepholeReplaceKnownMethods() {
    }

    @Override
    Node optimizeSubtree(Node subtree) {
        if (subtree.isCall()) {
            return this.tryFoldKnownMethods(subtree);
        }
        return subtree;
    }

    private Node tryFoldKnownMethods(Node subtree) {
        if ((subtree = this.tryFoldArrayJoin(subtree)).isCall()) {
            Node callTarget = subtree.getFirstChild();
            if (callTarget == null) {
                return subtree;
            }
            subtree = NodeUtil.isGet(callTarget) ? this.tryFoldKnownStringMethods(subtree) : this.tryFoldKnownNumericMethods(subtree);
        }
        return subtree;
    }

    private Node tryFoldKnownStringMethods(Node subtree) {
        Preconditions.checkArgument((boolean)subtree.isCall());
        Node callTarget = subtree.getFirstChild();
        if (callTarget == null) {
            return subtree;
        }
        if (!NodeUtil.isGet(callTarget)) {
            return subtree;
        }
        Node stringNode = callTarget.getFirstChild();
        Node functionName = stringNode.getNext();
        if (stringNode.getType() != 40 || functionName.getType() != 40) {
            return subtree;
        }
        String functionNameString = functionName.getString();
        Node firstArg = callTarget.getNext();
        if (firstArg == null) {
            if (functionNameString.equals("toLowerCase")) {
                subtree = this.tryFoldStringToLowerCase(subtree, stringNode);
            } else if (functionNameString.equals("toUpperCase")) {
                subtree = this.tryFoldStringToUpperCase(subtree, stringNode);
            }
            return subtree;
        }
        if (NodeUtil.isImmutableValue(firstArg)) {
            if (functionNameString.equals("indexOf") || functionNameString.equals("lastIndexOf")) {
                subtree = this.tryFoldStringIndexOf(subtree, functionNameString, stringNode, firstArg);
            } else if (functionNameString.equals("substr")) {
                subtree = this.tryFoldStringSubstr(subtree, stringNode, firstArg);
            } else if (functionNameString.equals("substring")) {
                subtree = this.tryFoldStringSubstring(subtree, stringNode, firstArg);
            } else if (functionNameString.equals("charAt")) {
                subtree = this.tryFoldStringCharAt(subtree, stringNode, firstArg);
            } else if (functionNameString.equals("charCodeAt")) {
                subtree = this.tryFoldStringCharCodeAt(subtree, stringNode, firstArg);
            }
        }
        return subtree;
    }

    private Node tryFoldKnownNumericMethods(Node subtree) {
        Preconditions.checkArgument((boolean)subtree.isCall());
        if (this.isASTNormalized()) {
            Node callTarget = subtree.getFirstChild();
            if (!callTarget.isName()) {
                return subtree;
            }
            String functionNameString = callTarget.getString();
            Node firstArgument = callTarget.getNext();
            if (firstArgument != null && (firstArgument.isString() || firstArgument.isNumber()) && (functionNameString.equals("parseInt") || functionNameString.equals("parseFloat"))) {
                subtree = this.tryFoldParseNumber(subtree, functionNameString, firstArgument);
            }
        }
        return subtree;
    }

    private Node tryFoldStringToLowerCase(Node subtree, Node stringNode) {
        String lowered = stringNode.getString().toLowerCase(ROOT_LOCALE);
        Node replacement = Node.newString(lowered);
        subtree.getParent().replaceChild(subtree, replacement);
        this.reportCodeChange();
        return replacement;
    }

    private Node tryFoldStringToUpperCase(Node subtree, Node stringNode) {
        String uppered = stringNode.getString().toUpperCase(ROOT_LOCALE);
        Node replacement = Node.newString(uppered);
        subtree.getParent().replaceChild(subtree, replacement);
        this.reportCodeChange();
        return replacement;
    }

    private String normalizeNumericString(String input) {
        int startIndex;
        if (input == null || input.length() == 0) {
            return input;
        }
        int endIndex = input.length() - 1;
        for (startIndex = 0; startIndex < input.length() && input.charAt(startIndex) == '0'; ++startIndex) {
        }
        while (endIndex >= 0 && input.charAt(endIndex) == '0') {
            --endIndex;
        }
        if (startIndex >= endIndex) {
            return input;
        }
        return input.substring(startIndex, endIndex + 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Node tryFoldParseNumber(Node n, String functionName, Node firstArg) {
        Node newNode;
        String stringVal;
        int radix;
        boolean isParseInt;
        block22: {
            Preconditions.checkArgument((boolean)n.isCall());
            isParseInt = functionName.equals("parseInt");
            Node secondArg = firstArg.getNext();
            radix = 0;
            if (secondArg != null) {
                if (!isParseInt) {
                    return n;
                }
                if (secondArg.getNext() != null || secondArg.getType() != 39) {
                    return n;
                }
                double tmpRadix = secondArg.getDouble();
                if (tmpRadix != (double)((int)tmpRadix)) {
                    return n;
                }
                radix = (int)tmpRadix;
                if (radix < 0 || radix == 1 || radix > 36) {
                    return n;
                }
            }
            stringVal = null;
            if (firstArg.isNumber()) {
                Double checkVal = NodeUtil.getNumberValue(firstArg);
                if (radix != 0 && radix != 10 && isParseInt) {
                    stringVal = String.valueOf(checkVal.intValue());
                    break block22;
                } else {
                    Node numericNode = isParseInt ? Node.newNumber(checkVal.intValue()) : Node.newNumber(checkVal);
                    n.getParent().replaceChild(n, numericNode);
                    this.reportCodeChange();
                    return numericNode;
                }
            }
            stringVal = NodeUtil.getStringValue(firstArg);
            if (stringVal == null) {
                return n;
            }
            Double checkVal = NodeUtil.getStringNumberValue(stringVal);
            if (checkVal == null) {
                return n;
            }
            stringVal = NodeUtil.trimJsWhiteSpace(stringVal);
        }
        if (isParseInt) {
            if (radix == 0 || radix == 16) {
                if (stringVal.length() > 1 && stringVal.substring(0, 2).equalsIgnoreCase("0x")) {
                    radix = 16;
                    stringVal = stringVal.substring(2);
                } else if (radix == 0) {
                    if (!this.isEcmaScript5OrGreater() && stringVal.substring(0, 1).equals("0")) {
                        return n;
                    }
                    radix = 10;
                }
            }
            int newVal = 0;
            try {
                newVal = Integer.parseInt(stringVal, radix);
            }
            catch (NumberFormatException e) {
                return n;
            }
            newNode = Node.newNumber(newVal);
        } else {
            String normalizedNewVal = "0";
            try {
                double newVal = Double.parseDouble(stringVal);
                newNode = Node.newNumber(newVal);
                normalizedNewVal = this.normalizeNumericString(String.valueOf(newVal));
            }
            catch (NumberFormatException e) {
                return n;
            }
            if (!this.normalizeNumericString(stringVal).equals(normalizedNewVal)) {
                return n;
            }
        }
        n.getParent().replaceChild(n, newNode);
        this.reportCodeChange();
        return newNode;
    }

    private Node tryFoldStringIndexOf(Node n, String functionName, Node lstringNode, Node firstArg) {
        int fromIndex;
        Preconditions.checkArgument((boolean)n.isCall());
        Preconditions.checkArgument((boolean)lstringNode.isString());
        String lstring = NodeUtil.getStringValue(lstringNode);
        boolean isIndexOf = functionName.equals("indexOf");
        Node secondArg = firstArg.getNext();
        String searchValue = NodeUtil.getStringValue(firstArg);
        if (searchValue == null) {
            return n;
        }
        int n2 = fromIndex = isIndexOf ? 0 : lstring.length();
        if (secondArg != null) {
            if (secondArg.getNext() != null || secondArg.getType() != 39) {
                return n;
            }
            fromIndex = (int)secondArg.getDouble();
        }
        int indexVal = isIndexOf ? lstring.indexOf(searchValue, fromIndex) : lstring.lastIndexOf(searchValue, fromIndex);
        Node newNode = Node.newNumber(indexVal);
        n.getParent().replaceChild(n, newNode);
        this.reportCodeChange();
        return newNode;
    }

    private Node tryFoldArrayJoin(Node n) {
        Node callTarget = n.getFirstChild();
        if (callTarget == null || !callTarget.isGetProp()) {
            return n;
        }
        Node right = callTarget.getNext();
        if (!(right == null || right.getNext() == null && NodeUtil.isImmutableValue(right))) {
            return n;
        }
        Node arrayNode = callTarget.getFirstChild();
        Node functionName = arrayNode.getNext();
        if (arrayNode.getType() != 63 || !functionName.getString().equals("join")) {
            return n;
        }
        if (right != null && right.isString() && ",".equals(right.getString())) {
            n.removeChild(right);
            this.reportCodeChange();
        }
        String joinString = right == null ? "," : NodeUtil.getStringValue(right);
        LinkedList arrayFoldedChildren = Lists.newLinkedList();
        StringBuilder sb = null;
        int foldedSize = 0;
        Node prev = null;
        for (Node elem = arrayNode.getFirstChild(); elem != null; elem = elem.getNext()) {
            if (NodeUtil.isImmutableValue(elem) || elem.isEmpty()) {
                if (sb == null) {
                    sb = new StringBuilder();
                } else {
                    sb.append(joinString);
                }
                sb.append(NodeUtil.getArrayElementStringValue(elem));
            } else {
                if (sb != null) {
                    Preconditions.checkNotNull(prev);
                    foldedSize += sb.length() + 2;
                    arrayFoldedChildren.add(Node.newString(sb.toString()).copyInformationFrom(prev));
                    sb = null;
                }
                foldedSize += InlineCostEstimator.getCost(elem);
                arrayFoldedChildren.add(elem);
            }
            prev = elem;
        }
        if (sb != null) {
            Preconditions.checkNotNull(prev);
            foldedSize += sb.length() + 2;
            arrayFoldedChildren.add(Node.newString(sb.toString()).copyInformationFrom(prev));
        }
        foldedSize += arrayFoldedChildren.size() - 1;
        int originalSize = InlineCostEstimator.getCost(n);
        switch (arrayFoldedChildren.size()) {
            case 0: {
                Node emptyStringNode = Node.newString("");
                n.getParent().replaceChild(n, emptyStringNode);
                this.reportCodeChange();
                return emptyStringNode;
            }
            case 1: {
                Node foldedStringNode = (Node)arrayFoldedChildren.remove(0);
                if (foldedSize > originalSize) {
                    return n;
                }
                arrayNode.detachChildren();
                if (foldedStringNode.getType() != 40) {
                    Node replacement;
                    foldedStringNode = replacement = new Node(21, Node.newString("").copyInformationFrom(n), foldedStringNode);
                }
                n.getParent().replaceChild(n, foldedStringNode);
                this.reportCodeChange();
                return foldedStringNode;
            }
        }
        if (arrayFoldedChildren.size() == arrayNode.getChildCount()) {
            return n;
        }
        int kJoinOverhead = "[].join()".length();
        foldedSize += kJoinOverhead;
        if ((foldedSize += right != null ? InlineCostEstimator.getCost(right) : 0) > originalSize) {
            return n;
        }
        arrayNode.detachChildren();
        for (Node node : arrayFoldedChildren) {
            arrayNode.addChildToBack(node);
        }
        this.reportCodeChange();
        return n;
    }

    private Node tryFoldStringSubstr(Node n, Node stringNode, Node arg1) {
        int length;
        Preconditions.checkArgument((boolean)n.isCall());
        Preconditions.checkArgument((boolean)stringNode.isString());
        String stringAsString = stringNode.getString();
        if (arg1 == null || !arg1.isNumber()) {
            return n;
        }
        int start = (int)arg1.getDouble();
        Node arg2 = arg1.getNext();
        if (arg2 != null) {
            if (!arg2.isNumber()) {
                return n;
            }
            length = (int)arg2.getDouble();
            if (arg2.getNext() != null) {
                return n;
            }
        } else {
            length = stringAsString.length() - start;
        }
        if (start + length > stringAsString.length() || length < 0 || start < 0) {
            return n;
        }
        String result = stringAsString.substring(start, start + length);
        Node resultNode = Node.newString(result);
        Node parent = n.getParent();
        parent.replaceChild(n, resultNode);
        this.reportCodeChange();
        return resultNode;
    }

    private Node tryFoldStringSubstring(Node n, Node stringNode, Node arg1) {
        int end;
        Preconditions.checkArgument((boolean)n.isCall());
        Preconditions.checkArgument((boolean)stringNode.isString());
        String stringAsString = stringNode.getString();
        if (arg1 == null || !arg1.isNumber()) {
            return n;
        }
        int start = (int)arg1.getDouble();
        Node arg2 = arg1.getNext();
        if (arg2 != null) {
            if (!arg2.isNumber()) {
                return n;
            }
            end = (int)arg2.getDouble();
            if (arg2.getNext() != null) {
                return n;
            }
        } else {
            end = stringAsString.length();
        }
        if (end > stringAsString.length() || start > stringAsString.length() || end < 0 || start < 0) {
            return n;
        }
        String result = stringAsString.substring(start, end);
        Node resultNode = Node.newString(result);
        Node parent = n.getParent();
        parent.replaceChild(n, resultNode);
        this.reportCodeChange();
        return resultNode;
    }

    private Node tryFoldStringCharAt(Node n, Node stringNode, Node arg1) {
        Preconditions.checkArgument((boolean)n.isCall());
        Preconditions.checkArgument((boolean)stringNode.isString());
        String stringAsString = stringNode.getString();
        if (arg1 == null || !arg1.isNumber() || arg1.getNext() != null) {
            return n;
        }
        int index = (int)arg1.getDouble();
        if (index < 0 || stringAsString.length() <= index) {
            return n;
        }
        Node resultNode = Node.newString(stringAsString.substring(index, index + 1));
        Node parent = n.getParent();
        parent.replaceChild(n, resultNode);
        this.reportCodeChange();
        return resultNode;
    }

    private Node tryFoldStringCharCodeAt(Node n, Node stringNode, Node arg1) {
        Preconditions.checkArgument((boolean)n.isCall());
        Preconditions.checkArgument((boolean)stringNode.isString());
        String stringAsString = stringNode.getString();
        if (arg1 == null || !arg1.isNumber() || arg1.getNext() != null) {
            return n;
        }
        int index = (int)arg1.getDouble();
        if (index < 0 || stringAsString.length() <= index) {
            return n;
        }
        Node resultNode = Node.newNumber(stringAsString.charAt(index));
        Node parent = n.getParent();
        parent.replaceChild(n, resultNode);
        this.reportCodeChange();
        return resultNode;
    }
}

