/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;

class TypeValidator {
    private final AbstractCompiler compiler;
    private final JSTypeRegistry typeRegistry;
    private final JSType allValueTypes;
    private boolean shouldReport = true;
    private final JSType nullOrUndefined;
    private final List<TypeMismatch> mismatches = Lists.newArrayList();
    private static final String FOUND_REQUIRED = "{0}\nfound   : {1}\nrequired: {2}";
    static final DiagnosticType INVALID_CAST = DiagnosticType.warning("JSC_INVALID_CAST", "invalid cast - must be a subtype or supertype\nfrom: {0}\nto  : {1}");
    static final DiagnosticType TYPE_MISMATCH_WARNING = DiagnosticType.warning("JSC_TYPE_MISMATCH", "{0}");
    static final DiagnosticType MISSING_EXTENDS_TAG_WARNING = DiagnosticType.warning("JSC_MISSING_EXTENDS_TAG", "Missing @extends tag on type {0}");
    static final DiagnosticType DUP_VAR_DECLARATION = DiagnosticType.warning("JSC_DUP_VAR_DECLARATION", "variable {0} redefined with type {1}, original definition at {2}:{3} with type {4}");
    static final DiagnosticType HIDDEN_PROPERTY_MISMATCH = DiagnosticType.warning("JSC_HIDDEN_PROPERTY_MISMATCH", "mismatch of the {0} property type and the type of the property it overrides from superclass {1}\noriginal: {2}\noverride: {3}");
    static final DiagnosticType INTERFACE_METHOD_NOT_IMPLEMENTED = DiagnosticType.warning("JSC_INTERFACE_METHOD_NOT_IMPLEMENTED", "property {0} on interface {1} is not implemented by type {2}");
    static final DiagnosticType HIDDEN_INTERFACE_PROPERTY_MISMATCH = DiagnosticType.warning("JSC_HIDDEN_INTERFACE_PROPERTY_MISMATCH", "mismatch of the {0} property type and the type of the property it overrides from interface {1}\noriginal: {2}\noverride: {3}");
    static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(INVALID_CAST, TYPE_MISMATCH_WARNING, MISSING_EXTENDS_TAG_WARNING, DUP_VAR_DECLARATION, HIDDEN_PROPERTY_MISMATCH, INTERFACE_METHOD_NOT_IMPLEMENTED, HIDDEN_INTERFACE_PROPERTY_MISMATCH);

    TypeValidator(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.typeRegistry = compiler.getTypeRegistry();
        this.allValueTypes = this.typeRegistry.createUnionType(JSTypeNative.STRING_TYPE, JSTypeNative.NUMBER_TYPE, JSTypeNative.BOOLEAN_TYPE, JSTypeNative.NULL_TYPE, JSTypeNative.VOID_TYPE);
        this.nullOrUndefined = this.typeRegistry.createUnionType(JSTypeNative.NULL_TYPE, JSTypeNative.VOID_TYPE);
    }

    Iterable<TypeMismatch> getMismatches() {
        return this.mismatches;
    }

    void setShouldReport(boolean report) {
        this.shouldReport = report;
    }

    boolean expectObject(NodeTraversal t, Node n, JSType type, String msg) {
        if (!type.matchesObjectContext()) {
            this.mismatch(t, n, msg, type, JSTypeNative.OBJECT_TYPE);
            return false;
        }
        return true;
    }

    void expectActualObject(NodeTraversal t, Node n, JSType type, String msg) {
        if (!type.isObject()) {
            this.mismatch(t, n, msg, type, JSTypeNative.OBJECT_TYPE);
        }
    }

    void expectAnyObject(NodeTraversal t, Node n, JSType type, String msg) {
        JSType anyObjectType = this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        if (!anyObjectType.isSubtype(type) && !type.isEmptyType()) {
            this.mismatch(t, n, msg, type, anyObjectType);
        }
    }

    void expectString(NodeTraversal t, Node n, JSType type, String msg) {
        if (!type.matchesStringContext()) {
            this.mismatch(t, n, msg, type, JSTypeNative.STRING_TYPE);
        }
    }

    void expectNumber(NodeTraversal t, Node n, JSType type, String msg) {
        if (!type.matchesNumberContext()) {
            this.mismatch(t, n, msg, type, JSTypeNative.NUMBER_TYPE);
        }
    }

    void expectBitwiseable(NodeTraversal t, Node n, JSType type, String msg) {
        if (!type.matchesNumberContext() && !type.isSubtype(this.allValueTypes)) {
            this.mismatch(t, n, msg, type, this.allValueTypes);
        }
    }

    void expectStringOrNumber(NodeTraversal t, Node n, JSType type, String msg) {
        if (!type.matchesNumberContext() && !type.matchesStringContext()) {
            this.mismatch(t, n, msg, type, JSTypeNative.NUMBER_STRING);
        }
    }

    boolean expectNotNullOrUndefined(NodeTraversal t, Node n, JSType type, String msg, JSType expectedType) {
        if (!type.isNoType() && !type.isUnknownType() && type.isSubtype(this.nullOrUndefined) && !this.containsForwardDeclaredUnresolvedName(type)) {
            if (n.isGetProp() && !t.inGlobalScope() && type.isNullType()) {
                return true;
            }
            this.mismatch(t, n, msg, type, expectedType);
            return false;
        }
        return true;
    }

    private boolean containsForwardDeclaredUnresolvedName(JSType type) {
        if (type.isUnionType()) {
            for (JSType alt : type.toMaybeUnionType().getAlternates()) {
                if (!this.containsForwardDeclaredUnresolvedName(alt)) continue;
                return true;
            }
        }
        return type.isNoResolvedType();
    }

    void expectSwitchMatchesCase(NodeTraversal t, Node n, JSType switchType, JSType caseType) {
        if (!(switchType.canTestForShallowEqualityWith(caseType) || caseType.autoboxesTo() != null && caseType.autoboxesTo().isSubtype(switchType))) {
            this.mismatch(t, n.getFirstChild(), "case expression doesn't match switch", caseType, switchType);
        }
    }

    void expectIndexMatch(NodeTraversal t, Node n, JSType objType, JSType indexType) {
        Preconditions.checkState((boolean)n.isGetElem());
        Node indexNode = n.getLastChild();
        if (objType.isUnknownType()) {
            this.expectStringOrNumber(t, indexNode, indexType, "property access");
        } else {
            ObjectType dereferenced = objType.dereference();
            if (dereferenced != null && dereferenced.getIndexType() != null) {
                this.expectCanAssignTo(t, indexNode, indexType, dereferenced.getIndexType(), "restricted index type");
            } else if (dereferenced != null && dereferenced.isArrayType()) {
                this.expectNumber(t, indexNode, indexType, "array access");
            } else if (objType.matchesObjectContext()) {
                this.expectString(t, indexNode, indexType, "property access");
            } else {
                this.mismatch(t, n, "only arrays or objects can be accessed", objType, this.typeRegistry.createUnionType(JSTypeNative.ARRAY_TYPE, JSTypeNative.OBJECT_TYPE));
            }
        }
    }

    boolean expectCanAssignToPropertyOf(NodeTraversal t, Node n, JSType rightType, JSType leftType, Node owner, String propName) {
        if (!leftType.isNoType() && !rightType.canAssignTo(leftType)) {
            if (this.bothIntrinsics(rightType, leftType)) {
                this.registerMismatch(rightType, leftType, null);
            } else {
                this.mismatch(t, n, "assignment to property " + propName + " of " + this.getReadableJSTypeName(owner, true), rightType, leftType);
            }
            return false;
        }
        return true;
    }

    boolean expectCanAssignTo(NodeTraversal t, Node n, JSType rightType, JSType leftType, String msg) {
        if (!rightType.canAssignTo(leftType)) {
            if (this.bothIntrinsics(rightType, leftType)) {
                this.registerMismatch(rightType, leftType, null);
            } else {
                this.mismatch(t, n, msg, rightType, leftType);
            }
            return false;
        }
        return true;
    }

    private boolean bothIntrinsics(JSType rightType, JSType leftType) {
        return !(!leftType.isConstructor() && !leftType.isEnumType() || !rightType.isConstructor() && !rightType.isEnumType());
    }

    void expectArgumentMatchesParameter(NodeTraversal t, Node n, JSType argType, JSType paramType, Node callNode, int ordinal) {
        if (!argType.canAssignTo(paramType)) {
            this.mismatch(t, n, String.format("actual parameter %d of %s does not match formal parameter", ordinal, this.getReadableJSTypeName(callNode.getFirstChild(), false)), argType, paramType);
        }
    }

    void expectCanOverride(NodeTraversal t, Node n, JSType overridingType, JSType hiddenType, String propertyName, JSType ownerType) {
        if (!overridingType.canAssignTo(hiddenType)) {
            this.registerMismatch(overridingType, hiddenType, this.report(t.makeError(n, HIDDEN_PROPERTY_MISMATCH, propertyName, ownerType.toString(), hiddenType.toString(), overridingType.toString())));
        }
    }

    void expectSuperType(NodeTraversal t, Node n, ObjectType superObject, ObjectType subObject) {
        FunctionType subCtor = subObject.getConstructor();
        ObjectType declaredSuper = subObject.getImplicitPrototype().getImplicitPrototype();
        if (!declaredSuper.equals(superObject)) {
            if (declaredSuper.equals(this.getNativeType(JSTypeNative.OBJECT_TYPE))) {
                this.registerMismatch(superObject, declaredSuper, this.report(t.makeError(n, MISSING_EXTENDS_TAG_WARNING, subObject.toString())));
            } else {
                this.mismatch(t.getSourceName(), n, "mismatch in declaration of superclass type", (JSType)superObject, (JSType)declaredSuper);
            }
            if (!subCtor.hasCachedValues()) {
                subCtor.setPrototypeBasedOn(superObject);
            }
        }
    }

    void expectCanCast(NodeTraversal t, Node n, JSType type, JSType castType) {
        castType = castType.restrictByNotNullOrUndefined();
        if (!(type = type.restrictByNotNullOrUndefined()).canAssignTo(castType) && !castType.canAssignTo(type)) {
            this.registerMismatch(type, castType, this.report(t.makeError(n, INVALID_CAST, castType.toString(), type.toString())));
        }
    }

    void expectUndeclaredVariable(String sourceName, CompilerInput input, Node n, Node parent, Scope.Var var, String variableName, JSType newType) {
        JSType varType;
        boolean allowDupe = false;
        if (n.isGetProp() || NodeUtil.isObjectLitKey(n, parent)) {
            JSDocInfo info = n.getJSDocInfo();
            if (info == null) {
                info = parent.getJSDocInfo();
            }
            boolean bl = allowDupe = info != null && info.getSuppressions().contains("duplicate");
        }
        if ((varType = var.getType()) != null && varType != this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE) && newType != null && newType != this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE)) {
            if (var.input == null) {
                Scope s = var.getScope();
                s.undeclare(var);
                s.declare(variableName, n, varType, input, false);
                n.setJSType(varType);
                if (parent.isVar()) {
                    if (n.getFirstChild() != null) {
                        n.getFirstChild().setJSType(varType);
                    }
                } else {
                    Preconditions.checkState((boolean)parent.isFunction());
                    parent.setJSType(varType);
                }
            } else if (!allowDupe && !var.getParentNode().isExprResult() || !newType.equals(varType)) {
                this.report(JSError.make(sourceName, n, DUP_VAR_DECLARATION, variableName, newType.toString(), var.getInputName(), String.valueOf(var.nameNode.getLineno()), varType.toString()));
            }
        }
    }

    void expectAllInterfaceProperties(NodeTraversal t, Node n, FunctionType type) {
        ObjectType instance = type.getInstanceType();
        for (ObjectType implemented : type.getAllImplementedInterfaces()) {
            if (implemented.getImplicitPrototype() == null) continue;
            for (String prop : implemented.getImplicitPrototype().getOwnPropertyNames()) {
                this.expectInterfaceProperty(t, n, instance, implemented, prop);
            }
        }
    }

    private void expectInterfaceProperty(NodeTraversal t, Node n, ObjectType instance, ObjectType implementedInterface, String prop) {
        if (!instance.hasProperty(prop)) {
            String sourceName = n.getSourceFileName();
            sourceName = sourceName == null ? "" : sourceName;
            this.registerMismatch(instance, implementedInterface, this.report(JSError.make(sourceName, n, INTERFACE_METHOD_NOT_IMPLEMENTED, prop, implementedInterface.toString(), instance.toString())));
        } else {
            JSType found = instance.getPropertyType(prop);
            JSType required = implementedInterface.getImplicitPrototype().getPropertyType(prop);
            if (!(found = found.restrictByNotNullOrUndefined()).canAssignTo(required = required.restrictByNotNullOrUndefined())) {
                FunctionType constructor = implementedInterface.toObjectType().getConstructor();
                this.registerMismatch(found, required, this.report(t.makeError(n, HIDDEN_INTERFACE_PROPERTY_MISMATCH, prop, constructor.getTopMostDefiningType(prop).toString(), required.toString(), found.toString())));
            }
        }
    }

    private void mismatch(NodeTraversal t, Node n, String msg, JSType found, JSType required) {
        this.mismatch(t.getSourceName(), n, msg, found, required);
    }

    private void mismatch(NodeTraversal t, Node n, String msg, JSType found, JSTypeNative required) {
        this.mismatch(t, n, msg, found, this.getNativeType(required));
    }

    private void mismatch(String sourceName, Node n, String msg, JSType found, JSType required) {
        this.registerMismatch(found, required, this.report(JSError.make(sourceName, n, TYPE_MISMATCH_WARNING, this.formatFoundRequired(msg, found, required))));
    }

    private void registerMismatch(JSType found, JSType required, JSError error) {
        if ((found = found.restrictByNotNullOrUndefined()).canAssignTo(required = required.restrictByNotNullOrUndefined()) || required.canAssignTo(found)) {
            return;
        }
        this.mismatches.add(new TypeMismatch(found, required, error));
        if (found.isFunctionType() && required.isFunctionType()) {
            FunctionType fnTypeA = found.toMaybeFunctionType();
            FunctionType fnTypeB = required.toMaybeFunctionType();
            Iterator<Node> paramItA = fnTypeA.getParameters().iterator();
            Iterator<Node> paramItB = fnTypeB.getParameters().iterator();
            while (paramItA.hasNext() && paramItB.hasNext()) {
                this.registerIfMismatch(paramItA.next().getJSType(), paramItB.next().getJSType(), error);
            }
            this.registerIfMismatch(fnTypeA.getReturnType(), fnTypeB.getReturnType(), error);
        }
    }

    private void registerIfMismatch(JSType found, JSType required, JSError error) {
        if (found != null && required != null && !found.canAssignTo(required)) {
            this.registerMismatch(found, required, error);
        }
    }

    private String formatFoundRequired(String description, JSType found, JSType required) {
        return MessageFormat.format(FOUND_REQUIRED, description, found, required);
    }

    String getReadableJSTypeName(Node n, boolean dereference) {
        ObjectType dereferenced;
        ObjectType objectType;
        if (n.isGetProp() && (objectType = this.getJSType(n.getFirstChild()).dereference()) != null) {
            String propName = n.getLastChild().getString();
            if (objectType.getConstructor() != null && objectType.getConstructor().isInterface()) {
                objectType = FunctionType.getTopDefiningInterface(objectType, propName);
            } else {
                while (objectType != null && !objectType.hasOwnProperty(propName)) {
                    objectType = objectType.getImplicitPrototype();
                }
            }
            if (objectType != null && (objectType.getConstructor() != null || objectType.isFunctionPrototypeType())) {
                return objectType.toString() + "." + propName;
            }
        }
        JSType type = this.getJSType(n);
        if (dereference && (dereferenced = type.dereference()) != null) {
            type = dereferenced;
        }
        String qualifiedName = n.getQualifiedName();
        if (type.isFunctionPrototypeType() || type.toObjectType() != null && type.toObjectType().getConstructor() != null) {
            return type.toString();
        }
        if (qualifiedName != null) {
            return qualifiedName;
        }
        if (type.isFunctionType()) {
            return "function";
        }
        return type.toString();
    }

    private JSType getJSType(Node n) {
        JSType jsType = n.getJSType();
        if (jsType == null) {
            return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return jsType;
    }

    private JSType getNativeType(JSTypeNative typeId) {
        return this.typeRegistry.getNativeType(typeId);
    }

    private JSError report(JSError error) {
        if (this.shouldReport) {
            this.compiler.report(error);
        }
        return error;
    }

    static class TypeMismatch {
        final JSType typeA;
        final JSType typeB;
        final JSError src;

        TypeMismatch(JSType a, JSType b, JSError src) {
            this.typeA = a;
            this.typeB = b;
            this.src = src;
        }

        public boolean equals(Object object) {
            if (object instanceof TypeMismatch) {
                TypeMismatch that = (TypeMismatch)object;
                return that.typeA.equals(this.typeA) && that.typeB.equals(this.typeB) || that.typeB.equals(this.typeA) && that.typeA.equals(this.typeB);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.typeA, this.typeB});
        }

        public String toString() {
            return "(" + this.typeA + ", " + this.typeB + ")";
        }
    }
}

