/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.api.controller;

import java.io.IOException;
import java.io.OutputStream;
import org.gatein.management.api.ContentType;
import org.gatein.management.api.binding.BindingProvider;
import org.gatein.management.api.binding.Marshaller;
import org.gatein.management.api.controller.ManagedResponse;

public class SuccessfulResponse<T>
implements ManagedResponse {
    private final BindingProvider bindingProvider;
    private final T result;
    private final ContentType contentType;
    private static final ManagedResponse.Outcome success = new ManagedResponse.Outcome(){

        public boolean isSuccess() {
            return true;
        }

        public String getFailureDescription() {
            return null;
        }
    };

    SuccessfulResponse(BindingProvider bindingProvider, T result, ContentType contentType) {
        if (result == null) {
            throw new IllegalArgumentException("result is null.");
        }
        this.bindingProvider = bindingProvider;
        this.result = result;
        this.contentType = contentType;
    }

    public ManagedResponse.Outcome getOutcome() {
        return success;
    }

    public T getResult() {
        return this.result;
    }

    public void writeResult(OutputStream outputStream) throws IOException {
        if (this.bindingProvider == null) {
            throw new IOException("Cannot write result because no binding provider was specified.");
        }
        Class<?> type = this.result.getClass();
        Marshaller marshaller = this.bindingProvider.getMarshaller(type, this.contentType);
        if (marshaller == null) {
            throw new IOException("Could not find marshaller for type " + type + " and content type " + this.contentType);
        }
        marshaller.marshal(this.result, outputStream);
    }
}

