/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.login;

import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.security.GateInToken;
import org.exoplatform.web.security.security.RemindPasswordTokenService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={UIMaskWorkspace.CloseActionListener.class})})
public class UIResetPassword
extends UIForm {
    static final String USER_NAME = "username";
    static final String NEW_PASSWORD = "newpassword";
    static final String CONFIRM_NEW_PASSWORD = "confirmnewpassword";
    static User user_;
    private String tokenId;

    public UIResetPassword() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(USER_NAME, USER_NAME, null).setReadOnly(true));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NEW_PASSWORD, NEW_PASSWORD, null).setType((short)1).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{6, 30}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(CONFIRM_NEW_PASSWORD, CONFIRM_NEW_PASSWORD, null).setType((short)1).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{6, 30}));
    }

    public void setUser(User user) {
        user_ = user;
        this.getUIStringInput(USER_NAME).setValue((Object)user.getUserName());
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public void reset() {
        UIFormStringInput newPasswordForm = this.getUIStringInput(NEW_PASSWORD);
        newPasswordForm.reset();
        UIFormStringInput confirmPasswordForm = this.getUIStringInput(CONFIRM_NEW_PASSWORD);
        confirmPasswordForm.reset();
    }

    public static class SaveActionListener
    extends EventListener<UIResetPassword> {
        public void execute(Event<UIResetPassword> event) throws Exception {
            GateInToken token;
            UIResetPassword uiForm = (UIResetPassword)((Object)event.getSource());
            String newpassword = (String)uiForm.getUIStringInput(UIResetPassword.NEW_PASSWORD).getValue();
            String confirmnewpassword = (String)uiForm.getUIStringInput(UIResetPassword.CONFIRM_NEW_PASSWORD).getValue();
            WebuiRequestContext request = event.getRequestContext();
            UIApplication uiApp = request.getUIApplication();
            UIMaskWorkspace uiMaskWorkspace = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            OrganizationService orgService = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
            RemindPasswordTokenService tokenService = (RemindPasswordTokenService)uiForm.getApplicationComponent(RemindPasswordTokenService.class);
            uiForm.reset();
            boolean setPassword = true;
            if (!newpassword.equals(confirmnewpassword)) {
                uiApp.addMessage(new ApplicationMessage("UIResetPassword.msg.password-is-not-match", null));
                setPassword = false;
            }
            if ((token = tokenService.deleteToken(uiForm.getTokenId())) == null || token.isExpired()) {
                uiApp.addMessage(new ApplicationMessage("UIForgetPassword.msg.expration", null));
                setPassword = false;
            }
            if (setPassword) {
                user_.setPassword(newpassword);
                orgService.getUserHandler().saveUser(user_, true);
                uiMaskWorkspace.createEvent("Close", Event.Phase.DECODE, request).broadcast();
                uiApp.addMessage(new ApplicationMessage("UIResetPassword.msg.change-password-successfully", null));
            }
            request.addUIComponentToUpdateByAjax((UIComponent)uiMaskWorkspace);
        }
    }
}

