/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.common.ListAccessValidator;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.storage.api.RelationshipStorage;

public class ConnectionFilterListAccess
implements ListAccess<Identity> {
    private RelationshipStorage relationshipStorage;
    Identity identity;
    Type type;
    String providerId;
    ProfileFilter profileFilter;

    public ConnectionFilterListAccess(RelationshipStorage relationshipStorage, Identity identity, ProfileFilter filter) {
        this.relationshipStorage = relationshipStorage;
        this.identity = identity;
        this.profileFilter = filter;
    }

    public ConnectionFilterListAccess(RelationshipStorage relationshipStorage, Identity identity, ProfileFilter filter, Type type) {
        this(relationshipStorage, identity, filter);
        this.type = type;
    }

    public Identity[] load(int offset, int limit) throws Exception, IllegalArgumentException {
        ListAccessValidator.validateIndex((int)offset, (int)limit, (int)this.getSize());
        List<Identity> identities = null;
        switch (this.type) {
            case PROFILE_FILTER_CONNECTION: {
                identities = this.relationshipStorage.getConnectionsByFilter(this.identity, this.profileFilter, offset, limit);
                break;
            }
            case PROFILE_FILTER_INCOMMING: {
                identities = this.relationshipStorage.getIncomingByFilter(this.identity, this.profileFilter, offset, limit);
                break;
            }
            case PROFILE_FILTER_OUTGOING: {
                identities = this.relationshipStorage.getOutgoingByFilter(this.identity, this.profileFilter, offset, limit);
            }
        }
        return identities.toArray(new Identity[identities.size()]);
    }

    public int getSize() throws Exception {
        switch (this.type) {
            case PROFILE_FILTER_CONNECTION: {
                return this.relationshipStorage.getConnectionsCountByFilter(this.identity, this.profileFilter);
            }
            case PROFILE_FILTER_INCOMMING: {
                return this.relationshipStorage.getIncomingCountByFilter(this.identity, this.profileFilter);
            }
            case PROFILE_FILTER_OUTGOING: {
                return this.relationshipStorage.getOutgoingCountByFilter(this.identity, this.profileFilter);
            }
        }
        return 0;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public static enum Type {
        PROFILE_FILTER_INCOMMING,
        PROFILE_FILTER_OUTGOING,
        PROFILE_FILTER_CONNECTION;

    }
}

