/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.Writer;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.webui.CSRFTokenUtil;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.bean.BeanDataMapping;
import org.exoplatform.webui.bean.ReflectionDataMapping;
import org.exoplatform.webui.config.Event;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@Serialized
public class UIForm
extends UIContainer {
    public static final String ACTION = "formOp";
    public static final String SUBCOMPONENT_ID = "subComponentId";
    private String[] actions_ = null;
    private String submitAction_;
    private boolean multipart_ = false;
    private transient BeanDataMapping beanMapping = null;

    public UIForm addUIFormInput(UIFormInput input) {
        this.addChild((UIComponent)input);
        return this;
    }

    public UIForm addUIFormInput(UIFormInputSet input) {
        this.addChild((UIComponent)input);
        return this;
    }

    public UIForm addUIComponentInput(UIComponent input) {
        this.addChild(input);
        return this;
    }

    public boolean isMultipart() {
        return this.multipart_;
    }

    public void setMultiPart(boolean b) {
        this.multipart_ = b;
    }

    public String getSubmitAction() {
        return this.submitAction_;
    }

    public void setSubmitAction(String s) {
        this.submitAction_ = s;
    }

    public <T extends UIFormInput> T getUIInput(String name) {
        return (T)((UIFormInput)this.findComponentById(name));
    }

    public UIFormStringInput getUIStringInput(String name) {
        return (UIFormStringInput)this.findComponentById(name);
    }

    public UIFormCheckBoxInput getUIFormCheckBoxInput(String name) {
        return (UIFormCheckBoxInput)this.findComponentById(name);
    }

    public UICheckBoxInput getUICheckBoxInput(String name) {
        return (UICheckBoxInput)this.findComponentById(name);
    }

    public UIFormSelectBox getUIFormSelectBox(String name) {
        return (UIFormSelectBox)this.findComponentById(name);
    }

    public UIFormInputInfo getUIFormInputInfo(String name) {
        return (UIFormInputInfo)this.findComponentById(name);
    }

    public UIFormTextAreaInput getUIFormTextAreaInput(String name) {
        return (UIFormTextAreaInput)this.findComponentById(name);
    }

    public UIFormDateTimeInput getUIFormDateTimeInput(String name) {
        return (UIFormDateTimeInput)this.findComponentById(name);
    }

    public void reset() {
        for (UIComponent uiChild : this.getChildren()) {
            if (!(uiChild instanceof UIFormInput)) continue;
            ((UIFormInput)uiChild).reset();
        }
    }

    public void invokeGetBindingBean(Object bean) throws Exception {
        if (this.beanMapping == null) {
            this.beanMapping = ReflectionDataMapping.getInstance();
        }
        this.beanMapping.mapField(this, bean);
    }

    public void invokeSetBindingBean(Object bean) throws Exception {
        if (this.beanMapping == null) {
            this.beanMapping = ReflectionDataMapping.getInstance();
        }
        this.beanMapping.mapBean(bean, this);
    }

    public void begin() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        String b = context.getURLBuilder().createURL((Object)this, null, null);
        Writer writer = context.getWriter();
        writer.append("<form class=\"UIForm\" id=\"").append(this.getId()).append("\" action=\"").append(b).append('\"');
        if (this.getSubmitAction() != null) {
            writer.append(" onsubmit=\"").append(HTMLEntityEncoder.getInstance().encodeHTMLAttribute(this.getSubmitAction())).append("\"");
        }
        if (this.multipart_) {
            writer.append(" enctype=\"multipart/form-data\"");
        }
        writer.append(" method=\"post\">");
        writer.append("<div><input type=\"hidden\" name=\"").append(ACTION).append("\" value=\"\"/>");
        writer.append("<input type=\"hidden\" name=\"").append("gtn:csrf").append("\" value=\"");
        writer.append(CSRFTokenUtil.getToken());
        writer.append("\"/></div>");
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.getTemplate() != null) {
            super.processRender(context);
            return;
        }
        Writer writer = context.getWriter();
        writer.append("<div class='UIForm ").append(this.getId()).append("'>");
        this.begin();
        this.renderChildren(context);
        this.end();
        writer.append("</div>");
    }

    public void end() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        context.getWriter().write("</form>");
    }

    public void setActions(String[] actions) {
        this.actions_ = actions;
    }

    public String[] getActions() {
        if (this.actions_ != null) {
            return this.actions_;
        }
        List events = this.config.getEvents();
        this.actions_ = new String[events.size()];
        for (int i = 0; i < this.actions_.length; ++i) {
            this.actions_[i] = ((Event)events.get(i)).getName();
        }
        return this.actions_;
    }

    public void renderField(String name) throws Exception {
        UIComponent uiInput = this.findComponentById(name);
        this.renderField(uiInput);
    }

    public void renderField(UIComponent uiInput) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        uiInput.processRender(context);
    }

    private String getFormId() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (context instanceof PortletRequestContext) {
            return ((PortletRequestContext)context).getWindowId() + "#" + this.getId();
        }
        return this.getId();
    }

    public String url(String name) throws Exception {
        StringBuilder b = new StringBuilder();
        b.append("javascript:eXo.webui.UIForm.submitForm('").append(this.getFormId()).append("','");
        b.append(name).append("',false)");
        return b.toString();
    }

    public String event(String name) throws Exception {
        StringBuilder b = new StringBuilder();
        b.append("javascript:eXo.webui.UIForm.submitForm('").append(this.getFormId()).append("','");
        b.append(name).append("',true)");
        return b.toString();
    }

    public String event(String name, String beanId) throws Exception {
        StringBuilder b = new StringBuilder();
        b.append("javascript:eXo.webui.UIForm.submitEvent('").append(this.getFormId()).append("','");
        b.append(name).append("','");
        b.append("&amp;").append("objectId").append("=").append(beanId).append("')");
        return b.toString();
    }

    public String event(String name, String componentId, String beanId) throws Exception {
        StringBuilder b = new StringBuilder();
        b.append("javascript:");
        WebuiRequestContext rcontext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIComponent subComponent = this.findComponentById(componentId);
        Event event = subComponent.getComponentConfig().getUIComponentEventConfig(name);
        if (event == null) {
            return "??config??";
        }
        String confirm = event.getConfirm();
        if (confirm != null && confirm.trim().length() > 0) {
            try {
                confirm = rcontext.getApplicationResourceBundle().getString(confirm);
            }
            catch (MissingResourceException exp) {
                confirm = confirm.substring(confirm.lastIndexOf(46) + 1);
            }
            b.append("if(confirm('").append(confirm.replaceAll("'", "\\\\'")).append("'))");
        }
        b.append("eXo.webui.UIForm.submitEvent('").append(this.getFormId()).append("','");
        b.append(name).append("','");
        b.append("&amp;").append(SUBCOMPONENT_ID).append("=").append(componentId);
        if (beanId != null) {
            b.append("&amp;").append("objectId").append("=").append(beanId);
        }
        b.append("')");
        return b.toString();
    }

    public String getLabel(String id) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        return this.getLabel(res, id);
    }

    public String getLabel(ResourceBundle res, String id) {
        String label = this.getId() + ".label." + id;
        try {
            return res.getString(label);
        }
        catch (MissingResourceException e) {
            return id;
        }
    }

    public String getUIComponentName() {
        return "uiform";
    }
}

