/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import java.util.regex.Pattern;

final class Glob {
    Glob() {
    }

    /*
     * Enabled aggressive block sorting
     */
    static final Pattern globToRegex(String glob) {
        int pos = 0;
        int n = glob.length();
        StringBuilder sb = new StringBuilder(n + 16);
        block5: for (int i = 0; i < n; ++i) {
            String sub = null;
            switch (glob.charAt(i)) {
                case '*': {
                    sub = ".*";
                    break;
                }
                case '?': {
                    sub = ".";
                    break;
                }
                case '\\': {
                    if (pos != i) {
                        sb.append(Pattern.quote(glob.substring(pos, i)));
                    }
                    pos = ++i;
                    continue block5;
                }
            }
            if (sub == null) continue;
            if (pos != i) {
                sb.append(Pattern.quote(glob.substring(pos, i)));
            }
            sb.append(sub);
            pos = i + 1;
        }
        if (pos != n) {
            sb.append(Pattern.quote(glob.substring(pos, n)));
        }
        return Pattern.compile(sb.toString());
    }

    static final String regexToGlob(Pattern p) {
        String re = p.pattern();
        StringBuilder sb = new StringBuilder(re.length());
        int n = re.length();
        block12: for (int i = 0; i < n; ++i) {
            char ch = re.charAt(i);
            switch (ch) {
                case '.': {
                    if (i + 1 < n && re.charAt(i + 1) == '*') {
                        sb.append('*');
                        ++i;
                        continue block12;
                    }
                    if (i + 1 < n && re.charAt(i + 1) == '+') {
                        sb.append("?*");
                        ++i;
                        continue block12;
                    }
                    sb.append('?');
                    continue block12;
                }
                case '$': 
                case '(': 
                case '[': 
                case '^': 
                case '{': {
                    throw new IllegalArgumentException(re);
                }
                case '\\': {
                    if (i + 1 >= n) continue block12;
                    char ch1 = re.charAt(++i);
                    switch (ch1) {
                        case 'n': {
                            sb.append('\n');
                            continue block12;
                        }
                        case 'r': {
                            sb.append('\r');
                            continue block12;
                        }
                        case 't': {
                            sb.append('\t');
                            continue block12;
                        }
                        case 'Q': {
                            int idx = re.indexOf("\\E", i);
                            for (int j = i + 1; j < idx; ++j) {
                                char chq = re.charAt(j);
                                if (chq == '\\' || chq == '*' || chq == '?') {
                                    sb.append('\\');
                                }
                                sb.append(chq);
                            }
                            i = idx + 1;
                            continue block12;
                        }
                        case '*': 
                        case '?': 
                        case '\\': {
                            sb.append('\\').append(ch1);
                            continue block12;
                        }
                    }
                    sb.append(ch1);
                    continue block12;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

