/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.lexer.escaping.UriUtil;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.css.CssParser;
import com.google.caja.parser.css.CssTree;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.ContentType;
import com.google.caja.util.Lists;
import com.google.caja.util.Name;
import com.google.caja.util.Pipeline;
import com.google.caja.util.Sets;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineCssImportsStage
implements Pipeline.Stage<Jobs> {
    private static final int MAXIMUM_IMPORT_DEPTH = 10;

    @Override
    public boolean apply(Jobs jobs) {
        for (Job job : jobs.getJobsByType(ContentType.CSS, new ContentType[0])) {
            InlineCssImportsStage.inlineImports((CssTree.StyleSheet)job.getRoot(), job.getBaseUri(), 10, jobs.getPluginMeta().getUriFetcher(), jobs.getMessageQueue());
        }
        return jobs.hasNoErrors();
    }

    private static void inlineImports(CssTree.StyleSheet ss, URI baseUri, int depth, UriFetcher fetcher, MessageQueue mq) {
        MutableParseTreeNode.Mutation mut = ss.createMutation();
        for (CssTree cssTree : ss.children()) {
            if (!(cssTree instanceof CssTree.Import)) break;
            CssTree.Import importNode = (CssTree.Import)cssTree;
            if (depth == 0) {
                mq.addMessage((MessageTypeInt)PluginMessageType.CYCLIC_INCLUDE, importNode.getFilePosition(), MessagePart.Factory.valueOf(importNode.getUri().getValue()));
                return;
            }
            try {
                InlineCssImportsStage.inlineImport(importNode, baseUri, depth, fetcher, mq, mut);
            }
            catch (ParseException ex) {
                ex.toMessageQueue(mq);
            }
        }
        mut.execute();
    }

    private static void inlineImport(CssTree.Import importNode, URI baseUri, int depth, UriFetcher fetcher, MessageQueue mq, MutableParseTreeNode.Mutation mut) throws ParseException {
        Set<Name> mediaTypes;
        CharProducer cp;
        CssTree.UriLiteral uriNode = importNode.getUri();
        ExternalReference importUrl = null;
        URI absUri = null;
        try {
            absUri = UriUtil.resolve(baseUri, uriNode.getValue());
        }
        catch (URISyntaxException ex) {
            // empty catch block
        }
        if (absUri != null) {
            importUrl = new ExternalReference(absUri, uriNode.getFilePosition());
        }
        if (importUrl == null) {
            mq.addMessage((MessageTypeInt)PluginMessageType.MALFORMED_URL, uriNode.getFilePosition(), MessagePart.Factory.valueOf(uriNode.getValue()));
            return;
        }
        assert (absUri != null);
        try {
            cp = fetcher.fetch(importUrl, "text/css").getTextualContent();
        }
        catch (UriFetcher.UriFetchException ex) {
            mq.addMessage((MessageTypeInt)PluginMessageType.FAILED_TO_LOAD_EXTERNAL_URL, MessageLevel.ERROR, ex.ref.getReferencePosition(), MessagePart.Factory.valueOf(ex.ref.getUri().toString()));
            return;
        }
        catch (UnsupportedEncodingException ex) {
            mq.addMessage((MessageTypeInt)PluginMessageType.FAILED_TO_LOAD_EXTERNAL_URL, MessageLevel.ERROR, importUrl.getReferencePosition(), MessagePart.Factory.valueOf(absUri.toString()));
            return;
        }
        CssTree.StyleSheet importedSs = InlineCssImportsStage.parseCss(cp, mq);
        InlineCssImportsStage.inlineImports(importedSs, importUrl.getUri(), depth - 1, fetcher, mq);
        List<CssTree.Medium> media = importNode.getMedia();
        if (!media.isEmpty() && !(mediaTypes = InlineCssImportsStage.toMediaTypeSet(media)).contains(Name.css("all"))) {
            InlineCssImportsStage.restrictToMediaTypes(importedSs, mediaTypes);
        }
        for (CssTree cssTree : importedSs.children()) {
            mut.insertBefore(cssTree, importNode);
        }
        mut.removeChild(importNode);
    }

    private static void restrictToMediaTypes(CssTree.StyleSheet ss, Set<Name> mediaTypes) {
        MutableParseTreeNode.Mutation mut = ss.createMutation();
        int nonMedia = 0;
        int n = ss.children().size();
        for (int i = 0; i < n; ++i) {
            CssTree child = ss.children().get(i);
            if (!(child instanceof CssTree.Media)) continue;
            CssTree.Media media = (CssTree.Media)child;
            InlineCssImportsStage.wrapInMediaBlock(ss.children().subList(nonMedia, i), mediaTypes, mut);
            nonMedia = i + 1;
            MutableParseTreeNode.Mutation mediaMut = media.createMutation();
            boolean oneAllowed = false;
            List<CssTree.Medium> mediaNodes = media.getMedia();
            if (InlineCssImportsStage.toMediaTypeSet(mediaNodes).contains(Name.css("all"))) {
                oneAllowed = true;
                CssTree.Medium medium0 = mediaNodes.get(0);
                FilePosition pos = medium0.getFilePosition();
                for (Name mediaType : mediaTypes) {
                    mediaMut.insertBefore(new CssTree.Medium(pos, mediaType), medium0);
                }
                for (CssTree.Medium medium : mediaNodes) {
                    mediaMut.removeChild(medium);
                }
            } else {
                for (CssTree.Medium medium : mediaNodes) {
                    if (!mediaTypes.contains(medium.getValue())) {
                        mediaMut.removeChild(medium);
                        continue;
                    }
                    oneAllowed = true;
                }
            }
            if (!oneAllowed) {
                mut.removeChild(media);
                continue;
            }
            mediaMut.execute();
        }
        InlineCssImportsStage.wrapInMediaBlock(ss.children().subList(nonMedia, n), mediaTypes, mut);
        mut.execute();
    }

    private static void wrapInMediaBlock(List<? extends CssTree> nodes, Set<Name> mediaTypes, MutableParseTreeNode.Mutation mut) {
        if (nodes.isEmpty()) {
            return;
        }
        List<? extends CssTree> mediaBlockChildren = Lists.newArrayList();
        FilePosition pos = FilePosition.startOf(nodes.get(0).getFilePosition());
        for (Name mediaType : mediaTypes) {
            mediaBlockChildren.add(new CssTree.Medium(pos, mediaType));
        }
        mediaBlockChildren.addAll(nodes);
        CssTree.Media wrappedBlock = new CssTree.Media(pos, mediaBlockChildren);
        mut.insertBefore(wrappedBlock, nodes.get(0));
        for (CssTree cssTree : nodes) {
            mut.removeChild(cssTree);
        }
    }

    private static CssTree.StyleSheet parseCss(CharProducer cp, MessageQueue mq) throws ParseException {
        TokenQueue<CssTokenType> tq = CssParser.makeTokenQueue(cp, mq, false);
        CssParser p = new CssParser(tq, mq, MessageLevel.WARNING);
        return p.parseStyleSheet();
    }

    private static Set<Name> toMediaTypeSet(List<CssTree.Medium> media) {
        Set<Name> mediaTypes = Sets.newLinkedHashSet();
        for (CssTree.Medium medium : media) {
            mediaTypes.add(medium.getValue());
        }
        return mediaTypes;
    }
}

