/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.templates.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.templates.ContentTypeFilterPlugin;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.templates.impl.TemplatePlugin;
import org.exoplatform.services.context.DocumentContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.DynamicIdentity;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public class TemplateServiceImpl
implements TemplateService,
Startable {
    private RepositoryService repositoryService_;
    private IdentityRegistry identityRegistry_;
    private String cmsTemplatesBasePath_;
    private List<TemplatePlugin> plugins_ = new ArrayList<TemplatePlugin>();
    private Set<String> configuredNodeTypes;
    private HashMap<String, List<String>> foldersFilterMap = null;
    private HashMap<String, List<String>> managedDocumentTypesMap = new HashMap();
    private org.exoplatform.groovyscript.text.TemplateService templateService;
    private LocaleConfigService localeConfigService_;
    private static final Log LOG = ExoLogger.getLogger((String)TemplateService.class.getName());
    private DMSConfiguration dmsConfiguration_;
    private static final String NODETYPE_LIST = "nodeTypeList";
    private static final String EDITED_CONFIGURED_NODE_TYPES = "EditedConfiguredNodeTypes";
    private ExoCache nodeTypeListCached;

    public TemplateServiceImpl(RepositoryService jcrService, NodeHierarchyCreator nodeHierarchyCreator, IdentityRegistry identityRegistry, org.exoplatform.groovyscript.text.TemplateService templateService, DMSConfiguration dmsConfiguration, LocaleConfigService localeConfigService, CacheService caService) throws Exception {
        this.identityRegistry_ = identityRegistry;
        this.repositoryService_ = jcrService;
        this.cmsTemplatesBasePath_ = nodeHierarchyCreator.getJcrPath("templatesPath");
        this.templateService = templateService;
        this.dmsConfiguration_ = dmsConfiguration;
        this.localeConfigService_ = localeConfigService;
        this.nodeTypeListCached = caService.getCacheInstance(TemplateService.class.getName());
    }

    public void start() {
        block3: {
            this.configuredNodeTypes = new HashSet<String>();
            try {
                for (TemplatePlugin plugin : this.plugins_) {
                    plugin.init();
                    this.configuredNodeTypes.addAll(plugin.getAllConfiguredNodeTypes());
                }
                this.getDocumentTemplates();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"An unexpected exception occurs when init plugins", (Throwable)e);
            }
        }
    }

    public void stop() {
    }

    @Override
    public void addContentTypeFilterPlugin(ContentTypeFilterPlugin filterPlugin) {
        HashMap<String, List<String>> folderFilterMap = this.foldersFilterMap;
        if (folderFilterMap == null) {
            folderFilterMap = new HashMap();
        }
        for (ContentTypeFilterPlugin.FolderFilterConfig filterConfig : filterPlugin.getFolderFilterConfigList()) {
            String folderType = filterConfig.getFolderType();
            ArrayList<String> contentTypes = filterConfig.getContentTypes();
            List<String> value = folderFilterMap.get(folderType);
            if (value == null) {
                folderFilterMap.put(folderType, contentTypes);
                continue;
            }
            value.addAll(contentTypes);
            folderFilterMap.put(folderType, value);
        }
        this.foldersFilterMap = folderFilterMap;
    }

    @Override
    public Set<String> getAllowanceFolderType() {
        HashMap<String, List<String>> map = this.foldersFilterMap;
        if (map != null) {
            return map.keySet();
        }
        return null;
    }

    public void addTemplates(ComponentPlugin plugin) {
        if (plugin instanceof TemplatePlugin) {
            this.plugins_.add((TemplatePlugin)plugin);
        }
    }

    @Override
    public void init() throws Exception {
        for (TemplatePlugin plugin : this.plugins_) {
            plugin.init();
        }
    }

    @Override
    public Node getTemplatesHome(SessionProvider provider) throws Exception {
        try {
            Session session = this.getSession(provider);
            return (Node)session.getItem(this.cmsTemplatesBasePath_);
        }
        catch (AccessDeniedException ace) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Access denied. You can not access to this template");
            }
            return null;
        }
    }

    @Override
    public List<String> getCreationableContentTypes(Node node) throws Exception {
        List<String> list;
        String folderType = node.getPrimaryNodeType().getName();
        List<String> testContentTypes = null;
        HashMap<String, List<String>> folderFilterMap = this.foldersFilterMap;
        if (folderFilterMap != null && (list = folderFilterMap.get(folderType)) != null && list.size() != 0) {
            testContentTypes = list;
        }
        if (testContentTypes == null) {
            testContentTypes = this.getDocumentTemplates();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String contentType : testContentTypes) {
            if (!this.isChildNodePrimaryTypeAllowed(node, contentType)) continue;
            result.add(contentType);
        }
        return result;
    }

    public boolean isChildNodePrimaryTypeAllowed(Node parent, String childNodeTypeName) throws Exception {
        NodeType childNodeType = parent.getSession().getWorkspace().getNodeTypeManager().getNodeType(childNodeTypeName);
        if (childNodeType.isMixin()) {
            return true;
        }
        ArrayList<NodeType> allNodeTypes = new ArrayList<NodeType>();
        allNodeTypes.add(parent.getPrimaryNodeType());
        for (NodeType mixin : parent.getMixinNodeTypes()) {
            allNodeTypes.add(mixin);
        }
        for (NodeType nodetype : allNodeTypes) {
            if (!((NodeTypeImpl)nodetype).isChildNodePrimaryTypeAllowed(Constants.JCR_ANY_NAME, ((NodeTypeImpl)childNodeType).getQName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isManagedNodeType(String nodeTypeName) throws Exception {
        List<String> managedDocumentTypes = this.getManagedDocumentTypesMap();
        if (managedDocumentTypes != null && managedDocumentTypes.contains(nodeTypeName)) {
            return true;
        }
        SessionProvider provider = SessionProvider.createSystemProvider();
        Session session = this.getSession(provider);
        try {
            Node systemTemplatesHome = (Node)session.getItem(this.cmsTemplatesBasePath_);
            boolean bl = systemTemplatesHome.hasNode(nodeTypeName);
            return bl;
        }
        finally {
            provider.close();
        }
    }

    @Override
    public String getTemplatePath(Node node, boolean isDialog) throws Exception {
        String userId = node.getSession().getUserID();
        String templateType = null;
        templateType = node.isNodeType("exo:presentationable") && node.hasProperty("exo:presentationType") ? node.getProperty("exo:presentationType").getString() : (node.isNodeType("nt:frozenNode") ? node.getProperty("jcr:frozenPrimaryType").getString() : node.getPrimaryNodeType().getName());
        if (this.isManagedNodeType(templateType)) {
            return this.getTemplatePathByUser(isDialog, templateType, userId);
        }
        String managedTemplateType = this.getManagedTemplateType(node);
        if (StringUtils.isNotEmpty((String)managedTemplateType)) {
            return this.getTemplatePathByUser(isDialog, managedTemplateType, userId);
        }
        throw new Exception("The content type: " + templateType + " isn't supported by any template");
    }

    @Override
    public NodeIterator getAllTemplatesOfNodeType(boolean isDialog, String nodeTypeName, SessionProvider provider) throws Exception {
        Node nodeTypeHome = this.getTemplatesHome(provider).getNode(nodeTypeName);
        if (isDialog) {
            if (!nodeTypeHome.hasNode("dialogs")) {
                return null;
            }
            return nodeTypeHome.getNode("dialogs").getNodes();
        }
        if (!nodeTypeHome.hasNode("views")) {
            return null;
        }
        return nodeTypeHome.getNode("views").getNodes();
    }

    @Override
    public String getDefaultTemplatePath(boolean isDialog, String nodeTypeName) {
        if (isDialog) {
            return this.cmsTemplatesBasePath_ + "/" + nodeTypeName + "/dialogs/dialog1";
        }
        return this.cmsTemplatesBasePath_ + "/" + nodeTypeName + "/views/view1";
    }

    @Override
    public Node getTemplateNode(String type, String nodeTypeName, String templateName, SessionProvider provider) throws Exception {
        Node nodeTypeNode = this.getTemplatesHome(provider).getNode(nodeTypeName);
        return nodeTypeNode.getNode(type).getNode(templateName);
    }

    @Override
    public String getTemplatePathByUser(boolean isDialog, String nodeTypeName, String userName) throws Exception {
        if (IdentityConstants.ANONIM.equals(userName) || DynamicIdentity.DYNAMIC.equals(userName) || userName == null) {
            return this.getTemplatePathByAnonymous(isDialog, nodeTypeName);
        }
        Node templateHomeNode = (Node)this.getSession(WCMCoreUtils.getSystemSessionProvider()).getItem(this.cmsTemplatesBasePath_);
        String type = "dialogs";
        if (!isDialog) {
            type = "views";
        }
        Node nodeTypeNode = templateHomeNode.getNode(nodeTypeName);
        NodeIterator templateIter = nodeTypeNode.getNode(type).getNodes();
        while (templateIter.hasNext()) {
            Node node = templateIter.nextNode();
            String roles = this.getTemplateRoles(node);
            if (!this.hasPermission(userName, roles, this.identityRegistry_)) continue;
            String templatePath = node.getPath();
            return templatePath;
        }
        throw new AccessControlException("You don't have permission to access any template");
    }

    @Override
    public String getTemplatePath(boolean isDialog, String nodeTypeName, String templateName) throws Exception {
        String type = "dialogs";
        if (!isDialog) {
            type = "views";
        }
        Node templateNode = this.getTemplateNode(type, nodeTypeName, templateName);
        String path = templateNode.getPath();
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTemplateLabel(String nodeTypeName) throws Exception {
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node templateHome = this.getTemplatesHome(provider);
            Node nodeType = templateHome.getNode(nodeTypeName);
            if (nodeType.hasProperty("label")) {
                String string = nodeType.getProperty("label").getString();
                return string;
            }
        }
        finally {
            provider.close();
        }
        return "";
    }

    @Override
    public String getTemplate(String type, String nodeTypeName, String templateName) throws Exception {
        Node templateNode = this.getTemplateNode(type, nodeTypeName, templateName);
        return this.getTemplate(templateNode);
    }

    @Override
    public void removeTemplate(String type, String nodeTypeName, String templateName) throws Exception {
        Node templatesHome = (Node)this.getSession(WCMCoreUtils.getSystemSessionProvider()).getItem(this.cmsTemplatesBasePath_);
        Node nodeTypeHome = templatesHome.getNode(nodeTypeName);
        Node specifiedTemplatesHome = nodeTypeHome.getNode(type);
        Node contentNode = specifiedTemplatesHome.getNode(templateName);
        contentNode.remove();
        nodeTypeHome.save();
        this.addEditedConfiguredNodeType(nodeTypeName);
    }

    @Override
    public void removeManagedNodeType(String nodeTypeName) throws Exception {
        Node templatesHome = (Node)this.getSession(WCMCoreUtils.getSystemSessionProvider()).getItem(this.cmsTemplatesBasePath_);
        Node managedNodeType = templatesHome.getNode(nodeTypeName);
        managedNodeType.remove();
        templatesHome.save();
        List<String> managedDocumentTypes = this.getManagedDocumentTypesMap();
        managedDocumentTypes.remove(nodeTypeName);
        this.removeTemplateNodeTypeList();
        this.addEditedConfiguredNodeType(nodeTypeName);
    }

    @Override
    public List<String> getDocumentTemplates() throws Exception {
        ArrayList templates = this.getManagedDocumentTypesMap();
        if (templates != null) {
            return new ArrayList<String>(templates);
        }
        templates = this.getAllDocumentNodeTypes();
        this.setManagedDocumentTypesMap(templates);
        return templates == null ? templates : new ArrayList(templates);
    }

    @Override
    public String getTemplatePathByAnonymous(boolean isDialog, String nodeTypeName) throws Exception {
        String type = "dialogs";
        if (!isDialog) {
            type = "views";
        }
        Node homeNode = (Node)this.getSession(WCMCoreUtils.getSystemSessionProvider()).getItem(this.cmsTemplatesBasePath_);
        Node nodeTypeNode = homeNode.getNode(nodeTypeName);
        NodeIterator templateIter = nodeTypeNode.getNode(type).getNodes();
        while (templateIter.hasNext()) {
            Node node = templateIter.nextNode();
            String role = this.getTemplateRoles(node);
            if (!this.hasPublicTemplate(role)) continue;
            String templatePath = node.getPath();
            return templatePath;
        }
        return null;
    }

    @Override
    public void removeCacheTemplate(String name) throws Exception {
        this.templateService.reloadTemplate(name);
    }

    @Override
    public void removeAllTemplateCached() {
        this.templateService.reloadTemplates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllDocumentNodeTypes() throws Exception {
        List nodeTypeList = (List)this.nodeTypeListCached.get((Serializable)((Object)NODETYPE_LIST));
        if (nodeTypeList != null && nodeTypeList.size() > 0) {
            return nodeTypeList;
        }
        ArrayList<String> contentTypes = new ArrayList<String>();
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            Node templatesHome = (Node)this.getSession(sessionProvider).getItem(this.cmsTemplatesBasePath_);
            NodeIterator templateIter = templatesHome.getNodes();
            while (templateIter.hasNext()) {
                Node template = templateIter.nextNode();
                if (!template.getProperty("isDocumentTemplate").getBoolean()) continue;
                contentTypes.add(template.getName());
            }
            this.nodeTypeListCached.put((Serializable)((Object)NODETYPE_LIST), contentTypes);
        }
        finally {
            sessionProvider.close();
        }
        return contentTypes;
    }

    @Override
    public String getSkinPath(String nodeTypeName, String skinName, String locale) throws Exception {
        Node homeNode = (Node)this.getSession(WCMCoreUtils.getSystemSessionProvider()).getItem(this.cmsTemplatesBasePath_);
        Node nodeTypeNode = homeNode.getNode(nodeTypeName);
        Orientation orientation = this.getOrientation(locale);
        String skinPath = null;
        if (orientation.isLT()) {
            StringBuilder templateData = new StringBuilder("/**");
            templateData.append("LTR stylesheet for " + nodeTypeNode.getName() + " template").append("*/");
            skinPath = this.addNewSkinNode(homeNode, nodeTypeNode, skinName, "-lt", templateData.toString());
        } else if (orientation.isRT()) {
            StringBuilder templateData = new StringBuilder("/**");
            templateData.append("RTL stylesheet for " + nodeTypeNode.getName() + " template").append("*/");
            skinPath = this.addNewSkinNode(homeNode, nodeTypeNode, skinName, "-rt", templateData.toString());
        }
        return skinPath;
    }

    @Override
    public String buildDialogForm(String nodeTypeName) throws Exception {
        if (this.plugins_ == null && this.plugins_.size() == 0) {
            throw new Exception("Cannot find plugin for template");
        }
        TemplatePlugin templatePlugin = this.plugins_.get(0);
        ManageableRepository manageRepo = this.repositoryService_.getCurrentRepository();
        NodeType nodeType = manageRepo.getNodeTypeManager().getNodeType(nodeTypeName);
        return templatePlugin.buildDialogForm(nodeType);
    }

    @Override
    public String buildViewForm(String nodeTypeName) throws Exception {
        if (this.plugins_ == null && this.plugins_.size() == 0) {
            throw new Exception("Cannot find plugin for template");
        }
        TemplatePlugin templatePlugin = this.plugins_.get(0);
        ManageableRepository manageRepo = this.repositoryService_.getCurrentRepository();
        NodeType nodeType = manageRepo.getNodeTypeManager().getNodeType(nodeTypeName);
        return templatePlugin.buildViewForm(nodeType);
    }

    @Override
    public String buildStyleSheet(String nodeTypeName) throws Exception {
        if (this.plugins_ == null && this.plugins_.size() == 0) {
            throw new Exception("Cannot find plugin for template");
        }
        TemplatePlugin templatePlugin = this.plugins_.get(0);
        return templatePlugin.buildStyleSheet(null);
    }

    private Node getTemplateNode(String type, String nodeTypeName, String templateName) throws Exception {
        Node homeNode = (Node)this.getSession(WCMCoreUtils.getSystemSessionProvider()).getItem(this.cmsTemplatesBasePath_);
        Node nodeTypeNode = homeNode.getNode(nodeTypeName);
        return nodeTypeNode.getNode(type).getNode(templateName);
    }

    private String getContentNode(String templateType, Node templatesHome, String nodeTypeName, String label, boolean isDocumentTemplate, String templateName, String[] roles, InputStream templateFile) throws Exception {
        Node nodeTypeHome = null;
        if (!templatesHome.hasNode(nodeTypeName)) {
            nodeTypeHome = Utils.makePath(templatesHome, nodeTypeName, "nt:unstructured");
            if (isDocumentTemplate) {
                nodeTypeHome.setProperty("isDocumentTemplate", true);
            } else {
                nodeTypeHome.setProperty("isDocumentTemplate", false);
            }
            nodeTypeHome.setProperty("label", label);
        } else {
            nodeTypeHome = templatesHome.getNode(nodeTypeName);
        }
        Node specifiedTemplatesHome = null;
        try {
            specifiedTemplatesHome = nodeTypeHome.getNode(templateType);
        }
        catch (PathNotFoundException e) {
            specifiedTemplatesHome = Utils.makePath(nodeTypeHome, templateType, "nt:unstructured");
        }
        String templatePath = null;
        templatePath = specifiedTemplatesHome.hasNode(templateName) ? specifiedTemplatesHome.getNode(templateName).getPath() : this.createTemplate(specifiedTemplatesHome, templateName, templateFile, roles);
        templatesHome.save();
        templatesHome.getSession().save();
        return templatePath;
    }

    private void updateDocumentsTemplate(boolean isDocumentTemplate, String nodeTypeName) throws RepositoryException {
        if (isDocumentTemplate) {
            List<String> documentList = this.getManagedDocumentTypesMap();
            if (documentList == null) {
                documentList = new ArrayList<String>();
                documentList.add(nodeTypeName);
                this.setManagedDocumentTypesMap(documentList);
            } else if (!documentList.contains(nodeTypeName)) {
                documentList.add(nodeTypeName);
                this.setManagedDocumentTypesMap(documentList);
            }
        }
    }

    private Session getSession(SessionProvider provider) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getCurrentRepository();
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
        return provider.getSession(dmsRepoConfig.getSystemWorkspace(), manageableRepository);
    }

    private boolean hasPermission(String userId, String roles, IdentityRegistry identityRegistry) throws Exception {
        if (IdentityConstants.SYSTEM.equalsIgnoreCase(userId)) {
            return true;
        }
        Identity identity = identityRegistry.getIdentity(userId);
        if (identity == null) {
            return false;
        }
        String[] listRoles = roles.split("; ");
        for (int i = 0; i < listRoles.length; ++i) {
            String role = listRoles[i];
            if ("*".equalsIgnoreCase(role)) {
                return true;
            }
            MembershipEntry membershipEntry = MembershipEntry.parse((String)role);
            if (!identity.isMemberOf(membershipEntry)) continue;
            return true;
        }
        return false;
    }

    private boolean hasPublicTemplate(String role) throws Exception {
        String[] roles = role.split("; ");
        for (int i = 0; i < roles.length; ++i) {
            if (!"*".equalsIgnoreCase(roles[i])) continue;
            return true;
        }
        return false;
    }

    private Orientation getOrientation(String locale) throws Exception {
        return this.localeConfigService_.getLocaleConfig(locale).getOrientation();
    }

    private String addNewSkinNode(Node templatesHome, Node nodeTypeNode, String skinName, String orientation, String templateData) throws Exception {
        String label = nodeTypeNode.getProperty("label").getString();
        return this.getContentNode("skins", templatesHome, nodeTypeNode.getName(), label, true, skinName + orientation, new String[]{"*"}, new ByteArrayInputStream(templateData.getBytes()));
    }

    private void removeTemplateNodeTypeList() throws Exception {
        this.nodeTypeListCached.clearCache();
    }

    @Override
    public String addTemplate(String templateType, String nodeTypeName, String label, boolean isDocumentTemplate, String templateName, String[] roles, InputStream templateFile) throws Exception {
        Session session = this.getSession(WCMCoreUtils.getSystemSessionProvider());
        Node templatesHome = (Node)session.getItem(this.cmsTemplatesBasePath_);
        String templatePath = null;
        try {
            templatePath = templatesHome.getPath() + "/" + nodeTypeName + "/" + templateType + "/" + templateName;
            Node templateNode = (Node)session.getItem(templatePath);
            DocumentContext.getCurrent().getAttributes().put("isSkipRaiseActivity", true);
            this.updateTemplate(templateNode, templateFile, roles);
            session.save();
        }
        catch (PathNotFoundException e) {
            DocumentContext.getCurrent().getAttributes().put("isSkipRaiseActivity", true);
            templatePath = this.getContentNode(templateType, templatesHome, nodeTypeName, label, isDocumentTemplate, templateName, roles, templateFile);
        }
        this.removeCacheTemplate(templatePath);
        this.removeTemplateNodeTypeList();
        this.updateDocumentsTemplate(isDocumentTemplate, nodeTypeName);
        return templatePath;
    }

    @Override
    public String addTemplate(String templateType, String nodeTypeName, String label, boolean isDocumentTemplate, String templateName, String[] roles, InputStream templateFile, Node templatesHome) throws Exception {
        String templatePath = null;
        try {
            templatePath = templatesHome.getPath() + "/" + nodeTypeName + "/" + templateType + "/" + templateName;
            Node templateNode = (Node)templatesHome.getSession().getItem(templatePath);
            this.updateTemplate(templateNode, templateFile, roles);
            templateNode.save();
        }
        catch (PathNotFoundException e) {
            templatePath = this.getContentNode(templateType, templatesHome, nodeTypeName, label, isDocumentTemplate, templateName, roles, templateFile);
        }
        this.removeCacheTemplate(templatePath);
        this.removeTemplateNodeTypeList();
        return templatePath;
    }

    @Override
    @Deprecated
    public String createTemplate(Node templateFolder, String name, InputStream data, String[] roles) {
        return this.createTemplate(templateFolder, name, name, data, roles);
    }

    @Override
    public String createTemplate(Node templateFolder, String title, String templateName, InputStream data, String[] roles) {
        try {
            Node contentNode = templateFolder.addNode(templateName, "nt:file");
            Node resourceNode = contentNode.addNode("jcr:content", "exo:resources");
            resourceNode.setProperty("jcr:encoding", "UTF-8");
            resourceNode.setProperty("jcr:mimeType", "application/x-groovy+html");
            resourceNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
            resourceNode.setProperty("jcr:data", data);
            resourceNode.setProperty("exo:roles", roles);
            if (!resourceNode.isNodeType("dc:elementSet")) {
                resourceNode.addMixin("dc:elementSet");
            }
            resourceNode.setProperty("dc:title", new String[]{title});
            resourceNode.getSession().save();
            return contentNode.getPath();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"An error has been occurred when adding template", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public String updateTemplate(Node template, InputStream data, String[] roles) {
        try {
            Node resourceNode = template.getNode("jcr:content");
            resourceNode.setProperty("exo:roles", roles);
            resourceNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
            resourceNode.setProperty("jcr:data", data);
            resourceNode.getSession().save();
            this.addEditedConfiguredNodeType(template.getParent().getParent().getName());
            return template.getPath();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"An error has been occurred when updating template", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public String getTemplate(Node template) {
        block6: {
            try {
                Node resourceNode = template.getNode("jcr:content");
                return resourceNode.getProperty("jcr:data").getString();
            }
            catch (ValueFormatException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Wrong Value format ", (Throwable)e);
                }
            }
            catch (PathNotFoundException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Can not found the template because of: ", (Throwable)e);
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)"Repository failed ", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String getTemplateRoles(Node template) {
        try {
            Value[] values = template.getNode("jcr:content").getProperty("exo:roles").getValues();
            StringBuffer roles = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                if (roles.length() > 0) {
                    roles.append("; ");
                }
                roles.append(values[i].getString());
            }
            return roles.toString();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"An error has been occurred when getting template's roles", (Throwable)e);
            }
            return null;
        }
    }

    private String getRepoName() throws RepositoryException {
        String repositoryName = this.repositoryService_.getCurrentRepository().getConfiguration().getName();
        return repositoryName;
    }

    private List<String> getManagedDocumentTypesMap() throws RepositoryException {
        return this.managedDocumentTypesMap.get(this.getRepoName());
    }

    private void setManagedDocumentTypesMap(List<String> types) throws RepositoryException {
        this.managedDocumentTypesMap.put(this.getRepoName(), types);
    }

    @Override
    public Set<String> getAllConfiguredNodeTypes() {
        return this.configuredNodeTypes;
    }

    @Override
    public Set<String> getAllEditedConfiguredNodeTypes() throws Exception {
        return Utils.getAllEditedConfiguredData(this.getClass().getSimpleName(), EDITED_CONFIGURED_NODE_TYPES, true);
    }

    private void addEditedConfiguredNodeType(String nodeType) throws Exception {
        Utils.addEditedConfiguredData(nodeType, this.getClass().getSimpleName(), EDITED_CONFIGURED_NODE_TYPES, true);
    }

    private String getManagedTemplateType(Node node) throws Exception {
        List<String> managedDocumentTypes = this.getManagedDocumentTypesMap();
        for (String documentType : managedDocumentTypes) {
            if (!node.getPrimaryNodeType().isNodeType(documentType)) continue;
            return documentType;
        }
        SessionProvider provider = WCMCoreUtils.getSystemSessionProvider();
        Session session = this.getSession(provider);
        Node systemTemplatesHome = (Node)session.getItem(this.cmsTemplatesBasePath_);
        NodeIterator templatesIter = systemTemplatesHome.getNodes();
        while (templatesIter.hasNext()) {
            String templateName = templatesIter.nextNode().getName();
            if (!node.getPrimaryNodeType().isNodeType(templateName)) continue;
            return templateName;
        }
        return null;
    }
}

