/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.views.UITabContainer;
import org.exoplatform.ecm.webui.component.admin.views.UITabForm;
import org.exoplatform.ecm.webui.component.admin.views.UIViewForm;
import org.exoplatform.ecm.webui.component.admin.views.UIViewFormTabPane;
import org.exoplatform.ecm.webui.core.UIPagingGrid;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UITabList.msg.confirm-delete"), @EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={AddTabActionListener.class})})
public class UITabList
extends UIPagingGrid {
    public static final String TAPFORM_POPUP = "TabForm_Popup";
    public static String[] TAB_BEAN_FIELD = new String[]{"tabName", "localizeButtons"};
    public static String TAB_LIST = "ECMTabList";
    private String[] actions_ = new String[]{"AddTab"};
    private boolean isView_ = false;
    private String viewName;

    public UITabList() throws Exception {
        this.getUIPageIterator().setId("TabListPageIterator");
        this.configure("tabName", TAB_BEAN_FIELD, new String[]{"Edit", "Delete"});
    }

    public String[] getActions() {
        return this.actions_;
    }

    public void setActions(String[] actions) {
        this.actions_ = actions;
    }

    public boolean isView() {
        return this.isView_;
    }

    public void view(boolean isView) {
        this.isView_ = isView;
    }

    public void refresh(int currentPage) throws Exception {
        List<Object> tabList = new ArrayList();
        UITabContainer uiTabContainer = (UITabContainer)this.getParent();
        UIViewFormTabPane uiTabPane = (UIViewFormTabPane)uiTabContainer.getParent();
        UIViewForm uiViewForm = (UIViewForm)uiTabPane.getChild(UIViewForm.class);
        if (this.isView_) {
            ManageViewService viewService = (ManageViewService)WCMCoreUtils.getService(ManageViewService.class);
            Node viewNode = viewService.getViewByName(this.viewName, WCMCoreUtils.getUserSessionProvider());
            NodeIterator nodeIter = viewNode.getNodes();
            while (nodeIter.hasNext()) {
                Node tabNode = nodeIter.nextNode();
                ViewConfig.Tab tab = new ViewConfig.Tab();
                tab.setTabName(tabNode.getName());
                tab.setButtons(tabNode.getProperty("exo:buttons").getValue().getString());
                tab.setLocalizeButtons(uiViewForm.getLocalizationButtons(tabNode.getProperty("exo:buttons").getValue().getString()));
                tabList.add(tab);
            }
        } else {
            tabList = uiViewForm.getTabs();
        }
        Collections.sort(tabList, new TabComparator());
        ListAccessImpl tabBeanList = new ListAccessImpl(ViewConfig.Tab.class, tabList);
        this.getUIPageIterator().setPageList((PageList)new LazyPageList((ListAccess)tabBeanList, this.getUIPageIterator().getItemsPerPage()));
        this.getUIPageIterator().setTotalItems(tabList.size());
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String name) {
        this.viewName = name;
    }

    public static class TabComparator
    implements Comparator<ViewConfig.Tab> {
        @Override
        public int compare(ViewConfig.Tab o1, ViewConfig.Tab o2) throws ClassCastException {
            String name1 = o1.getTabName();
            String name2 = o2.getTabName();
            return name1.compareToIgnoreCase(name2);
        }
    }

    public static class EditActionListener
    extends EventListener<UITabList> {
        public void execute(Event<UITabList> event) throws Exception {
            UITabList uiTabList = (UITabList)((Object)event.getSource());
            UITabContainer uiContainer = (UITabContainer)uiTabList.getParent();
            String tabName = event.getRequestContext().getRequestParameter("objectId");
            UIViewFormTabPane uiTabPane = (UIViewFormTabPane)uiContainer.getParent();
            UIViewForm uiViewForm = (UIViewForm)uiTabPane.getChild(UIViewForm.class);
            ViewConfig.Tab tab = uiViewForm.getTabMap().get(tabName);
            UITabForm uiTabForm = (UITabForm)uiContainer.createUIComponent(UITabForm.class, null, null);
            uiTabForm.update(tab, false);
            uiContainer.initPopup(UITabList.TAPFORM_POPUP, (UIComponent)uiTabForm, 760, 0);
            uiTabPane.setSelectedTab(uiTabList.getId());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }

    public static class DeleteActionListener
    extends EventListener<UITabList> {
        public void execute(Event<UITabList> event) throws Exception {
            UITabList uiTabList = (UITabList)((Object)event.getSource());
            String tabName = event.getRequestContext().getRequestParameter("objectId");
            UITabContainer uiTabContainer = (UITabContainer)uiTabList.getParent();
            UIViewFormTabPane uiTabPane = (UIViewFormTabPane)uiTabContainer.getParent();
            UIViewForm uiViewForm = (UIViewForm)uiTabPane.getChild(UIViewForm.class);
            uiViewForm.getTabMap().remove(tabName);
            uiTabList.refresh(uiTabList.getUIPageIterator().getCurrentPage());
            uiTabPane.setSelectedTab(uiTabList.getId());
            event.getRequestContext().addUIComponentToUpdateByAjax(uiTabList.getParent());
        }
    }

    public static class AddTabActionListener
    extends EventListener<UITabList> {
        public void execute(Event<UITabList> event) throws Exception {
            UITabList uiTabList = (UITabList)((Object)event.getSource());
            UITabContainer uiContainer = (UITabContainer)uiTabList.getParent();
            UITabForm uiTabForm = (UITabForm)uiContainer.createUIComponent(UITabForm.class, null, null);
            uiContainer.initPopup(UITabList.TAPFORM_POPUP, (UIComponent)uiTabForm, 760, 0);
            UIViewFormTabPane uiTabPane = (UIViewFormTabPane)uiContainer.getParent();
            uiTabPane.setSelectedTab(uiContainer.getId());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }
}

