/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers.principal;

import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.mapping.MappingResult;
import org.jboss.security.mapping.providers.principal.AbstractPrincipalMappingProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePrincipalMappingProvider
extends AbstractPrincipalMappingProvider {
    private static final String PRINCIPALS_MAP = "principalsMap";
    private MappingResult<Principal> result;
    Properties principalMapProperties = null;

    @Override
    public void init(Map<String, Object> options) {
        if (options != null && options.containsKey(PRINCIPALS_MAP)) {
            this.principalMapProperties = (Properties)options.get(PRINCIPALS_MAP);
        }
    }

    @Override
    public void performMapping(Map<String, Object> map, Principal mappedObject) {
        String newPrincipalName;
        if (!(mappedObject instanceof SimplePrincipal)) {
            return;
        }
        SimplePrincipal simplePrincipal = (SimplePrincipal)mappedObject;
        if (this.principalMapProperties != null && (newPrincipalName = this.principalMapProperties.getProperty(simplePrincipal.getName())) != null && newPrincipalName.length() > 0) {
            this.result.setMappedObject(new SimplePrincipal(newPrincipalName));
        }
    }

    @Override
    public void setMappingResult(MappingResult<Principal> result) {
        this.result = result;
    }
}

