/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.classloader;

import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class DelegatingClassLoader
extends ClassLoader {
    private final List<ClassLoader> delegates;
    private static final Logger log = LoggerFactory.getLogger(DelegatingClassLoader.class);

    public DelegatingClassLoader(ClassLoader ... delegates) {
        super(Thread.currentThread().getContextClassLoader());
        if (delegates == null || delegates.length == 0) {
            throw new IllegalArgumentException("Some delegating classloaders needs to be provided");
        }
        this.delegates = Arrays.asList(delegates);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader delegate : this.delegates) {
            try {
                Class<?> cl = delegate.loadClass(name);
                if (cl != null) {
                    return cl;
                }
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Class " + name + " not found with classloader: " + delegate + ". Trying other delegates"));
        }
        throw new ClassNotFoundException("Class " + name + " not found with any of delegates " + this.delegates);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (ClassLoader delegate : this.delegates) {
            InputStream is = delegate.getResourceAsStream(name);
            if (is != null) {
                return is;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Resource " + name + " not found with classloader: " + delegate + ". Trying other delegates"));
        }
        return null;
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader delegate : this.delegates) {
            URL url = delegate.getResource(name);
            if (url != null) {
                return url;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("URL " + name + " not found with classloader: " + delegate + ". Trying other delegates"));
        }
        return null;
    }
}

