/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial.oauth;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthServiceProvider;
import org.apache.shindig.auth.AuthenticationMode;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.crypto.Crypto;
import org.apache.shindig.social.core.oauth.OAuthSecurityToken;
import org.apache.shindig.social.opensocial.oauth.OAuthDataStore;
import org.apache.shindig.social.opensocial.oauth.OAuthEntry;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.opensocial.oauth.ServiceProviderData;
import org.exoplatform.social.opensocial.oauth.ServiceProviderStore;
import org.exoplatform.social.opensocial.service.ExoActivityService;
import org.exoplatform.social.opensocial.service.ExoPeopleService;

public class ExoOAuthDataStore
implements OAuthDataStore {
    private final int CALLBACK_TOKEN_LENGTH = 6;
    private final int CALLBACK_TOKEN_ATTEMPTS = 5;
    private final ExoPeopleService peopleService;
    private final ExoActivityService activityService;
    private final OAuthServiceProvider SERVICE_PROVIDER;
    private ServiceProviderStore providerStore;
    private static final Log LOG = ExoLogger.getExoLogger(ExoOAuthDataStore.class);
    private static ConcurrentMap<String, OAuthEntry> oauthEntries = new MapMaker().makeMap();

    @Inject
    public ExoOAuthDataStore(ExoPeopleService peopleService, ExoActivityService activityService, @Named(value="shindig.oauth.base-url") String baseUrl) {
        this.peopleService = peopleService;
        this.activityService = activityService;
        this.SERVICE_PROVIDER = new OAuthServiceProvider(baseUrl + "requestToken", baseUrl + "authorize", baseUrl + "accessToken");
    }

    public OAuthEntry getEntry(String oauthToken) {
        Preconditions.checkNotNull((Object)oauthToken);
        return (OAuthEntry)oauthEntries.get(oauthToken);
    }

    public OAuthConsumer getConsumer(String consumerKey) {
        try {
            ServiceProviderData data = this.getProviderStore().getServiceProvider(consumerKey);
            if (data == null) {
                LOG.warn((Object)("No provider was found for consumer key: " + consumerKey));
                return null;
            }
            String consumerSecret = data.getSharedSecret();
            if (consumerSecret == null) {
                return null;
            }
            String callbackUrl = data.getCallbackUrl();
            OAuthConsumer consumer = new OAuthConsumer(callbackUrl, consumerKey, consumerSecret, this.SERVICE_PROVIDER);
            return consumer;
        }
        catch (Exception e) {
            return null;
        }
    }

    public OAuthEntry generateRequestToken(String consumerKey, String oauthVersion, String signedCallbackUrl) {
        OAuthEntry entry = new OAuthEntry();
        entry.setAppId(consumerKey);
        entry.setConsumerKey(consumerKey);
        entry.setDomain("samplecontainer.com");
        entry.setContainer("default");
        entry.setToken(UUID.randomUUID().toString());
        entry.setTokenSecret(UUID.randomUUID().toString());
        entry.setType(OAuthEntry.Type.REQUEST);
        entry.setIssueTime(new Date());
        entry.setOauthVersion(oauthVersion);
        if (signedCallbackUrl != null) {
            entry.setCallbackUrlSigned(true);
            entry.setCallbackUrl(signedCallbackUrl);
        }
        oauthEntries.put(entry.getToken(), entry);
        return entry;
    }

    public OAuthEntry convertToAccessToken(OAuthEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        Preconditions.checkState((entry.getType() == OAuthEntry.Type.REQUEST ? 1 : 0) != 0, (Object)"Token must be a request token");
        OAuthEntry accessEntry = new OAuthEntry(entry);
        accessEntry.setToken(UUID.randomUUID().toString());
        accessEntry.setTokenSecret(UUID.randomUUID().toString());
        accessEntry.setType(OAuthEntry.Type.ACCESS);
        accessEntry.setIssueTime(new Date());
        oauthEntries.remove(entry.getToken());
        oauthEntries.put(accessEntry.getToken(), accessEntry);
        return accessEntry;
    }

    public void authorizeToken(OAuthEntry entry, String userId) {
        Preconditions.checkNotNull((Object)entry);
        entry.setAuthorized(true);
        entry.setUserId((String)Preconditions.checkNotNull((Object)userId));
        if (entry.isCallbackUrlSigned()) {
            entry.setCallbackToken(Crypto.getRandomDigits((int)6));
        }
    }

    public void disableToken(OAuthEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        entry.setCallbackTokenAttempts(entry.getCallbackTokenAttempts() + 1);
        if (!entry.isCallbackUrlSigned() || entry.getCallbackTokenAttempts() >= 5) {
            entry.setType(OAuthEntry.Type.DISABLED);
        }
        oauthEntries.put(entry.getToken(), entry);
    }

    public void removeToken(OAuthEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        oauthEntries.remove(entry.getToken());
    }

    public SecurityToken getSecurityTokenForConsumerRequest(String consumerKey, String userId) {
        String domain = "samplecontainer.com";
        String container = "default";
        return new OAuthSecurityToken(userId, null, consumerKey, domain, container, null, AuthenticationMode.OAUTH_CONSUMER_REQUEST.name());
    }

    public ServiceProviderStore getProviderStore() {
        if (this.providerStore == null) {
            PortalContainer container = PortalContainer.getInstance();
            this.providerStore = (ServiceProviderStore)container.getComponentInstanceOfType(ServiceProviderStore.class);
        }
        return this.providerStore;
    }

    public void setProviderStore(ServiceProviderStore secretProvider) {
        this.providerStore = secretProvider;
    }
}

