/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class BriefJUnitResultFormatter
implements JUnitResultFormatter {
    private static final double ONE_SECOND = 1000.0;
    private OutputStream out;
    private BufferedWriter output;
    private StringWriter results;
    private BufferedWriter resultWriter;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private String systemOutput = null;
    private String systemError = null;

    public BriefJUnitResultFormatter() {
        this.results = new StringWriter();
        this.resultWriter = new BufferedWriter(this.results);
    }

    public void setOutput(OutputStream out) {
        this.out = out;
        this.output = new BufferedWriter(new OutputStreamWriter(out));
    }

    public void setSystemOutput(String out) {
        this.systemOutput = out;
    }

    public void setSystemError(String err) {
        this.systemError = err;
    }

    public void startTestSuite(JUnitTest suite) {
        if (this.output == null) {
            return;
        }
        StringBuffer sb = new StringBuffer("Testsuite: ");
        sb.append(suite.getName());
        sb.append(StringUtils.LINE_SEP);
        try {
            this.output.write(sb.toString());
            this.output.flush();
        }
        catch (IOException ex) {
            throw new BuildException(ex);
        }
    }

    /*
     * Loose catch block
     */
    public void endTestSuite(JUnitTest suite) {
        block13: {
            StringBuffer sb = new StringBuffer("Tests run: ");
            sb.append(suite.runCount());
            sb.append(", Failures: ");
            sb.append(suite.failureCount());
            sb.append(", Errors: ");
            sb.append(suite.errorCount());
            sb.append(", Time elapsed: ");
            sb.append(this.numberFormat.format((double)suite.getRunTime() / 1000.0));
            sb.append(" sec");
            sb.append(StringUtils.LINE_SEP);
            sb.append(StringUtils.LINE_SEP);
            if (this.systemOutput != null && this.systemOutput.length() > 0) {
                sb.append("------------- Standard Output ---------------").append(StringUtils.LINE_SEP).append(this.systemOutput).append("------------- ---------------- ---------------").append(StringUtils.LINE_SEP);
            }
            if (this.systemError != null && this.systemError.length() > 0) {
                sb.append("------------- Standard Error -----------------").append(StringUtils.LINE_SEP).append(this.systemError).append("------------- ---------------- ---------------").append(StringUtils.LINE_SEP);
            }
            if (this.output != null) {
                this.output.write(sb.toString());
                this.resultWriter.close();
                this.output.write(this.results.toString());
                Object var5_3 = null;
                try {
                    this.output.flush();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (this.out != System.out && this.out != System.err) {
                    FileUtils.close(this.out);
                }
                break block13;
                {
                    catch (IOException ex) {
                        throw new BuildException(ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    try {
                        this.output.flush();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    if (this.out != System.out && this.out != System.err) {
                        FileUtils.close(this.out);
                    }
                    throw throwable;
                }
            }
        }
    }

    public void startTest(Test test) {
    }

    public void endTest(Test test) {
    }

    public void addFailure(Test test, Throwable t) {
        this.formatError("\tFAILED", test, t);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void addError(Test test, Throwable error) {
        this.formatError("\tCaused an ERROR", test, error);
    }

    protected String formatTest(Test test) {
        if (test == null) {
            return "Null Test: ";
        }
        return "Testcase: " + test.toString() + ":";
    }

    protected synchronized void formatError(String type, Test test, Throwable error) {
        if (test != null) {
            this.endTest(test);
        }
        try {
            this.resultWriter.write(this.formatTest(test) + type);
            this.resultWriter.newLine();
            this.resultWriter.write(String.valueOf(error.getMessage()));
            this.resultWriter.newLine();
            String strace = JUnitTestRunner.getFilteredTrace(error);
            this.resultWriter.write(strace);
            this.resultWriter.newLine();
            this.resultWriter.newLine();
        }
        catch (IOException ex) {
            throw new BuildException(ex);
        }
    }
}

