/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.tika.config.LoadErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLoader {
    private static volatile ClassLoader contextClassLoader = null;
    private static final Map<Object, Object> services = new HashMap<Object, Object>();
    private final ClassLoader loader;
    private final LoadErrorHandler handler;
    private final boolean dynamic;
    private static final Pattern COMMENT = Pattern.compile("#.*");
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");

    static ClassLoader getContextClassLoader() {
        ClassLoader loader = contextClassLoader;
        if (loader == null) {
            loader = ServiceLoader.class.getClassLoader();
        }
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    public static void setContextClassLoader(ClassLoader loader) {
        contextClassLoader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addService(Object reference, Object service) {
        Map<Object, Object> map = services;
        synchronized (map) {
            services.put(reference, service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object removeService(Object reference) {
        Map<Object, Object> map = services;
        synchronized (map) {
            return services.remove(reference);
        }
    }

    public ServiceLoader(ClassLoader loader, LoadErrorHandler handler, boolean dynamic) {
        this.loader = loader;
        this.handler = handler;
        this.dynamic = dynamic;
    }

    public ServiceLoader(ClassLoader loader, LoadErrorHandler handler) {
        this(loader, handler, false);
    }

    public ServiceLoader(ClassLoader loader) {
        this(loader, LoadErrorHandler.IGNORE);
    }

    public ServiceLoader() {
        this(ServiceLoader.getContextClassLoader(), LoadErrorHandler.IGNORE, true);
    }

    public InputStream getResourceAsStream(String name) {
        if (this.loader != null) {
            return this.loader.getResourceAsStream(name);
        }
        return null;
    }

    public <T> Class<? extends T> getServiceClass(Class<T> iface, String name) throws ClassNotFoundException {
        if (this.loader == null) {
            throw new ClassNotFoundException("Service class " + name + " is not available");
        }
        Class<?> klass = Class.forName(name, true, this.loader);
        if (klass.isInterface()) {
            throw new ClassNotFoundException("Service class " + name + " is an interface");
        }
        if (!iface.isAssignableFrom(klass)) {
            throw new ClassNotFoundException("Service class " + name + " does not implement " + iface.getName());
        }
        return klass;
    }

    public Enumeration<URL> findServiceResources(String filePattern) {
        try {
            Enumeration<URL> resources = this.loader.getResources(filePattern);
            return resources;
        }
        catch (IOException ignore) {
            List empty = Collections.emptyList();
            return Collections.enumeration(empty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> loadServiceProviders(Class<T> iface) {
        ArrayList<Object> providers = new ArrayList<Object>();
        if (this.dynamic) {
            Map<Object, Object> map = services;
            synchronized (map) {
                for (Object service : services.values()) {
                    if (!iface.isAssignableFrom(service.getClass())) continue;
                    providers.add(service);
                }
            }
        }
        if (this.loader != null) {
            HashSet<String> names = new HashSet<String>();
            String serviceName = iface.getName();
            Enumeration<URL> resources = this.findServiceResources("META-INF/services/" + serviceName);
            for (URL resource : Collections.list(resources)) {
                try {
                    names.addAll(this.getServiceClassNames(resource));
                }
                catch (IOException e) {
                    this.handler.handleLoadError(serviceName, e);
                }
            }
            for (String name : names) {
                try {
                    Class<?> klass = this.loader.loadClass(name);
                    if (!iface.isAssignableFrom(klass)) continue;
                    providers.add(klass.newInstance());
                }
                catch (Throwable t) {
                    this.handler.handleLoadError(name, t);
                }
            }
        }
        return providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getServiceClassNames(URL resource) throws IOException {
        HashSet<String> names = new HashSet<String>();
        InputStream stream = resource.openStream();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            String line = reader.readLine();
            while (line != null) {
                line = COMMENT.matcher(line).replaceFirst("");
                if ((line = WHITESPACE.matcher(line).replaceAll("")).length() > 0) {
                    names.add(line);
                }
                line = reader.readLine();
            }
        }
        finally {
            stream.close();
        }
        return names;
    }
}

