/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.log;

import java.util.Map;
import java.util.Properties;
import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.LogConfigurator;
import org.picocontainer.Startable;

public class LogConfigurationInitializer
implements Startable {
    private Map properties = null;
    private String logger = null;
    private String configurer = null;

    public LogConfigurationInitializer(InitParams params) throws Exception {
        PropertiesParam p;
        ValueParam confValue;
        ValueParam loggerValue = params.getValueParam("logger");
        if (loggerValue != null) {
            this.logger = loggerValue.getValue();
        }
        if ((confValue = params.getValueParam("configurator")) != null) {
            this.configurer = confValue.getValue();
        }
        if ((p = params.getPropertiesParam("properties")) != null) {
            this.properties = p.getProperties();
        }
        this.initLogger();
    }

    public LogConfigurationInitializer(String logger, String configurator, Properties properties) throws Exception {
        this.logger = logger;
        this.configurer = configurator;
        this.properties = properties;
        this.initLogger();
    }

    public String getLoggerClass() {
        return this.logger;
    }

    public String getConfiguratorClass() {
        return this.configurer;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperty(String name, String value) throws Exception {
        this.properties.put(name, value);
        this.initLogger();
    }

    public void removeProperty(String name) throws Exception {
        this.properties.remove(name);
        this.initLogger();
    }

    public void start() {
    }

    public void stop() {
    }

    private void initLogger() throws Exception {
        if (this.configurer != null && this.properties != null) {
            LogConfigurator conf = (LogConfigurator)ClassLoading.forName((String)this.configurer, (Object)this).newInstance();
            Properties props = new Properties();
            props.putAll((Map<?, ?>)this.properties);
            conf.configure(props);
        }
    }
}

